/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enchancedcelestials.util;

import corgitaco.enchancedcelestials.EnhancedCelestials;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class EnhancedCelestialsUtils {
    public static final int CHUNK_AREA = (int)Math.pow(17.0, 2.0);
    public static final Tags.IOptionalNamedTag<Item> FRUITS = EnhancedCelestialsUtils.forgeTag("fruits");
    public static final Tags.IOptionalNamedTag<Item> VEGETABLES = EnhancedCelestialsUtils.forgeTag("vegetable");
    public static final Tags.IOptionalNamedTag<Block> HARVEST_MOON_WHITELISTED_CROP_GROWTH = EnhancedCelestialsUtils.ecBlockTag("harvest_moon_whitelisted_crop_growth");
    public static final Tags.IOptionalNamedTag<Block> HARVEST_MOON_BLACKLISTED_CROP_GROWTH = EnhancedCelestialsUtils.ecBlockTag("harvest_moon_blacklisted_crop_growth");
    public static final Tags.IOptionalNamedTag<Item> HARVEST_MOON_WHITELISTED_CROP_DROPS = EnhancedCelestialsUtils.ecItemTag("harvest_moon_whitelisted_crop_drops");
    public static final Tags.IOptionalNamedTag<Item> HARVEST_MOON_BLACKLISTED_CROP_DROPS = EnhancedCelestialsUtils.ecItemTag("harvest_moon_blacklisted_crop_drops");

    public static void modifySpawnCap(EntityClassification mobCategory, int spawningChunkCount, Object2IntOpenHashMap<EntityClassification> currentMobCategoryCounts, CallbackInfoReturnable<Boolean> cir) {
        EnhancedCelestials.currentLunarEvent.multiplySpawnCap(mobCategory, spawningChunkCount, currentMobCategoryCounts, cir);
    }

    public static boolean isOverworld(RegistryKey<World> worldKey) {
        return worldKey == World.field_234918_g_;
    }

    public static Color transformFloatColor(Vector3d floatColor) {
        return new Color((int)(floatColor.func_82615_a() * 255.0), (int)(floatColor.func_82617_b() * 255.0), (int)(floatColor.func_82616_c() * 255.0));
    }

    private static Tags.IOptionalNamedTag<Item> forgeTag(String name) {
        return ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", name));
    }

    private static Tags.IOptionalNamedTag<Item> ecItemTag(String name) {
        return ItemTags.createOptional((ResourceLocation)new ResourceLocation("enhancedcelestials", name));
    }

    private static Tags.IOptionalNamedTag<Block> ecBlockTag(String name) {
        return BlockTags.createOptional((ResourceLocation)new ResourceLocation("enhancedcelestials", name));
    }

    public static boolean filterRegistryID(ResourceLocation id, Registry<?> registry, String registryTypeName) {
        if (registry.func_148742_b().contains(id)) {
            return true;
        }
        EnhancedCelestials.LOGGER.error("\"" + id.toString() + "\" was not a registryID in the " + registryTypeName + "! Skipping entry...");
        return false;
    }

    public static long modulosDaytime(long daytime) {
        return daytime % 24000L;
    }
}

