/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enchancedcelestials.lunarevent;

import corgitaco.enchancedcelestials.EnhancedCelestials;
import corgitaco.enchancedcelestials.data.network.NetworkHandler;
import corgitaco.enchancedcelestials.data.network.packet.LunarEventPacket;
import corgitaco.enchancedcelestials.lunarevent.BloodMoon;
import corgitaco.enchancedcelestials.lunarevent.Default;
import corgitaco.enchancedcelestials.lunarevent.HarvestMoon;
import corgitaco.enchancedcelestials.lunarevent.LunarEvent;
import corgitaco.enchancedcelestials.util.EnhancedCelestialsUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class LunarEventSystem {
    public static final String BLOOD_MOON_EVENT_ID = "BLOOD_MOON";
    public static final String DEFAULT_EVENT_ID = "DEFAULT";
    public static final String HARVEST_MOON_EVENT_ID = "HARVEST_MOON";
    public static final BloodMoon BLOOD_MOON_EVENT = new BloodMoon();
    public static final Default DEFAULT_EVENT = new Default();
    public static final HarvestMoon HARVEST_MOON_EVENT = new HarvestMoon();
    public static HashMap<String, Double> LUNAR_EVENTS_CONTROLLER = new HashMap();
    public static HashMap<String, LunarEvent> LUNAR_EVENTS_MAP = new HashMap();
    public static ObjectOpenHashSet<LunarEvent> LUNAR_EVENTS = new ObjectOpenHashSet();
    private static LunarEvent cachedLunarEvent = DEFAULT_EVENT;

    public static void registerDefaultLunarEvents() {
        LUNAR_EVENTS.add((Object)BLOOD_MOON_EVENT);
        LUNAR_EVENTS.add((Object)DEFAULT_EVENT);
        LUNAR_EVENTS.add((Object)HARVEST_MOON_EVENT);
    }

    public static void fillLunarEventsMapAndWeatherEventController() {
        for (LunarEvent lunarEvent : LUNAR_EVENTS) {
            LUNAR_EVENTS_MAP.put(lunarEvent.getID(), lunarEvent);
            if (lunarEvent.getID().equals(DEFAULT_EVENT_ID)) continue;
            LUNAR_EVENTS_CONTROLLER.put(lunarEvent.getID(), lunarEvent.getChance());
        }
    }

    public static void updateLunarEventPacket(ServerWorld world) {
        long dayTime = EnhancedCelestialsUtils.modulosDaytime(world.func_72912_H().func_76073_f());
        if (dayTime >= 13000L && dayTime <= 23500L) {
            LunarEvent currentLunarEvent = LUNAR_EVENTS_MAP.get(EnhancedCelestials.getLunarData((IWorld)world).getEvent());
            if (!cachedLunarEvent.equals(currentLunarEvent)) {
                world.func_217369_A().forEach(player -> NetworkHandler.sendToClient(player, new LunarEventPacket(currentLunarEvent.getID())));
                cachedLunarEvent = currentLunarEvent;
            }
        } else {
            LunarEvent currentLunarEvent = LUNAR_EVENTS_MAP.get(EnhancedCelestials.getLunarData((IWorld)world).getEvent());
            if (currentLunarEvent != DEFAULT_EVENT) {
                EnhancedCelestials.getLunarData((IWorld)world).setEvent(DEFAULT_EVENT_ID);
                world.func_217369_A().forEach(player -> NetworkHandler.sendToClient(player, new LunarEventPacket(DEFAULT_EVENT_ID)));
            }
        }
    }
}

