/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.block;

import com.google.common.collect.Maps;
import com.minecraftabnormals.environmental.common.block.BirdNestBlock;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EmptyNestBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private final Map<Supplier<? extends Item>, Block> NESTS = Maps.newHashMap();

    public EmptyNestBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public void addNest(Supplier<? extends Item> egg, Block nest) {
        this.NESTS.put(egg, nest);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_175142_cm()) {
            ItemStack itemstack = player.func_184586_b(handIn);
            Item item = itemstack.func_77973_b();
            Block nest = null;
            for (Supplier<? extends Item> supplier : this.NESTS.keySet()) {
                if (item != supplier.get()) continue;
                nest = this.NESTS.get(supplier);
                break;
            }
            if (nest != null && ((BirdNestBlock)nest).getEgg() != Items.field_190931_a) {
                if (!player.field_71075_bZ.field_75098_d && !worldIn.field_72995_K) {
                    itemstack.func_190918_g(1);
                }
                worldIn.func_180501_a(pos, nest.func_176223_P(), 3);
                return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
            }
            return ActionResultType.CONSUME;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    public Block getNest(Item item) {
        Block nest = null;
        for (Supplier<? extends Item> supplier : this.NESTS.keySet()) {
            if (item != supplier.get()) continue;
            nest = this.NESTS.get(supplier);
            break;
        }
        return nest;
    }
}

