/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.entity;

import com.minecraftabnormals.abnormals_core.core.api.IBucketableEntity;
import com.minecraftabnormals.environmental.common.entity.goals.SlabbyBreedGoal;
import com.minecraftabnormals.environmental.common.entity.goals.SlabbyFollowParentGoal;
import com.minecraftabnormals.environmental.common.entity.goals.SlabbyGrabItemGoal;
import com.minecraftabnormals.environmental.common.entity.util.SlabfishOverlay;
import com.minecraftabnormals.environmental.common.entity.util.SlabfishRarity;
import com.minecraftabnormals.environmental.common.inventory.SlabfishInventory;
import com.minecraftabnormals.environmental.common.inventory.container.SlabfishInventoryContainer;
import com.minecraftabnormals.environmental.common.network.message.SOpenSlabfishInventoryMessage;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishManager;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishType;
import com.minecraftabnormals.environmental.common.slabfish.SweaterType;
import com.minecraftabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import com.minecraftabnormals.environmental.core.Environmental;
import com.minecraftabnormals.environmental.core.other.EnvironmentalCriteriaTriggers;
import com.minecraftabnormals.environmental.core.other.EnvironmentalDataSerializers;
import com.minecraftabnormals.environmental.core.other.EnvironmentalTags;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalEntities;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalItems;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalSounds;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SlabfishEntity
extends TameableEntity
implements IInventoryChangedListener,
IBucketableEntity {
    private static final DataParameter<ResourceLocation> SLABFISH_TYPE = EntityDataManager.func_187226_a(SlabfishEntity.class, EnvironmentalDataSerializers.RESOURCE_LOCATION);
    private static final DataParameter<Integer> SLABFISH_OVERLAY = EntityDataManager.func_187226_a(SlabfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(SlabfishEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ResourceLocation> BACKPACK = EntityDataManager.func_187226_a(SlabfishEntity.class, EnvironmentalDataSerializers.RESOURCE_LOCATION);
    private static final DataParameter<Boolean> HAS_BACKPACK = EntityDataManager.func_187226_a(SlabfishEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ResourceLocation> SWEATER = EntityDataManager.func_187226_a(SlabfishEntity.class, EnvironmentalDataSerializers.RESOURCE_LOCATION);
    public static final EntitySize SIZE_SWIMMING = EntitySize.func_220311_c((float)0.7f, (float)0.6f);
    public static final EntitySize SIZE_SITTING = EntitySize.func_220311_c((float)0.45f, (float)0.6f);
    public static final EntitySize SIZE_SWIMMING_CHILD = EntitySize.func_220311_c((float)0.35f, (float)0.3f);
    public static final EntitySize SIZE_SITTING_CHILD = EntitySize.func_220311_c((float)0.225f, (float)0.3f);
    public SlabfishInventory slabfishBackpack;
    public boolean backpackFull;
    public int playersUsing;
    private UUID lightningUUID;
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    public boolean isPartying = false;
    BlockPos jukeboxPosition;
    private boolean clearing;
    private LazyOptional<?> itemHandler = null;

    public SlabfishEntity(EntityType<? extends SlabfishEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.slabfishBackpack = new SlabfishInventory(this);
        this.slabfishBackpack.addListener(this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.slabfishBackpack));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 15.0).func_233815_a_(Attributes.field_233821_d_, 0.3);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, LivingEntity.class, entity -> EntityTypeTags.field_219765_b.func_230235_a_((Object)entity.func_200600_R()), 15.0f, 1.0, 1.5, EntityPredicates.field_188444_d::test));
        this.field_70714_bg.func_75776_a(4, (Goal)new SlabbyBreedGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new SlabbyGrabItemGoal(this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, Ingredient.func_199805_a(EnvironmentalTags.Items.SLABFISH_TEMPTATION_ITEMS)));
        this.field_70714_bg.func_75776_a(8, (Goal)new SlabbyFollowParentGoal(this, 1.1));
        this.field_70714_bg.func_75776_a(9, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SLABFISH_TYPE, (Object)SlabfishManager.DEFAULT_SLABFISH.getRegistryName());
        this.func_184212_Q().func_187214_a(SLABFISH_OVERLAY, (Object)0);
        this.func_184212_Q().func_187214_a(FROM_BUCKET, (Object)false);
        this.func_184212_Q().func_187214_a(BACKPACK, (Object)SlabfishManager.BROWN_BACKPACK.getRegistryName());
        this.func_184212_Q().func_187214_a(HAS_BACKPACK, (Object)false);
        this.func_184212_Q().func_187214_a(SWEATER, (Object)SlabfishManager.EMPTY_SWEATER.getRegistryName());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("SlabfishType", this.getSlabfishType().toString());
        compound.func_74768_a("SlabfishOverlay", this.getSlabfishOverlay().getId());
        if (this.hasBackpack()) {
            compound.func_74778_a("BackpackType", this.getBackpack().toString());
        }
        compound.func_74757_a("FromBucket", this.isFromBucket());
        this.slabfishBackpack.write(compound);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD();
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSlabfishType(new ResourceLocation(compound.func_74779_i("SlabfishType")));
        this.setSlabfishOverlay(SlabfishOverlay.byId(compound.func_74762_e("SlabfishOverlay")));
        this.setBackpack(compound.func_150297_b("BackpackType", 8) ? new ResourceLocation(compound.func_74779_i("BackpackType")) : SlabfishManager.BROWN_BACKPACK.getRegistryName());
        this.setFromBucket(compound.func_74767_n("FromBucket"));
        this.slabfishBackpack.read(compound);
        this.updateSweater();
        this.updateBackpack();
        this.setHasBackpack(!this.slabfishBackpack.func_70301_a(1).func_190926_b() && this.slabfishBackpack.func_70301_a(1).func_77973_b().func_206844_a((ITag)Tags.Items.CHESTS_WOODEN));
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        SlabfishManager slabfishManager = SlabfishManager.get((IWorldReader)this.field_70170_p);
        SlabfishType slabfishType = slabfishManager.getSlabfishType(this.getSlabfishType()).orElse(SlabfishManager.DEFAULT_SLABFISH);
        if (this.hasBackpack() && (slabfishType.getCustomBackpack() == null || !slabfishManager.getBackpackType(slabfishType.getCustomBackpack()).isPresent()) && slabfishManager.getBackpackType(stack).isPresent() && !slabfishManager.getBackpackType(stack).orElse(SlabfishManager.BROWN_BACKPACK).getRegistryName().equals((Object)this.getBackpack())) {
            if (!this.field_70170_p.func_201670_d()) {
                ItemStack previousBackpack = this.slabfishBackpack.func_70301_a(2);
                if (!previousBackpack.func_190926_b()) {
                    InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_(), (ItemStack)previousBackpack.func_77946_l());
                    this.slabfishBackpack.func_70304_b(2);
                }
                this.slabfishBackpack.func_70299_a(2, new ItemStack((IItemProvider)item));
                this.func_175505_a(player, stack);
            }
            return ActionResultType.SUCCESS;
        }
        if (!(!slabfishManager.getSweaterType(stack).isPresent() || player.func_226563_dT_() || this.hasSweater() && slabfishManager.getSweaterType(stack).orElse(SlabfishManager.EMPTY_SWEATER).getRegistryName().equals((Object)this.getSweater()))) {
            if (!this.field_70170_p.func_201670_d()) {
                ItemStack previousSweater = this.slabfishBackpack.func_70301_a(0);
                if (!previousSweater.func_190926_b()) {
                    InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_(), (ItemStack)previousSweater.func_77946_l());
                    this.slabfishBackpack.func_70304_b(0);
                }
                this.slabfishBackpack.func_70299_a(0, new ItemStack((IItemProvider)item));
                this.func_175505_a(player, stack);
            }
            return ActionResultType.SUCCESS;
        }
        if (item.func_206844_a((ITag)Tags.Items.CHESTS_WOODEN) && !this.hasBackpack()) {
            if (!this.field_70170_p.func_201670_d()) {
                this.slabfishBackpack.func_70299_a(1, new ItemStack((IItemProvider)item));
                this.func_175505_a(player, stack);
                if (player instanceof ServerPlayerEntity) {
                    EnvironmentalCriteriaTriggers.BACKPACK_SLABFISH.trigger((ServerPlayerEntity)player);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (item == Items.field_179556_br && !player.func_184207_aI()) {
            this.func_175505_a(player, stack);
            this.func_184220_m((Entity)player);
            this.func_184185_a(SoundEvents.field_187544_ad, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.particleCloud((IParticleData)ParticleTypes.field_218417_ae);
            return ActionResultType.SUCCESS;
        }
        if (item == Items.field_151097_aZ && this.hasSweater() && !player.func_226563_dT_()) {
            ItemStack previousSweater = this.slabfishBackpack.func_70301_a(0);
            if (!previousSweater.func_190926_b()) {
                InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_(), (ItemStack)previousSweater.func_77946_l());
                this.slabfishBackpack.func_70304_b(0);
            }
            return ActionResultType.SUCCESS;
        }
        if (player.func_226563_dT_() && item == Items.field_151097_aZ && this.hasBackpack()) {
            this.dropBackpack();
            return ActionResultType.SUCCESS;
        }
        if (item == Items.field_151131_as && this.func_70089_S()) {
            if (this.func_70874_b() < 0) {
                return ActionResultType.FAIL;
            }
            if (this.hasBackpack()) {
                this.dropBackpack();
            }
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            stack.func_190918_g(1);
            ItemStack stack1 = this.getBucket();
            this.setBucketData(stack1);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, stack1);
            }
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, stack1);
            } else if (!player.field_71071_by.func_70441_a(stack1)) {
                player.func_71019_a(stack1, false);
            }
            this.func_70106_y();
            return ActionResultType.SUCCESS;
        }
        if (item.func_206844_a((ITag)ItemTags.field_232907_V_)) {
            this.func_175505_a(player, stack);
            this.playBurpSound();
            this.particleCloud((IParticleData)ParticleTypes.field_197597_H);
            this.dropItem((IItemProvider)EnvironmentalItems.MUSIC_DISC_SLABRAVE.get());
            return ActionResultType.SUCCESS;
        }
        if (Ingredient.func_199805_a((ITag)ItemTags.field_206964_G).test(stack) && stack.func_222117_E() && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_175505_a(player, stack);
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)EnvironmentalSounds.ENTITY_SLABFISH_EAT.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f, true);
            this.func_70691_i(item.func_219967_s().func_221466_a());
            this.particleCloud((IParticleData)ParticleTypes.field_218420_D);
            return ActionResultType.SUCCESS;
        }
        if (Ingredient.func_199805_a(EnvironmentalTags.Items.SUSHI).test(stack)) {
            this.func_175505_a(player, stack);
            this.playBurpSound();
            this.func_195064_c(new EffectInstance(Effects.field_76424_c, 3600, 2, true, true));
            this.particleCloud((IParticleData)ParticleTypes.field_197613_f);
            return ActionResultType.SUCCESS;
        }
        if (Ingredient.func_199805_a(EnvironmentalTags.Items.SLABFISH_FOODS).test(stack)) {
            this.func_175505_a(player, stack);
            stack.func_77950_b(this.field_70170_p, (LivingEntity)this);
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)EnvironmentalSounds.ENTITY_SLABFISH_EAT.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f, true);
            return ActionResultType.SUCCESS;
        }
        if (!this.func_233685_eM_() && this.hasBackpack() && player.func_226563_dT_() && !this.func_70090_H()) {
            this.func_70903_f(true);
            this.func_184754_b(player.func_110124_au());
            if (!this.field_70170_p.func_201670_d()) {
                this.func_233687_w_(true);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_233685_eM_() && player.func_226563_dT_()) {
            if (!this.field_70170_p.func_201670_d()) {
                this.func_233687_w_(false);
            }
            this.func_70903_f(false);
            return ActionResultType.SUCCESS;
        }
        if (!player.func_226563_dT_()) {
            if (!this.field_70170_p.func_201670_d()) {
                this.openGui((ServerPlayerEntity)player);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    protected void func_191955_a(BlockState state) {
        if (state.func_177230_c() == Blocks.field_150355_j && this.getSlabfishOverlay() != SlabfishOverlay.NONE) {
            this.setSlabfishOverlay(SlabfishOverlay.NONE);
        }
    }

    public boolean isPartying() {
        return this.isPartying;
    }

    public void func_70645_a(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)cause)) {
            return;
        }
        if (!this.field_70128_L && !this.field_70729_aU) {
            Entity entity = cause.func_76346_g();
            LivingEntity livingentity = this.func_94060_bK();
            if (this.field_70744_aE >= 0 && livingentity != null) {
                livingentity.func_191956_a((Entity)this, this.field_70744_aE, cause);
            }
            if (entity != null) {
                entity.func_241847_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
            }
            if (this.func_70608_bn()) {
                this.func_213366_dy();
            }
            this.field_70729_aU = true;
            this.func_110142_aN().func_94549_h();
            if (!this.field_70170_p.field_72995_K) {
                this.func_213345_d(cause);
                this.func_226298_f_(livingentity);
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_213301_b(Pose.DYING);
        }
    }

    public void func_191987_a(BlockPos pos, boolean isPartying) {
        this.jukeboxPosition = pos;
        this.isPartying = isPartying;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.jukeboxPosition == null || !this.jukeboxPosition.func_218137_a((IPosition)this.func_213303_ch(), 3.46) || this.field_70170_p.func_180495_p(this.jukeboxPosition).func_177230_c() != Blocks.field_150421_aI) {
            this.isPartying = false;
            this.jukeboxPosition = null;
        }
        if (!this.func_233684_eK_()) {
            this.func_70903_f(false);
        }
        if (this.func_184187_bx() != null && this.func_184187_bx().func_225608_bj_()) {
            this.func_184210_p();
        }
        if (this.func_70090_H() && this.func_184187_bx() != null) {
            this.func_184210_p();
        }
        if (this.isMoving() && this.func_70644_a(Effects.field_76424_c) && this.field_70146_Z.nextInt(3) == 0 && !this.func_70090_H()) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226282_d_(0.5), this.func_226278_cu_() + 0.2, this.func_226287_g_(0.5), d0, d1, d2);
        }
        if (this.field_70146_Z.nextFloat() < 0.1f && this.getSlabfishOverlay() == SlabfishOverlay.MUDDY) {
            for (int i = 0; i < this.field_70146_Z.nextInt(2) + 1; ++i) {
                this.doParticle(this.field_70170_p, this.func_226277_ct_() - (double)0.3f, this.func_226277_ct_() + (double)0.3f, this.func_226281_cx_() - (double)0.3f, this.func_226281_cx_() + (double)0.3f, this.func_226283_e_(0.5), (IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)EnvironmentalItems.MUD_BALL.get())));
            }
        }
        List playerList = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72314_b(5.0, 5.0, 5.0));
        for (PlayerEntity player : playerList) {
            if (!(player instanceof ServerPlayerEntity)) continue;
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
            if (this.field_70170_p.func_201670_d()) continue;
            EnvironmentalCriteriaTriggers.SLABFISH.trigger(serverplayerentity, this);
        }
        this.func_213323_x_();
        this.func_98053_h(this.hasBackpack());
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E) {
            if (!this.func_70090_H() && this.func_213322_ci().field_72448_b < 0.0) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
            }
            if (this.wingRotDelta < 1.0f) {
                this.wingRotDelta = 1.0f;
            }
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        this.wingRotation += this.wingRotDelta * 2.0f;
    }

    private boolean isMoving() {
        return this.func_213322_ci().func_82615_a() > 0.0 || this.func_213322_ci().func_82617_b() > 0.0 || this.func_213322_ci().func_82616_c() > 0.0;
    }

    public double func_70033_W() {
        if (this.func_184187_bx() != null) {
            if (this.func_184187_bx() instanceof BoatEntity) {
                return this.func_70631_g_() ? 0.43 : 0.3;
            }
            return this.func_70631_g_() ? (double)0.7f : (double)0.52f;
        }
        return super.func_70033_W();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.func_184187_bx() != null) {
            this.func_184210_p();
        }
        Entity entity = source.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSounds.ENTITY_SLABFISH_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)EnvironmentalSounds.ENTITY_SLABFISH_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)EnvironmentalSounds.ENTITY_SLABFISH_STEP.get(), 0.15f, 1.0f);
    }

    protected void playBackpackSound() {
        this.func_184185_a((SoundEvent)EnvironmentalSounds.ENTITY_SLABFISH_BACKPACK.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    protected void playSweaterSound() {
        this.func_184185_a((SoundEvent)EnvironmentalSounds.ENTITY_SLABFISH_SWEATER.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    protected void playBurpSound() {
        this.func_184185_a((SoundEvent)EnvironmentalSounds.ENTITY_SLABFISH_BURP.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    private void doParticle(World world, double p_226397_2_, double p_226397_4_, double p_226397_6_, double p_226397_8_, double p_226397_10_, IParticleData p_226397_12_) {
        world.func_195594_a(p_226397_12_, MathHelper.func_219803_d((double)world.field_73012_v.nextDouble(), (double)p_226397_2_, (double)p_226397_4_), p_226397_10_, MathHelper.func_219803_d((double)world.field_73012_v.nextDouble(), (double)p_226397_6_, (double)p_226397_8_), 0.0, 0.0, 0.0);
    }

    private void particleCloud(IParticleData particle) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(particle, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    private void dropItem(IItemProvider item) {
        ItemEntity itementity = this.func_199702_a(item, 0);
        if (itementity != null) {
            itementity.func_213317_d(itementity.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f), (double)(this.field_70146_Z.nextFloat() * 0.05f), (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f)));
        }
    }

    public SlabfishEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        SlabfishEntity baby = (SlabfishEntity)((EntityType)EnvironmentalEntities.SLABFISH.get()).func_200721_a((World)world);
        if (baby == null) {
            return null;
        }
        baby.setSlabfishType(this.getSlabfishType());
        return baby;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)EnvironmentalItems.SLABFISH_SPAWN_EGG.get());
    }

    public boolean func_70877_b(ItemStack stack) {
        return Ingredient.func_199805_a(EnvironmentalTags.Items.SLABFISH_BREEDING_ITEMS).test(stack);
    }

    public EntitySize func_213305_a(Pose pose) {
        return this.func_70090_H() ? (this.func_70631_g_() ? SIZE_SWIMMING_CHILD : SIZE_SWIMMING) : (this.func_233684_eK_() || this.func_184187_bx() != null ? (this.func_70631_g_() ? SIZE_SITTING_CHILD : SIZE_SITTING) : super.func_213305_a(pose));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_233684_eK_() ? sizeIn.field_220316_b * 0.6f : (this.func_70090_H() ? (this.func_70631_g_() ? sizeIn.field_220316_b * 1.4f : sizeIn.field_220316_b * 0.855f) : sizeIn.field_220316_b * 0.8f);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public int func_70641_bl() {
        return 5;
    }

    protected float func_189749_co() {
        return 0.96f;
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        if (!this.field_70170_p.func_201670_d() && name != null && !this.getSlabfishType().equals((Object)SlabfishManager.GHOST)) {
            super.func_200203_b(name);
            SlabfishManager slabfishManager = SlabfishManager.get((IWorldReader)this.field_70170_p);
            SlabfishType currentType = slabfishManager.getSlabfishType(this.getSlabfishType()).orElse(SlabfishManager.DEFAULT_SLABFISH);
            slabfishManager.getSlabfishType(SlabfishConditionContext.rename(this)).ifPresent(newType -> {
                if (!currentType.isTradable() && newType.isTradable()) {
                    return;
                }
                if (newType.getRegistryName() != this.getSlabfishType()) {
                    this.setSlabfishType(newType.getRegistryName());
                }
            });
        }
    }

    public void playTransformSound() {
        this.func_184185_a((SoundEvent)EnvironmentalSounds.ENTITY_SLABFISH_TRANSFORM.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        this.particleCloud((IParticleData)ParticleTypes.field_218417_ae);
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity lightningBolt) {
        UUID uuid = lightningBolt.func_110124_au();
        if (!(world.func_201670_d() || uuid.equals(this.lightningUUID) || this.getSlabfishType().equals((Object)SlabfishManager.GHOST))) {
            SlabfishManager slabfishManager = SlabfishManager.get((IWorldReader)world);
            SlabfishType currentType = slabfishManager.getSlabfishType(this.getSlabfishType()).orElse(SlabfishManager.DEFAULT_SLABFISH);
            slabfishManager.getSlabfishType(SlabfishConditionContext.lightning(this)).ifPresent(newType -> {
                if (!currentType.isTradable() && newType.isTradable()) {
                    return;
                }
                this.setSlabfishType(newType.getRegistryName());
                this.lightningUUID = uuid;
                this.func_184185_a(SoundEvents.field_187754_de, 2.0f, 1.0f);
            });
        }
    }

    public ResourceLocation getSlabfishType() {
        return (ResourceLocation)this.field_70180_af.func_187225_a(SLABFISH_TYPE);
    }

    public void setSlabfishType(ResourceLocation type) {
        this.field_70180_af.func_187227_b(SLABFISH_TYPE, (Object)type);
        this.updateBackpack();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        Optional<SlabfishType> type;
        spawnDataIn = super.func_213386_a(world, difficulty, reason, spawnDataIn, dataTag);
        if (dataTag != null && dataTag.func_150297_b("SlabfishType", 8)) {
            if (dataTag.func_74764_b("Health")) {
                this.func_70606_j(dataTag.func_74760_g("Health"));
            }
            if (dataTag.func_74764_b("Age")) {
                this.func_70873_a(dataTag.func_74762_e("Age"));
            }
            this.setSlabfishType(new ResourceLocation(dataTag.func_74779_i("SlabfishType")));
            if (dataTag.func_150297_b("BackpackType", 8)) {
                this.setBackpack(new ResourceLocation(dataTag.func_74779_i("BackpackType")));
            }
            this.slabfishBackpack.read(dataTag);
            this.updateSweater();
            this.updateBackpack();
            return spawnDataIn;
        }
        if (spawnDataIn instanceof SlabfishData) {
            this.setSlabfishType(((SlabfishData)spawnDataIn).type);
            return spawnDataIn;
        }
        SlabfishManager slabfishManager = SlabfishManager.get((IWorldReader)world);
        SlabfishRarity rarity = SlabfishRarity.byChance(world.func_201674_k().nextFloat());
        Optional<SlabfishType> optional = type = reason == SpawnReason.BUCKET ? slabfishManager.getRandomSlabfishType(s -> s.isModLoaded() && s.isTradable() && s.getRarity() == rarity, world.func_201674_k()) : slabfishManager.getSlabfishType(SlabfishConditionContext.spawned(this));
        if (!this.isFromBucket()) {
            spawnDataIn = new SlabfishData(type.orElse(SlabfishManager.DEFAULT_SLABFISH).getRegistryName());
        }
        this.setSlabfishType(type.orElse(SlabfishManager.DEFAULT_SLABFISH).getRegistryName());
        return spawnDataIn;
    }

    public boolean func_213392_I() {
        return this.isFromBucket();
    }

    public boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setFromBucket(boolean value) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)value);
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
        CompoundNBT compound = bucket.func_196082_o();
        compound.func_74776_a("Health", this.func_110143_aJ());
        compound.func_74768_a("Age", this.func_70874_b());
        compound.func_74778_a("SlabfishType", this.getSlabfishType().toString());
        if (this.hasBackpack()) {
            compound.func_74778_a("BackpackType", this.getBackpack().toString());
        }
        this.slabfishBackpack.write(compound);
    }

    private void updateSweater() {
        if (!this.field_70170_p.func_201670_d()) {
            ItemStack sweaterStack = this.slabfishBackpack.func_70301_a(0);
            SweaterType sweaterType = SlabfishManager.get((IWorldReader)this.field_70170_p).getSweaterType(sweaterStack).orElse(SlabfishManager.EMPTY_SWEATER);
            if (!sweaterType.isEmpty()) {
                this.setSweater(sweaterType.getRegistryName());
            } else {
                this.setSweater(SlabfishManager.EMPTY_SWEATER.getRegistryName());
            }
        }
    }

    private void updateBackpack() {
        if (!this.field_70170_p.func_201670_d()) {
            SlabfishManager slabfishManager = SlabfishManager.get((IWorldReader)this.field_70170_p);
            SlabfishType slabfishType = slabfishManager.getSlabfishType(this.getSlabfishType()).orElse(SlabfishManager.DEFAULT_SLABFISH);
            ResourceLocation backpackType = slabfishType.getCustomBackpack();
            if (backpackType != null && slabfishManager.getBackpackType(backpackType).isPresent()) {
                this.setBackpack(backpackType);
                if (!this.slabfishBackpack.func_70301_a(2).func_190926_b()) {
                    this.func_199701_a_(this.slabfishBackpack.func_70304_b(2));
                }
            } else {
                ItemStack backpackColorStack = this.slabfishBackpack.func_70301_a(2);
                this.setBackpack(SlabfishManager.get((IWorldReader)this.field_70170_p).getBackpackType(backpackColorStack).orElse(SlabfishManager.BROWN_BACKPACK).getRegistryName());
            }
        }
    }

    public boolean hasBackpack() {
        return (Boolean)this.func_184212_Q().func_187225_a(HAS_BACKPACK);
    }

    public void setHasBackpack(boolean hasBackpack) {
        this.func_184212_Q().func_187227_b(HAS_BACKPACK, (Object)hasBackpack);
    }

    public void setBackpack(ResourceLocation backpackType) {
        this.field_70180_af.func_187227_b(BACKPACK, (Object)backpackType);
    }

    public ResourceLocation getBackpack() {
        return (ResourceLocation)this.field_70180_af.func_187225_a(BACKPACK);
    }

    public boolean hasSweater() {
        return !((ResourceLocation)this.field_70180_af.func_187225_a(SWEATER)).equals((Object)SlabfishManager.EMPTY_SWEATER.getRegistryName());
    }

    public void setSweater(ResourceLocation sweaterType) {
        this.field_70180_af.func_187227_b(SWEATER, (Object)sweaterType);
    }

    public ResourceLocation getSweater() {
        return (ResourceLocation)this.field_70180_af.func_187225_a(SWEATER);
    }

    public SlabfishOverlay getSlabfishOverlay() {
        return SlabfishOverlay.byId((Integer)this.field_70180_af.func_187225_a(SLABFISH_OVERLAY));
    }

    public void setSlabfishOverlay(SlabfishOverlay typeId) {
        this.field_70180_af.func_187227_b(SLABFISH_OVERLAY, (Object)typeId.getId());
    }

    public void openGui(ServerPlayerEntity player) {
        if (player.field_71070_bA != player.field_71069_bz) {
            player.func_71053_j();
        }
        player.func_71117_bO();
        Environmental.PLAY.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SOpenSlabfishInventoryMessage(this, player.field_71139_cq));
        player.field_71070_bA = new SlabfishInventoryContainer(player.field_71139_cq, player.field_71071_by, this.slabfishBackpack, this);
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)player, player.field_71070_bA));
    }

    public boolean func_175448_a(ItemStack stack) {
        return this.hasBackpack();
    }

    public boolean func_213365_e(ItemStack stack) {
        return this.hasBackpack();
    }

    protected void func_213337_cE() {
        ItemStack itemstack = this.slabfishBackpack.func_70304_b(0);
        if (!itemstack.func_190926_b() && !EnchantmentHelper.func_190939_c((ItemStack)itemstack)) {
            this.func_199701_a_(itemstack);
        }
        this.dropBackpack();
    }

    protected void dropBackpack() {
        super.func_213337_cE();
        if (this.hasBackpack() && this.slabfishBackpack != null) {
            for (int i = this.slabfishBackpack.func_70302_i_(); i > 0; --i) {
                ItemStack itemstack = this.slabfishBackpack.func_70304_b(i);
                if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                this.func_199701_a_(itemstack);
            }
        }
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (this.hasBackpack()) {
            ItemStack stack = this.slabfishBackpack.addItem(itemstack, 3, this.slabfishBackpack.func_70302_i_());
            if (!ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)stack)) {
                this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E() - stack.func_190916_E());
            }
            if (stack.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemEntity.func_92058_a(stack);
            }
        }
    }

    public void func_76316_a(IInventory invBasic) {
        boolean hasBackpack;
        if (this.clearing) {
            return;
        }
        boolean hadSweater = this.hasSweater();
        boolean hadBackpack = this.hasBackpack();
        this.updateSweater();
        boolean bl = hasBackpack = !this.slabfishBackpack.func_70301_a(1).func_190926_b() && this.slabfishBackpack.func_70301_a(1).func_77973_b().func_206844_a((ITag)Tags.Items.CHESTS_WOODEN);
        if (!hadSweater && this.hasSweater()) {
            this.playSweaterSound();
        }
        if (hadBackpack != hasBackpack) {
            this.playBackpackSound();
        }
        if (hadBackpack && !hasBackpack) {
            this.clearing = true;
            this.dropBackpack();
            this.clearing = false;
        }
        this.setHasBackpack(hasBackpack);
        this.updateBackpack();
        if (this.hasBackpack()) {
            this.backpackFull = true;
            for (int i = 3; i < this.slabfishBackpack.func_70302_i_(); ++i) {
                ItemStack stack = this.slabfishBackpack.func_70301_a(i);
                if (!stack.func_190926_b() && stack.func_190916_E() >= stack.func_77976_d()) continue;
                this.backpackFull = false;
                break;
            }
        } else {
            this.backpackFull = false;
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!keepData && this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack getBucket() {
        return new ItemStack((IItemProvider)EnvironmentalItems.SLABFISH_BUCKET.get());
    }

    public static class SlabfishData
    extends AgeableEntity.AgeableData
    implements ILivingEntityData {
        public final ResourceLocation type;

        public SlabfishData(ResourceLocation type) {
            super(0.2f);
            this.type = type;
        }
    }
}

