/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.item;

import com.minecraftabnormals.abnormals_core.core.util.item.filling.TargetedItemGroupFiller;
import com.minecraftabnormals.environmental.common.entity.SlabfishEntity;
import com.minecraftabnormals.environmental.common.slabfish.BackpackType;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishManager;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishType;
import com.minecraftabnormals.environmental.common.slabfish.SweaterType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.MutablePair;

public class SlabfishBucketItem
extends BucketItem {
    private static final Map<String, ResourceLocation> LOCATION_CACHE = new HashMap<String, ResourceLocation>();
    private static final MutablePair<CompoundNBT, SweaterType> SWEATER_TYPE_CACHE = new MutablePair(null, (Object)SlabfishManager.EMPTY_SWEATER);
    private final Supplier<EntityType<? extends SlabfishEntity>> entityType;
    private static final TargetedItemGroupFiller FILLER = new TargetedItemGroupFiller(() -> Items.field_204272_aO);

    public SlabfishBucketItem(Supplier<EntityType<? extends SlabfishEntity>> entityType, Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
        this.entityType = entityType;
    }

    public void func_203792_a(World worldIn, ItemStack p_203792_2_, BlockPos pos) {
        if (worldIn instanceof ServerWorld) {
            this.placeEntity((ServerWorld)worldIn, p_203792_2_, pos);
        }
    }

    protected void func_203791_b(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_203819_X, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    private void placeEntity(ServerWorld worldIn, ItemStack stack, BlockPos pos) {
        Entity entity = this.entityType.get().func_220331_a(worldIn, stack, (PlayerEntity)null, pos, SpawnReason.BUCKET, true, false);
        if (entity != null) {
            ((SlabfishEntity)entity).setFromBucket(true);
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        FILLER.fillItem((Item)this, group, items);
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null) {
            SlabfishType slabfishType;
            SlabfishManager slabfishManager = SlabfishManager.get((IWorldReader)worldIn);
            if (compoundnbt.func_150297_b("SlabfishType", 8) && (slabfishType = slabfishManager.getSlabfishType(LOCATION_CACHE.computeIfAbsent(compoundnbt.func_74779_i("SlabfishType"), ResourceLocation::new)).orElse(SlabfishManager.DEFAULT_SLABFISH)) != SlabfishManager.DEFAULT_SLABFISH) {
                tooltip.add((ITextComponent)slabfishType.getDisplayName().func_230532_e_().func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, slabfishType.getRarity().getFormatting()}));
            }
            if (compoundnbt.func_150297_b("Age", 99) && compoundnbt.func_74762_e("Age") < 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("entity.environmental.slabfish.baby").func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY}));
            }
            if (compoundnbt.func_150297_b("BackpackType", 8)) {
                BackpackType backpackType = slabfishManager.getBackpackType(LOCATION_CACHE.computeIfAbsent(compoundnbt.func_74779_i("BackpackType"), ResourceLocation::new)).orElse(SlabfishManager.BROWN_BACKPACK);
                tooltip.add((ITextComponent)backpackType.getDisplayName().func_230532_e_().func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY}));
            }
            if (!compoundnbt.equals(SWEATER_TYPE_CACHE.getLeft())) {
                SWEATER_TYPE_CACHE.setLeft((Object)compoundnbt);
                SWEATER_TYPE_CACHE.setRight((Object)SlabfishManager.EMPTY_SWEATER);
                ListNBT list = compoundnbt.func_150295_c("Items", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundNBT slotNbt = list.func_150305_b(i);
                    int index = slotNbt.func_74771_c("Slot") & 0xFF;
                    if (index != 0) continue;
                    ItemStack slotStack = ItemStack.func_199557_a((CompoundNBT)slotNbt);
                    SWEATER_TYPE_CACHE.setRight((Object)slabfishManager.getSweaterType(slotStack).orElse(SlabfishManager.EMPTY_SWEATER));
                    break;
                }
            }
            if (!SlabfishManager.EMPTY_SWEATER.equals(SWEATER_TYPE_CACHE.getRight())) {
                tooltip.add((ITextComponent)((SweaterType)SWEATER_TYPE_CACHE.getRight()).getDisplayName().func_230532_e_().func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY}));
            }
        }
    }
}

