/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.slabfish;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class BackpackType
implements Predicate<ItemStack> {
    private final Ingredient ingredient;
    private final LazyValue<ResourceLocation> textureLocation = new LazyValue(() -> new ResourceLocation(this.getRegistryName().func_110624_b(), "backpack/" + this.getRegistryName().func_110623_a()));
    private ResourceLocation registryName;
    private ITextComponent displayName;

    public BackpackType(@Nullable ITextComponent displayName, @Nullable Ingredient ingredient) {
        this.displayName = displayName;
        this.ingredient = ingredient;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BackpackType readFrom(PacketBuffer buf) {
        ResourceLocation registryName = buf.func_192575_l();
        ITextComponent displayName = buf.func_179258_d();
        Ingredient ingredient = buf.readBoolean() ? Ingredient.func_199566_b((PacketBuffer)buf) : null;
        return new BackpackType(displayName, ingredient).setRegistryName(registryName);
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.ingredient != null && this.ingredient.test(stack);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    BackpackType setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        if (this.displayName == null) {
            this.displayName = new StringTextComponent(registryName.toString());
        }
        return this;
    }

    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTextureLocation() {
        return (ResourceLocation)this.textureLocation.func_179281_c();
    }

    public void writeTo(PacketBuffer buf) {
        buf.func_192572_a(this.registryName);
        buf.func_179256_a(this.displayName);
        buf.writeBoolean(this.ingredient != null);
        if (this.ingredient != null) {
            this.ingredient.func_199564_a(buf);
        }
    }

    public String toString() {
        return "BackpackType{registryName=" + this.registryName + ", displayName=" + this.displayName.getString() + ", ingredient=" + (this.ingredient == null ? null : Arrays.toString(this.ingredient.func_193365_a())) + '}';
    }

    public static class Deserializer
    implements JsonDeserializer<BackpackType> {
        public BackpackType deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            ITag tag;
            JsonObject jsonObject = json.getAsJsonObject();
            if (jsonObject.has("item") && jsonObject.has("tag")) {
                throw new JsonSyntaxException("Either 'item' or 'tag' can be present");
            }
            ITextComponent displayName = jsonObject.has("displayName") ? (ITextComponent)context.deserialize(jsonObject.get("displayName"), ITextComponent.class) : null;
            Item item = jsonObject.has("item") && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(jsonObject.get("item").getAsString())) ? (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jsonObject.get("item").getAsString())) : null;
            ITag iTag = tag = jsonObject.has("tag") ? TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(jsonObject.get("tag").getAsString())) : null;
            Ingredient ingredient = item != null ? Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}) : (tag != null ? Ingredient.func_199805_a(tag) : null);
            return new BackpackType(displayName, ingredient);
        }
    }
}

