/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.slabfish;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishManager;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class SweaterType
implements Predicate<ItemStack> {
    private final Ingredient ingredient;
    private ResourceLocation registryName;
    private final LazyValue<ResourceLocation> textureLocation = new LazyValue(() -> new ResourceLocation(this.getRegistryName().func_110624_b(), "sweater/" + this.getRegistryName().func_110623_a()));
    private ITextComponent displayName;

    public SweaterType(@Nullable ITextComponent displayName, Ingredient ingredient) {
        this.displayName = displayName;
        this.ingredient = ingredient;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SweaterType readFrom(PacketBuffer buf) {
        ResourceLocation registryName = buf.func_192575_l();
        ITextComponent displayName = buf.func_179258_d();
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buf);
        return new SweaterType(displayName, ingredient).setRegistryName(registryName);
    }

    public boolean isEmpty() {
        return this == SlabfishManager.EMPTY_SWEATER;
    }

    @Override
    public boolean test(ItemStack stack) {
        return !this.isEmpty() && this.ingredient != Ingredient.field_193370_a && this.ingredient.test(stack);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    SweaterType setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        if (this.displayName == null) {
            this.displayName = new StringTextComponent(registryName.toString());
        }
        return this;
    }

    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTextureLocation() {
        return (ResourceLocation)this.textureLocation.func_179281_c();
    }

    public void writeTo(PacketBuffer buf) {
        buf.func_192572_a(this.registryName);
        buf.func_179256_a(this.displayName);
        this.ingredient.func_199564_a(buf);
    }

    public String toString() {
        return "SweaterType{registryName=" + this.registryName + ", displayName=" + this.displayName.getString() + ", ingredient=" + Arrays.toString(this.ingredient.func_193365_a()) + '}';
    }

    public static class Deserializer
    implements JsonDeserializer<SweaterType> {
        public SweaterType deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            ITag tag;
            JsonObject jsonObject = json.getAsJsonObject();
            if (jsonObject.has("item") && jsonObject.has("tag")) {
                throw new JsonSyntaxException("Either 'item' or 'tag' can be present");
            }
            ITextComponent displayName = jsonObject.has("displayName") ? (ITextComponent)context.deserialize(jsonObject.get("displayName"), ITextComponent.class) : null;
            Item item = jsonObject.has("item") && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(jsonObject.get("item").getAsString())) ? (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jsonObject.get("item").getAsString())) : null;
            ITag iTag = tag = jsonObject.has("tag") ? TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(jsonObject.get("tag").getAsString())) : null;
            Ingredient ingredient = item != null ? Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}) : (tag != null ? Ingredient.func_199805_a(tag) : Ingredient.field_193370_a);
            return new SweaterType(displayName, ingredient);
        }
    }
}

