/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.world.gen.feature;

import com.minecraftabnormals.environmental.common.world.gen.util.WisteriaTreeUtils;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalFeatures;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class WisteriaTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    private Supplier<BlockState> VINE_UPPER;
    private Supplier<BlockState> VINE_LOWER;

    public WisteriaTreeFeature(Codec<BaseTreeFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, BaseTreeFeatureConfig config) {
        if (config.field_227369_n_.func_225574_a_(random, pos) == EnvironmentalFeatures.States.BLUE_WISTERIA_LEAVES) {
            this.VINE_UPPER = () -> EnvironmentalFeatures.States.BLUE_HANGING_WISTERIA_LEAVES_TOP;
            this.VINE_LOWER = () -> EnvironmentalFeatures.States.BLUE_HANGING_WISTERIA_LEAVES_BOTTOM;
        }
        if (config.field_227369_n_.func_225574_a_(random, pos) == EnvironmentalFeatures.States.PINK_WISTERIA_LEAVES) {
            this.VINE_UPPER = () -> EnvironmentalFeatures.States.PINK_HANGING_WISTERIA_LEAVES_TOP;
            this.VINE_LOWER = () -> EnvironmentalFeatures.States.PINK_HANGING_WISTERIA_LEAVES_BOTTOM;
        }
        if (config.field_227369_n_.func_225574_a_(random, pos) == EnvironmentalFeatures.States.PURPLE_WISTERIA_LEAVES) {
            this.VINE_UPPER = () -> EnvironmentalFeatures.States.PURPLE_HANGING_WISTERIA_LEAVES_TOP;
            this.VINE_LOWER = () -> EnvironmentalFeatures.States.PURPLE_HANGING_WISTERIA_LEAVES_BOTTOM;
        }
        if (config.field_227369_n_.func_225574_a_(random, pos) == EnvironmentalFeatures.States.WHITE_WISTERIA_LEAVES) {
            this.VINE_UPPER = () -> EnvironmentalFeatures.States.WHITE_HANGING_WISTERIA_LEAVES_TOP;
            this.VINE_LOWER = () -> EnvironmentalFeatures.States.WHITE_HANGING_WISTERIA_LEAVES_BOTTOM;
        }
        int height = random.nextInt(7) + 5;
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= world.func_217301_I()) {
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == pos.func_177956_o()) {
                    k = 0;
                }
                if (j >= pos.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int l = pos.func_177958_n() - k; l <= pos.func_177958_n() + k && flag; ++l) {
                    for (int i1 = pos.func_177952_p() - k; i1 <= pos.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < world.func_217301_I()) {
                            if (WisteriaTreeUtils.isAirOrLeaves((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (WisteriaTreeUtils.isValidGround((IWorld)world, pos.func_177977_b()) && pos.func_177956_o() < world.func_217301_I() - height - 1) {
                WisteriaTreeUtils.setDirtAt((IWorld)world, pos.func_177977_b());
                for (int y = 4; y > -4; --y) {
                    for (int x = 4; x > -4; --x) {
                        for (int z = 4; z > -4; --z) {
                            int n = y > 0 ? y * y : 0;
                            if (!(Math.sqrt(x * x + n + z * z) <= 4.0)) continue;
                            BlockPos leafPos = pos.func_177982_a(x, y + height, z);
                            boolean place = true;
                            if (y < 0 && (place = world.func_217375_a(leafPos.func_177982_a(0, 1, 0), state -> state.func_235714_a_((ITag)BlockTags.field_206952_E))) && random.nextInt(Math.abs(y) + 1) != 0) {
                                place = false;
                                if (random.nextInt(4) == 0 && !WisteriaTreeUtils.isLog((IWorldGenerationBaseReader)world, leafPos)) {
                                    WisteriaTreeUtils.placeVines((IWorldGenerationReader)world, random, leafPos, config.field_227369_n_.func_225574_a_(random, pos), this.VINE_LOWER.get(), this.VINE_UPPER.get());
                                }
                            }
                            if (!place) continue;
                            WisteriaTreeUtils.placeLeafAt((IWorldGenerationReader)world, leafPos, config.field_227369_n_.func_225574_a_(random, pos));
                        }
                    }
                }
                for (int i2 = 0; i2 < height; ++i2) {
                    if (!WisteriaTreeUtils.isAirOrLeaves((IWorldGenerationBaseReader)world, pos.func_177981_b(i2))) continue;
                    WisteriaTreeUtils.setForcedState((IWorldWriter)world, pos.func_177981_b(i2), config.field_227368_m_.func_225574_a_(random, pos));
                }
                this.placeBranch((IWorldGenerationReader)world, random, pos.func_177977_b(), pos.func_177981_b(height).func_177956_o(), config);
                if (random.nextInt(4) == 0) {
                    this.placeBranch((IWorldGenerationReader)world, random, pos.func_177977_b(), pos.func_177981_b(height).func_177956_o(), config);
                }
                BlockPos startPos = pos.func_177981_b(height);
                for (BlockPos blockpos : BlockPos.func_191531_b((int)(startPos.func_177958_n() - 10), (int)(startPos.func_177956_o() - 10), (int)(startPos.func_177952_p() - 10), (int)(startPos.func_177958_n() + 10), (int)(startPos.func_177956_o() + 10), (int)(startPos.func_177952_p() + 10))) {
                    if (!WisteriaTreeUtils.isAir((IWorldGenerationBaseReader)world, blockpos) || !WisteriaTreeFeature.isLeaves((IWorldGenerationBaseReader)world, blockpos.func_177984_a(), config, random) || random.nextInt(4) != 0) continue;
                    if (WisteriaTreeUtils.isAir((IWorldGenerationBaseReader)world, blockpos)) {
                        WisteriaTreeUtils.setForcedState((IWorldWriter)world, blockpos, this.VINE_UPPER.get());
                    }
                    if (!WisteriaTreeUtils.isAir((IWorldGenerationBaseReader)world, blockpos.func_177977_b()) || random.nextInt(2) != 0) continue;
                    WisteriaTreeUtils.setForcedState((IWorldWriter)world, blockpos.func_177977_b(), this.VINE_LOWER.get());
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos, BaseTreeFeatureConfig config, Random random) {
        if (worldIn instanceof IWorldReader) {
            return worldIn.func_217375_a(pos, state -> state == config.field_227369_n_.func_225574_a_(random, pos));
        }
        return worldIn.func_217375_a(pos, p_227223_0_ -> config.field_227369_n_.func_225574_a_(random, pos) == p_227223_0_);
    }

    private void placeBranch(IWorldGenerationReader world, Random random, BlockPos pos, int treeHeight, BaseTreeFeatureConfig config) {
        int heightOffset = random.nextInt(3);
        BlockPos[] startPositions = new BlockPos[]{new BlockPos(pos.func_177958_n() - 1, treeHeight - heightOffset, pos.func_177952_p()), new BlockPos(pos.func_177958_n() + 1, treeHeight - heightOffset, pos.func_177952_p()), new BlockPos(pos.func_177958_n(), treeHeight - heightOffset, pos.func_177952_p() - 1), new BlockPos(pos.func_177958_n(), treeHeight - heightOffset, pos.func_177952_p() + 1), new BlockPos(pos.func_177958_n() - 1, treeHeight - heightOffset, pos.func_177952_p() - 1), new BlockPos(pos.func_177958_n() + 1, treeHeight - heightOffset, pos.func_177952_p() - 1), new BlockPos(pos.func_177958_n() - 1, treeHeight - heightOffset, pos.func_177952_p() + 1), new BlockPos(pos.func_177958_n() + 1, treeHeight - heightOffset, pos.func_177952_p() + 1)};
        BlockPos startPos = startPositions[random.nextInt(8)];
        if (WisteriaTreeUtils.isAirOrLeavesOrVines((IWorldGenerationBaseReader)world, startPos)) {
            boolean vines = random.nextInt(6) != 5;
            BlockPos placePos = startPos;
            for (int y = treeHeight - heightOffset; y <= treeHeight; ++y) {
                placePos = new BlockPos(startPos.func_177958_n(), y, startPos.func_177952_p());
                if (!WisteriaTreeUtils.isAirOrLeavesOrVines((IWorldGenerationBaseReader)world, placePos)) continue;
                WisteriaTreeUtils.setForcedState((IWorldWriter)world, placePos, config.field_227368_m_.func_225574_a_(random, pos));
            }
            WisteriaTreeUtils.placeLeafAt(world, placePos.func_177984_a(), config.field_227369_n_.func_225574_a_(random, pos));
            if (vines) {
                WisteriaTreeUtils.placeVines(world, random, startPos.func_177977_b(), config.field_227369_n_.func_225574_a_(random, pos), this.VINE_LOWER.get(), this.VINE_UPPER.get());
            }
        }
    }
}

