/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.core;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="environmental")
public class EnvironmentalConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> generateGiantMushrooms;
        public final ForgeConfigSpec.ConfigValue<Boolean> generateGiantTallGrass;
        public final ForgeConfigSpec.ConfigValue<Boolean> generateWisteriaTrees;
        public final ForgeConfigSpec.ConfigValue<Boolean> generateRice;
        public final ForgeConfigSpec.ConfigValue<Boolean> generateDelphiniums;
        public final ForgeConfigSpec.ConfigValue<Boolean> generateHibiscus;
        public final ForgeConfigSpec.ConfigValue<Integer> marshWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> mushroomMarshWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> blossomWoodsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> blossomHillsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> blossomHighlandsWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> blossomValleysWeight;
        public final ForgeConfigSpec.ConfigValue<Boolean> limitFarmAnimalSpawns;
        public final ForgeConfigSpec.ConfigValue<Boolean> biomeVariantsAlwaysSpawn;
        public final ForgeConfigSpec.ConfigValue<Boolean> blockOnlyNaturalSpawns;
        public final ForgeConfigSpec.ConfigValue<Integer> koiHorizontalSerenityRange;
        public final ForgeConfigSpec.ConfigValue<Integer> koiVerticalSerenityRange;
        public final ForgeConfigSpec.ConfigValue<Boolean> serenityEffect;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("worldgen");
            builder.push("biomes");
            builder.push("marsh");
            this.marshWeight = builder.define("Marsh weight", (Object)6);
            this.mushroomMarshWeight = builder.define("Mushroom Marsh weight", (Object)0);
            builder.pop();
            builder.push("blossom");
            this.blossomWoodsWeight = builder.define("Blossom Woods weight", (Object)3);
            this.blossomHillsWeight = builder.define("Blossom Hills weight", (Object)0);
            this.blossomHighlandsWeight = builder.define("Blossom Highlands weight", (Object)1);
            this.blossomValleysWeight = builder.define("Blossom Valleys weight", (Object)0);
            builder.pop();
            builder.pop();
            builder.push("features");
            this.generateGiantMushrooms = builder.define("Giant Mushroom generation in Swamps", true);
            this.generateRice = builder.define("Rice generation in Marshes", true);
            this.generateGiantTallGrass = builder.define("Giant Tall Grass generation", true);
            this.generateWisteriaTrees = builder.define("Wisteria Tree generation in Flower Forests", true);
            this.generateDelphiniums = builder.define("Delphinium generation in Flower Forests", true);
            this.generateHibiscus = builder.define("Hibiscus generation in Jungles", true);
            builder.pop();
            builder.pop();
            builder.push("entities");
            this.limitFarmAnimalSpawns = builder.comment("Make farm animals spawn in less biomes to allow new mobs to take their place and diversify biome spawns").define("Limit farm animal spawns", true);
            this.biomeVariantsAlwaysSpawn = builder.comment("Make biome variants of mobs like Husks always spawn in place of their original in their biomes").define("Biome variants always spawn", true);
            builder.push("koi");
            this.blockOnlyNaturalSpawns = builder.comment("Make Koi only block natural spawns").define("Block only natural spawns", true);
            this.koiHorizontalSerenityRange = builder.comment("Horizontal radius of Serenity effect in blocks").define("Horizontal serenity range (radius)", (Object)32);
            this.koiVerticalSerenityRange = builder.comment("Vertical radius of Serenity effect in blocks").define("Vertical serenity range (radius)", (Object)8);
            this.serenityEffect = builder.comment("If Koi exude Serenity as a potion effect").define("Serenity potion effect", true);
            builder.pop();
            builder.pop();
        }
    }
}

