/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.core.other;

import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.environmental.core.EnvironmentalConfig;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalBiomes;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalEntities;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalFeatures;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.treedecorator.LeaveVineTreeDecorator;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental")
public class EnvironmentalBiomeFeatures {
    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        ResourceLocation biome = event.getName();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        MobSpawnInfoBuilder spawns = event.getSpawns();
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{EnvironmentalBiomes.MARSH.getKey(), EnvironmentalBiomes.MUSHROOM_MARSH.getKey()})) {
            EnvironmentalBiomeFeatures.withMarshFeatures(generation);
            if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{EnvironmentalBiomes.MUSHROOM_MARSH.getKey()})) {
                EnvironmentalBiomeFeatures.withMarshMushrooms(generation);
            }
            DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)spawns);
            DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawns);
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{EnvironmentalBiomes.BLOSSOM_WOODS.getKey(), EnvironmentalBiomes.BLOSSOM_HILLS.getKey(), EnvironmentalBiomes.BLOSSOM_HIGHLANDS.getKey(), EnvironmentalBiomes.BLOSSOM_VALLEYS.getKey()})) {
            if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{EnvironmentalBiomes.BLOSSOM_VALLEYS.getKey()})) {
                EnvironmentalBiomeFeatures.withBlossomValleysFeatures(generation);
            } else {
                EnvironmentalBiomeFeatures.withBlossomWoodsFeatures(generation);
            }
            DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)spawns);
            DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawns);
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_220353_aa, 80, 1, 2));
            spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)EnvironmentalEntities.KOI.get(), 12, 1, 3));
        }
        if (event.getCategory() == Biome.Category.SWAMP) {
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)EnvironmentalEntities.SLABFISH.get(), 8, 2, 4));
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_76780_h, Biomes.field_150599_m})) {
            EnvironmentalBiomeFeatures.removeSwampTrees(generation);
            EnvironmentalBiomeFeatures.withMushrooms(generation);
            EnvironmentalBiomeFeatures.withCattails(generation);
            EnvironmentalBiomeFeatures.withMudDisks(generation);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.SWAMP_OAK);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.WILLOW_TREE);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_DUCKWEED_SWAMP);
        }
        if (event.getCategory() == Biome.Category.RIVER || event.getCategory() == Biome.Category.SWAMP) {
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)EnvironmentalEntities.DUCK.get(), 5, 2, 4));
        }
        if (event.getCategory() == Biome.Category.FOREST) {
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)EnvironmentalEntities.DEER.get(), 16, 1, 4));
            if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_185444_T})) {
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_CARTWHEEL);
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_DELPHINIUMS);
                if (((Boolean)EnvironmentalConfig.COMMON.generateWisteriaTrees.get()).booleanValue()) {
                    generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.WISTERIA_TREE);
                    generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.WISTERIA_TREE_BIG);
                }
            }
            if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_150585_R, Biomes.field_185430_ab})) {
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_BLUEBELL);
            }
        }
        if (event.getCategory() == Biome.Category.EXTREME_HILLS) {
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)EnvironmentalEntities.YAK.get(), 20, 2, 4));
        }
        if (event.getCategory() == Biome.Category.MUSHROOM) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_MYCELIUM_SPROUTS);
        }
        if (!(DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_76777_m}) || event.getCategory() != Biome.Category.SWAMP && event.getCategory() != Biome.Category.RIVER)) {
            EnvironmentalBiomeFeatures.withCattails(generation);
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.NEST_DUCK);
        }
        if (event.getCategory() == Biome.Category.DESERT) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_TALL_DEAD_BUSH);
        }
        if (event.getCategory() == Biome.Category.MESA) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_TALL_DEAD_BUSH_MESA);
        }
        if (event.getCategory() == Biome.Category.SAVANNA) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_ALLIUM);
            if (((Boolean)EnvironmentalConfig.COMMON.generateGiantTallGrass.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_GIANT_TALL_GRASS_SAVANNA);
            }
        }
        if (event.getCategory() == Biome.Category.TAIGA) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_VIOLET);
        }
        if (biome.toString().contains("rosewood") && ((Boolean)EnvironmentalConfig.COMMON.generateGiantTallGrass.get()).booleanValue()) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_GIANT_TALL_GRASS_SAVANNA);
        }
        if (event.getCategory() == Biome.Category.PLAINS && ((Boolean)EnvironmentalConfig.COMMON.generateGiantTallGrass.get()).booleanValue()) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_GIANT_TALL_GRASS_PLAINS);
        }
        if (biome.toString().contains("maple") || biome.toString().contains("pumpkin_fields")) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.NEST_TURKEY);
        } else if (event.getCategory() == Biome.Category.FOREST) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.NEST_CHICKEN);
        }
        if (event.getCategory() == Biome.Category.JUNGLE) {
            if (((Boolean)EnvironmentalConfig.COMMON.generateGiantTallGrass.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_GIANT_TALL_GRASS_JUNGLE);
            }
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_BIRD_OF_PARADISE);
            if (((Boolean)EnvironmentalConfig.COMMON.generateHibiscus.get()).booleanValue()) {
                if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_150574_L, Biomes.field_185447_Y})) {
                    generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_YELLOW_HIBISCUS);
                }
                if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_222371_ax})) {
                    generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_ORANGE_HIBISCUS);
                }
                if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_76782_w})) {
                    generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_PINK_HIBISCUS);
                }
                if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_185446_X})) {
                    generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_RED_HIBISCUS);
                }
                if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_222370_aw})) {
                    generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_MAGENTA_HIBISCUS);
                }
                if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_76792_x})) {
                    generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_PURPLE_HIBISCUS);
                }
            }
        }
        if (((Boolean)EnvironmentalConfig.COMMON.limitFarmAnimalSpawns.get()).booleanValue()) {
            EnvironmentalBiomeFeatures.removeSpawns(event);
        }
    }

    public static void withMarshFeatures(BiomeGenerationSettingsBuilder builder) {
        builder.func_242516_a(StructureFeatures.field_244144_j);
        builder.func_242516_a(StructureFeatures.field_244136_b);
        builder.func_242516_a(StructureFeatures.field_244131_B);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243755_o((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243696_J((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243721_ae((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243723_ag((BiomeGenerationSettings.Builder)builder);
        if (((Boolean)EnvironmentalConfig.COMMON.generateGiantTallGrass.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_GIANT_TALL_GRASS_MARSH);
        }
        EnvironmentalBiomeFeatures.withMudDisks(builder);
        EnvironmentalBiomeFeatures.withMarshVegetation(builder);
        EnvironmentalBiomeFeatures.withMarshPonds(builder);
    }

    public static void withBaseBlossomFeatures(BiomeGenerationSettingsBuilder builder) {
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)builder);
        builder.func_242516_a(StructureFeatures.field_244159_y);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243696_J((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)builder);
        EnvironmentalBiomeFeatures.withBlossomVegetation(builder);
    }

    public static void withBlossomWoodsFeatures(BiomeGenerationSettingsBuilder builder) {
        EnvironmentalBiomeFeatures.withBaseBlossomFeatures(builder);
        EnvironmentalBiomeFeatures.withBlossomWoodsVegetation(builder);
    }

    public static void withBlossomValleysFeatures(BiomeGenerationSettingsBuilder builder) {
        EnvironmentalBiomeFeatures.withBaseBlossomFeatures(builder);
        EnvironmentalBiomeFeatures.withBlossomValleysVegetation(builder);
    }

    public static void withMushrooms(BiomeGenerationSettingsBuilder builder) {
        if (((Boolean)EnvironmentalConfig.COMMON.generateGiantMushrooms.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243916_cI);
        }
    }

    public static void withMarshMushrooms(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.HUGE_BROWN_MUSHROOM_MARSH);
    }

    public static void withMudDisks(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, EnvironmentalFeatures.Configured.DISK_MUD);
    }

    public static void withBlossomVegetation(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_SUGAR_CANE_BLOSSOM);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_BLOSSOM_WOODS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_TALL_BLOSSOM_WOODS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_GRASS_BLOSSOM_WOODS);
    }

    public static void withBlossomWoodsVegetation(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.CHERRY_TREE_BLOSSOM_WOODS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FALLEN_CHERRY_LEAVES_BLOSSOM_WOODS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.BIRCH_TREE_BLOSSOM_WOODS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.BAMBOO_BLOSSOM_WOODS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.BAMBOO_LIGHT_BLOSSOM_WOODS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_RED_LOTUS);
    }

    public static void withBlossomValleysVegetation(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.CHERRY_TREE_BLOSSOM_VALLEYS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FALLEN_CHERRY_LEAVES_BLOSSOM_VALLEYS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.BIRCH_TREE_BLOSSOM_VALLEYS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.BAMBOO_BLOSSOM_VALLEYS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.BAMBOO_LIGHT_BLOSSOM_VALLEYS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_WHITE_LOTUS);
    }

    public static void withMarshPonds(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.SPRING_WATER_MARSH);
        builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, EnvironmentalFeatures.Configured.LAKE_WATER_MARSH);
    }

    public static void withCattails(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_CATTAILS);
    }

    public static void withMarshVegetation(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.MARSH_OAK);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_BLUE_ORCHID);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_CORNFLOWER);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.FLOWER_DIANTHUS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_WATERLILLY_MARSH);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_GRASS_MARSH);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_TALL_GRASS_MARSH);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_CATTAILS_DENSE);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_DUCKWEED_MARSH);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.SEAGRASS_MARSH);
        if (((Boolean)EnvironmentalConfig.COMMON.generateRice.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_RICE);
        }
    }

    public static void removeSwampTrees(BiomeGenerationSettingsBuilder builder) {
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            ArrayList<Supplier> toRemove = new ArrayList<Supplier>();
            List configuredFeatures = builder.getFeatures(stage);
            for (Supplier configuredFeatureSupplier : configuredFeatures) {
                IFeatureConfig config = ((ConfiguredFeature)configuredFeatureSupplier.get()).field_222738_b;
                if (!(config instanceof DecoratedFeatureConfig)) continue;
                ConfiguredFeature decorated = (ConfiguredFeature)((DecoratedFeatureConfig)config).field_214689_a.get();
                if (!(decorated.field_222738_b instanceof DecoratedFeatureConfig)) continue;
                ConfiguredFeature decorated2 = (ConfiguredFeature)((DecoratedFeatureConfig)decorated.field_222738_b).field_214689_a.get();
                if (decorated2.field_222737_a != Feature.field_236291_c_ || !(decorated2.field_222738_b instanceof BaseTreeFeatureConfig)) continue;
                BaseTreeFeatureConfig tree = (BaseTreeFeatureConfig)decorated2.field_222738_b;
                if (!tree.field_227370_o_.contains(LeaveVineTreeDecorator.field_236871_b_) || tree.field_236680_i_ != 1) continue;
                toRemove.add(configuredFeatureSupplier);
            }
            toRemove.forEach(configuredFeatures::remove);
        }
    }

    private static void removeSpawns(BiomeLoadingEvent event) {
        MobSpawnInfoBuilder spawns = event.getSpawns();
        ArrayList<MobSpawnInfo.Spawners> entrysToRemove = new ArrayList<MobSpawnInfo.Spawners>();
        for (MobSpawnInfo.Spawners entry : spawns.getSpawner(EntityClassification.CREATURE)) {
            if (event.getCategory() != Biome.Category.FOREST && (entry.field_242588_c == EntityType.field_200784_X || entry.field_242588_c == EntityType.field_200795_i)) {
                entrysToRemove.add(entry);
            }
            if (event.getCategory() == Biome.Category.PLAINS || entry.field_242588_c != EntityType.field_200796_j && entry.field_242588_c != EntityType.field_200737_ac) continue;
            entrysToRemove.add(entry);
        }
        spawns.getSpawner(EntityClassification.CREATURE).removeAll(entrysToRemove);
    }
}

