/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.core.registry;

import com.google.common.collect.ImmutableSet;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalBiomes;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.ai.brain.task.GiveHeroGiftsTask;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnvironmentalVillagers {
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"environmental");
    public static final DeferredRegister<PointOfInterestType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"environmental");
    public static final RegistryObject<PointOfInterestType> KILN = POI_TYPES.register("kiln", () -> new PointOfInterestType("ceramist", PointOfInterestType.func_221042_a((Block)((Block)EnvironmentalBlocks.KILN.get())), 1, 1));
    public static final RegistryObject<PointOfInterestType> SAWMILL = POI_TYPES.register("sawmill", () -> new PointOfInterestType("carpenter", PointOfInterestType.func_221042_a((Block)((Block)EnvironmentalBlocks.SAWMILL.get())), 1, 1));
    public static final RegistryObject<VillagerProfession> CERAMIST = PROFESSIONS.register("ceramist", () -> new VillagerProfession("ceramist", (PointOfInterestType)KILN.get(), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.field_219695_mC));
    public static final RegistryObject<VillagerProfession> CARPENTER = PROFESSIONS.register("carpenter", () -> new VillagerProfession("carpenter", (PointOfInterestType)SAWMILL.get(), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.field_219703_mK));

    public static void registerVillagerTypes() {
        VillagerTrades.field_221239_a.isEmpty();
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("ice_spikes"), Biomes.field_185445_W);
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("flower_forest"), Biomes.field_185444_T);
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("blossom"), EnvironmentalBiomes.BLOSSOM_WOODS.getKey(), EnvironmentalBiomes.BLOSSOM_HILLS.getKey(), EnvironmentalBiomes.BLOSSOM_HIGHLANDS.getKey(), EnvironmentalBiomes.BLOSSOM_VALLEYS.getKey());
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("forest"), Biomes.field_76767_f, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_185448_Z, Biomes.field_185429_aa);
        GiveHeroGiftsTask.field_220403_a.put(CERAMIST.get(), new ResourceLocation("environmental", "gameplay/hero_of_the_village/ceramist_gift"));
        GiveHeroGiftsTask.field_220403_a.put(CARPENTER.get(), new ResourceLocation("environmental", "gameplay/hero_of_the_village/carpenter_gift"));
        EnvironmentalVillagers.setupVillagerHouses();
    }

    private static VillagerType createType(String type) {
        return VillagerType.func_221171_a((String)("environmental:" + type));
    }

    private static void registerVillagerType(VillagerType type, RegistryKey<Biome> ... biomes) {
        for (RegistryKey<Biome> biome : biomes) {
            VillagerType.field_221180_h.put(biome, type);
        }
    }

    public static void registerPOIs() {
        try {
            ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"func_221052_a", (Class[])new Class[]{PointOfInterestType.class}).invoke(null, KILN.get());
            ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"func_221052_a", (Class[])new Class[]{PointOfInterestType.class}).invoke(null, SAWMILL.get());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setupVillagerHouses() {
        PlainsVillagePools.func_214744_a();
        SnowyVillagePools.func_214746_a();
        SavannaVillagePools.func_214745_a();
        DesertVillagePools.func_222739_a();
        TaigaVillagePools.func_214806_a();
        EnvironmentalVillagers.addVillagerHouse("ceramist", "plains", 2);
        EnvironmentalVillagers.addVillagerHouse("ceramist", "snowy", 4);
        EnvironmentalVillagers.addVillagerHouse("ceramist", "savanna", 6);
        EnvironmentalVillagers.addVillagerHouse("ceramist", "desert", 5);
        EnvironmentalVillagers.addVillagerHouse("ceramist", "taiga", 7);
        EnvironmentalVillagers.addVillagerHouse("carpenter", "plains", 10);
        EnvironmentalVillagers.addVillagerHouse("carpenter", "snowy", 11);
        EnvironmentalVillagers.addVillagerHouse("carpenter", "savanna", 7);
        EnvironmentalVillagers.addVillagerHouse("carpenter", "desert", 9);
        EnvironmentalVillagers.addVillagerHouse("carpenter", "taiga", 5);
    }

    private static void addVillagerHouse(String type, String biome, int weight) {
        EnvironmentalVillagers.addToPool(new ResourceLocation("village/" + biome + "/houses"), new ResourceLocation("environmental", "village/" + type + "_house_" + biome + "_1"), 5);
    }

    private static void addToPool(ResourceLocation pool, ResourceLocation toAdd, int weight) {
        JigsawPattern old = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(pool);
        List shuffled = old.func_214943_b(new Random());
        ArrayList<Pair> newPieces = new ArrayList<Pair>();
        for (JigsawPiece p : shuffled) {
            newPieces.add(new Pair((Object)p, (Object)1));
        }
        newPieces.add(Pair.of((Object)new LegacySingleJigsawPiece(Either.left((Object)toAdd), () -> ProcessorLists.field_244101_a, JigsawPattern.PlacementBehaviour.RIGID), (Object)weight));
        ResourceLocation name = old.func_214947_b();
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243656_h, (ResourceLocation)pool, (Object)new JigsawPattern(pool, name, newPieces));
    }
}

