/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.environmentalcreepers.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fi.dy.masa.environmentalcreepers.EnvironmentalCreepers;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nullable;

public class JsonUtils {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @Nullable
    public static JsonObject getNestedObject(JsonObject parent, String key, boolean create) {
        if (!parent.has(key) || !parent.get(key).isJsonObject()) {
            if (!create) {
                return null;
            }
            JsonObject obj = new JsonObject();
            parent.add(key, (JsonElement)obj);
            return obj;
        }
        return parent.get(key).getAsJsonObject();
    }

    @Nullable
    public static JsonElement parseJsonFile(File file) {
        if (file != null && file.exists() && file.isFile() && file.canRead()) {
            String fileName = file.getAbsolutePath();
            try {
                JsonParser parser = new JsonParser();
                FileReader reader = new FileReader(file);
                JsonElement element = parser.parse((Reader)reader);
                reader.close();
                return element;
            }
            catch (Exception e) {
                EnvironmentalCreepers.logger.error("Failed to parse the JSON file '{}'", (Object)fileName, (Object)e);
            }
        }
        return null;
    }

    public static boolean writeJsonToFile(JsonElement root, File file) {
        return JsonUtils.writeJsonToFile(GSON, root, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeJsonToFile(Gson gson, JsonElement root, File file) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(gson.toJson(root));
            writer.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            EnvironmentalCreepers.logger.warn("Failed to write JSON data to file '{}'", (Object)file.getAbsolutePath(), (Object)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                EnvironmentalCreepers.logger.warn("Failed to close JSON file", (Throwable)e);
            }
        }
        return false;
    }
}

