/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.environmentalcreepers.config.options;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.environmentalcreepers.EnvironmentalCreepers;
import fi.dy.masa.environmentalcreepers.config.options.ConfigBase;
import java.util.List;

public class ConfigStringList
extends ConfigBase {
    private final ImmutableList<String> defaultValue;
    private ImmutableList<String> value;

    public ConfigStringList(String name, ImmutableList<String> defaultValue, String comment) {
        super(name, comment);
        this.defaultValue = defaultValue;
        this.value = ImmutableList.copyOf(defaultValue);
    }

    public ImmutableList<String> getValue() {
        return this.value;
    }

    public void setValue(List<String> newStrings) {
        this.value = ImmutableList.copyOf(newStrings);
    }

    @Override
    public void resetToDefault() {
        this.value = this.defaultValue;
    }

    @Override
    public void setValueFromJsonElement(JsonElement element, String configName) {
        try {
            if (element.isJsonArray()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                JsonArray arr = element.getAsJsonArray();
                int count = arr.size();
                for (int i = 0; i < count; ++i) {
                    builder.add((Object)arr.get(i).getAsString());
                }
                this.value = builder.build();
            } else {
                this.value = ImmutableList.of();
                EnvironmentalCreepers.logger.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)configName, (Object)element);
            }
        }
        catch (Exception e) {
            this.value = ImmutableList.of();
            EnvironmentalCreepers.logger.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)configName, (Object)element, (Object)e);
        }
    }

    @Override
    public JsonElement getAsJsonElement() {
        JsonArray arr = new JsonArray();
        for (String str : this.value) {
            arr.add((JsonElement)new JsonPrimitive(str));
        }
        return arr;
    }
}

