/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.environmentalcreepers.mixin;

import fi.dy.masa.environmentalcreepers.EnvironmentalCreepers;
import fi.dy.masa.environmentalcreepers.config.Configs;
import fi.dy.masa.environmentalcreepers.mixin.IMixinCreeperEntity;
import fi.dy.masa.environmentalcreepers.util.ExplosionUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_169;
import net.minecraft.class_181;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5362;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1927.class})
public abstract class MixinExplosion {
    @Shadow
    @Final
    private class_1937 field_9187;
    @Shadow
    @Final
    private class_1297 field_9185;
    @Shadow
    @Final
    private ObjectArrayList<class_2338> field_9188;
    @Shadow
    @Final
    private double field_9195;
    @Shadow
    @Final
    private double field_9192;
    @Shadow
    @Final
    private double field_9189;
    @Shadow
    @Final
    @Mutable
    private float field_9190;

    @Shadow
    @Nullable
    public abstract class_1309 method_8347();

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/damage/DamageSource;Lnet/minecraft/world/explosion/ExplosionBehavior;DDDFZLnet/minecraft/world/explosion/Explosion$DestructionType;)V"}, at={@At(value="RETURN")})
    private void envc_modifyExplosionSize(class_1937 world, @javax.annotation.Nullable class_1297 entity, @javax.annotation.Nullable class_1282 damageSource, @javax.annotation.Nullable class_5362 explosionBehavior, double x, double y, double z, float power, boolean fire, class_1927.class_4179 destructionType, CallbackInfo ci) {
        if (entity instanceof class_1548 && Configs.Toggles.MODIFY_CREEPER_EXPLOSION_STRENGTH.getValue()) {
            this.field_9190 = (Boolean)entity.method_5841().method_12789(IMixinCreeperEntity.envc_getCharged()) != false ? Configs.Generic.CREEPER_EXPLOSION_STRENGTH_CHARGED.getFloatValue() : Configs.Generic.CREEPER_EXPLOSION_STRENGTH_NORMAL.getFloatValue();
        }
    }

    @Inject(method={"affectWorld"}, at={@At(value="HEAD")}, cancellable=true)
    private void envc_disableExplosionBlockDamageOrCompletely(CallbackInfo ci) {
        if (!this.field_9187.field_9236) {
            EnvironmentalCreepers.logInfo(this::envc_printExplosionInfo);
        }
        if (Configs.Toggles.DISABLE_ALL_EXPLOSIONS.getValue()) {
            EnvironmentalCreepers.logInfo("MixinExplosion.envc_disableExplosionBlockDamageOrCompletely(), type: '{}'", this.field_9185 instanceof class_1548 ? "Creeper" : "Other");
            ci.cancel();
        } else if (this.field_9185 instanceof class_1548) {
            if (Configs.Toggles.DISABLE_CREEPER_EXPLOSION_BLOCK_DAMAGE.getValue() || Configs.Toggles.CREEPER_ALTITUDE_CONDITION.getValue() && (this.field_9192 < Configs.Generic.CREEPER_ALTITUDE_DAMAGE_MIN_Y.getValue() || this.field_9192 > Configs.Generic.CREEPER_ALTITUDE_DAMAGE_MAX_Y.getValue())) {
                EnvironmentalCreepers.logInfo("MixinExplosion.envc_disableExplosionBlockDamageOrCompletely: clearAffectedBlockPositions(), type: 'Creeper'", new Object[0]);
                this.field_9188.clear();
            }
            if (Configs.Toggles.CREEPER_EXPLOSION_CHAIN_REACTION.getValue()) {
                ExplosionUtils.causeCreeperChainReaction(this.field_9187, new class_243(this.field_9195, this.field_9192, this.field_9189));
            }
        } else if (Configs.Toggles.DISABLE_OTHER_EXPLOSION_BLOCK_DAMAGE.getValue() && !(this.field_9185 instanceof class_1548)) {
            EnvironmentalCreepers.logInfo("MixinExplosion.envc_disableExplosionBlockDamageOrCompletely: clearAffectedBlockPositions(), type: 'Other'", new Object[0]);
            this.field_9188.clear();
        }
    }

    @Inject(method={"affectWorld"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Util;shuffle(Lit/unimi/dsi/fastutil/objects/ObjectArrayList;Lnet/minecraft/util/math/random/Random;)V")})
    private void envc_preventItemDrops(boolean particles, CallbackInfo ci) {
        if (this.field_9185 instanceof class_1548) {
            if (Configs.Toggles.MODIFY_CREEPER_EXPLOSION_DROP_CHANCE.getValue() && Configs.Generic.CREEPER_EXPLOSION_BLOCK_DROP_CHANCE.getFloatValue() == 0.0f) {
                this.envc_removeBlocks();
            }
        } else if (Configs.Toggles.MODIFY_OTHER_EXPLOSION_DROP_CHANCE.getValue() && Configs.Generic.OTHER_EXPLOSION_BLOCK_DROP_CHANCE.getFloatValue() == 0.0f) {
            this.envc_removeBlocks();
        }
    }

    @Redirect(method={"affectWorld"}, allow=1, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/explosion/Explosion$DestructionType;DESTROY_WITH_DECAY:Lnet/minecraft/world/explosion/Explosion$DestructionType;")), at=@At(value="INVOKE", target="Lnet/minecraft/loot/context/LootContextParameterSet$Builder;add(Lnet/minecraft/loot/context/LootContextParameter;Ljava/lang/Object;)Lnet/minecraft/loot/context/LootContextParameterSet$Builder;"))
    private <T> class_8567.class_8568 envc_modifyDropChance(class_8567.class_8568 builder, class_169<T> key, T value) {
        float dropChance;
        if (this.field_9185 instanceof class_1548) {
            float dropChance2;
            if (Configs.Toggles.MODIFY_CREEPER_EXPLOSION_DROP_CHANCE.getValue() && (dropChance2 = Configs.Generic.CREEPER_EXPLOSION_BLOCK_DROP_CHANCE.getFloatValue()) > 0.0f && dropChance2 < 1.0f) {
                float size = 1.0f / dropChance2;
                return builder.method_51874(class_181.field_1225, (Object)Float.valueOf(size));
            }
        } else if (Configs.Toggles.MODIFY_OTHER_EXPLOSION_DROP_CHANCE.getValue() && (dropChance = Configs.Generic.OTHER_EXPLOSION_BLOCK_DROP_CHANCE.getFloatValue()) > 0.0f && dropChance < 1.0f) {
            float size = 1.0f / dropChance;
            return builder.method_51874(class_181.field_1225, (Object)Float.valueOf(size));
        }
        return builder;
    }

    @Inject(method={"collectBlocksAndDamageEntities"}, at={@At(value="HEAD")}, cancellable=true)
    private void envc_disableExplosionCompletely1(CallbackInfo ci) {
        if (Configs.Toggles.DISABLE_ALL_EXPLOSIONS.getValue()) {
            EnvironmentalCreepers.logInfo("MixinExplosion.disableExplosionCompletely1(), type: '{}'", this.field_9185 instanceof class_1548 ? "Creeper" : "Other");
            ci.cancel();
        }
    }

    @ModifyVariable(method={"collectBlocksAndDamageEntities"}, ordinal=0, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/World;getOtherEntities(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Box;)Ljava/util/List;"), to=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isImmuneToExplosion()Z")), at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Vec3d;<init>(DDD)V"))
    private List<class_1297> envc_disableExplosionEntityDamage(List<class_1297> list) {
        HashSet<class_1297> immune = new HashSet<class_1297>();
        for (class_1297 e : list) {
            if (!this.envc_isImmuneToExplosion(e)) continue;
            immune.add(e);
        }
        if (!immune.isEmpty()) {
            EnvironmentalCreepers.logInfo("MixinExplosion.disableExplosionEntityDamage(), type: '{}'", this.field_9185 instanceof class_1548 ? "Creeper" : "Other");
            list.removeAll(immune);
        }
        return list;
    }

    private boolean envc_isImmuneToExplosion(class_1297 entity) {
        Configs.ListType type = Configs.Lists.entityClassListType;
        if (this.field_9185 instanceof class_1548 ? (Configs.Toggles.DISABLE_CREEPER_EXPLOSION_ENTITY_DAMAGE.getValue() || Configs.Toggles.DISABLE_CREEPER_EXPLOSION_ITEM_DAMAGE.getValue() && entity instanceof class_1542) && (type == Configs.ListType.NONE || type == Configs.ListType.WHITELIST && Configs.EXPLOSION_ENTITY_WHITELIST.contains(entity.getClass()) || type == Configs.ListType.BLACKLIST && !Configs.EXPLOSION_ENTITY_BLACKLIST.contains(entity.getClass())) : (Configs.Toggles.DISABLE_OTHER_EXPLOSION_ENTITY_DAMAGE.getValue() || Configs.Toggles.DISABLE_OTHER_EXPLOSION_ITEM_DAMAGE.getValue() && entity instanceof class_1542) && (type == Configs.ListType.NONE || type == Configs.ListType.WHITELIST && Configs.EXPLOSION_ENTITY_WHITELIST.contains(entity.getClass()) || type == Configs.ListType.BLACKLIST && !Configs.EXPLOSION_ENTITY_BLACKLIST.contains(entity.getClass()))) {
            return true;
        }
        return entity.method_5659();
    }

    private void envc_removeBlocks() {
        class_2680 air = class_2246.field_10124.method_9564();
        this.field_9187.method_16107().method_15396("explosion_blocks");
        for (class_2338 pos : this.field_9188) {
            class_2680 state = this.field_9187.method_8320(pos);
            if (state.method_26215()) continue;
            this.field_9187.method_8652(pos, air, 3);
            state.method_26204().method_9586(this.field_9187, pos, (class_1927)this);
        }
        this.field_9187.method_16107().method_15407();
        this.field_9188.clear();
    }

    private String envc_printExplosionInfo() {
        return String.format("Explosion @ [%.5f, %.5f, %.5f], power: %.2f - type: '%s' - explosion class: '%s', placer: '%s'", this.field_9195, this.field_9192, this.field_9189, Float.valueOf(this.field_9190), this.field_9185 instanceof class_1548 ? "Creeper" : "Other", this.getClass().getName(), this.method_8347() != null ? this.method_8347().getClass().getName() : "<null>");
    }
}

