/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.environmentalcreepers.event;

import fi.dy.masa.environmentalcreepers.EnvironmentalCreepers;
import fi.dy.masa.environmentalcreepers.config.Configs;
import java.lang.reflect.Field;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class CreeperEventHandler {
    private static final Field field_Creeper_timeSinceIgnited = ObfuscationReflectionHelper.findField(Creeper.class, (String)"f_32270_");
    private static final Field field_Creeper_fuseTime = ObfuscationReflectionHelper.findField(Creeper.class, (String)"f_32271_");
    public static final CreeperEventHandler INSTANCE = new CreeperEventHandler();
    private boolean registered;

    public void register() {
        if (!this.registered) {
            EnvironmentalCreepers.logInfo("Registering CreeperEventHandler", new Object[0]);
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.registered = true;
        }
    }

    public void unregister() {
        if (this.registered) {
            EnvironmentalCreepers.logInfo("Unregistering CreeperEventHandler", new Object[0]);
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.registered = false;
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Creeper creeper;
        int state;
        Entity entity;
        if (Configs.Toggles.disableCreeperExplosionCompletely && (entity = event.getEntity()) instanceof Creeper && (state = (creeper = (Creeper)entity).m_32310_()) > 0) {
            try {
                int timeSinceIgnited = (Integer)field_Creeper_timeSinceIgnited.get(creeper);
                int fuseTime = (Integer)field_Creeper_fuseTime.get(creeper);
                if (timeSinceIgnited >= fuseTime - state - 1) {
                    field_Creeper_timeSinceIgnited.set(creeper, fuseTime - state - 1);
                }
            }
            catch (Exception e) {
                EnvironmentalCreepers.logger.warn("CreeperEventHandler.onLivingUpdate(): Exception while trying to reflect Creeper fields");
            }
        }
    }
}

