/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.environmentalcreepers.event;

import com.mojang.datafixers.util.Pair;
import fi.dy.masa.environmentalcreepers.EnvironmentalCreepers;
import fi.dy.masa.environmentalcreepers.config.Configs;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ExplosionEventHandler {
    private final Field fieldExplosionSize = ObfuscationReflectionHelper.findField(Explosion.class, (String)"f_46017_");
    private final Field fieldExplosionMode = ObfuscationReflectionHelper.findField(Explosion.class, (String)"f_46010_");
    private final Field fieldExploder = ObfuscationReflectionHelper.findField(Explosion.class, (String)"f_46016_");
    private final Field fieldCausesFire = ObfuscationReflectionHelper.findField(Explosion.class, (String)"f_46009_");

    @SubscribeEvent
    public void onExplosionStart(ExplosionEvent.Start event) {
        Explosion explosion = event.getExplosion();
        if (Configs.Lists.explosionClassListType == Configs.ListType.WHITELIST && !Configs.EXPLOSION_CLASS_WHITELIST.contains(explosion.getClass()) || Configs.Lists.explosionClassListType == Configs.ListType.BLACKLIST && Configs.EXPLOSION_CLASS_BLACKLIST.contains(explosion.getClass())) {
            if (Configs.Generic.verboseLogging) {
                EnvironmentalCreepers.logInfo("Explosion (blocked by white- or blacklist): class: {}, position: {}", explosion.getClass().getName(), explosion.getPosition());
            }
            return;
        }
        if (Configs.Generic.verboseLogging) {
            EnvironmentalCreepers.logInfo("Explosion: class: {}, position: {}", explosion.getClass().getName(), explosion.getPosition());
        }
        if (explosion.m_46079_() instanceof Creeper) {
            if (Configs.Toggles.modifyCreeperExplosionDropChance && !Configs.Toggles.disableCreeperExplosionBlockDamage) {
                this.replaceExplosion(event, true);
            }
        } else if (Configs.Toggles.modifyOtherExplosionDropChance && !Configs.Toggles.disableOtherExplosionBlockDamage) {
            this.replaceExplosion(event, false);
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        if (Configs.Lists.explosionClassListType == Configs.ListType.WHITELIST && !Configs.EXPLOSION_CLASS_WHITELIST.contains(explosion.getClass()) || Configs.Lists.explosionClassListType == Configs.ListType.BLACKLIST && Configs.EXPLOSION_CLASS_BLACKLIST.contains(explosion.getClass())) {
            return;
        }
        if (explosion.m_46079_() instanceof Creeper) {
            if (Configs.Toggles.disableCreeperExplosionItemDamage) {
                this.removeItemEntities(event.getAffectedEntities(), true);
            }
            if (Configs.Toggles.disableCreeperExplosionBlockDamage || Configs.Toggles.enableCreeperAltitudeCondition && (explosion.getPosition().f_82480_ < Configs.Generic.creeperAltitudeDamageMinY || explosion.getPosition().f_82480_ > Configs.Generic.creeperAltitudeDamageMaxY)) {
                EnvironmentalCreepers.logInfo("ExplosionEventHandler - clearAffectedBlockPositions() - Type: 'Creeper'", new Object[0]);
                explosion.m_46080_();
            }
            if (Configs.Toggles.enableCreeperExplosionChainReaction) {
                this.causeCreeperChainReaction(event.getWorld(), explosion.getPosition());
            }
        } else {
            if (Configs.Toggles.disableOtherExplosionItemDamage) {
                this.removeItemEntities(event.getAffectedEntities(), false);
            }
            if (Configs.Toggles.disableOtherExplosionBlockDamage) {
                EnvironmentalCreepers.logInfo("ExplosionEventHandler - clearAffectedBlockPositions() - Type: 'Other'", new Object[0]);
                explosion.m_46080_();
            }
        }
    }

    private void removeItemEntities(List<Entity> list, boolean isCreeper) {
        EnvironmentalCreepers.logInfo("ExplosionEventHandler.removeItemEntities() - Type: '{}'", isCreeper ? "Creeper" : "Other");
        Iterator<Entity> iter = list.iterator();
        Configs.ListType type = Configs.Lists.entityClassListType;
        while (iter.hasNext()) {
            Entity entity = iter.next();
            if (!(entity instanceof ItemEntity) || type != Configs.ListType.NONE && (type != Configs.ListType.WHITELIST || !Configs.EXPLOSION_ENTITY_WHITELIST.contains(entity.getClass())) && (type != Configs.ListType.BLACKLIST || Configs.EXPLOSION_ENTITY_BLACKLIST.contains(entity.getClass()))) continue;
            iter.remove();
        }
    }

    private void replaceExplosion(ExplosionEvent.Start event, boolean isCreeper) {
        Level world = event.getWorld();
        Explosion explosion = event.getExplosion();
        if (Configs.Generic.verboseLogging) {
            EnvironmentalCreepers.logInfo("Replacing the explosion for type '{}' (class: {})", isCreeper ? "Creeper" : "Other", explosion.getClass().getName());
        }
        try {
            float explosionSize;
            boolean causesFire = this.fieldCausesFire.getBoolean(explosion);
            Explosion.BlockInteraction mode = (Explosion.BlockInteraction)this.fieldExplosionMode.get(explosion);
            if (isCreeper && Configs.Toggles.modifyCreeperExplosionStrength) {
                explosionSize = ((Creeper)explosion.m_46079_()).m_7090_() ? (float)Configs.Generic.creeperExplosionStrengthCharged : (float)Configs.Generic.creeperExplosionStrengthNormal;
                this.fieldExplosionSize.setFloat(explosion, explosionSize);
            } else {
                explosionSize = this.fieldExplosionSize.getFloat(explosion);
            }
            explosion.m_46061_();
            Level level = world;
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                Vec3 pos = explosion.getPosition();
                if (isCreeper && Configs.Toggles.enableCreeperAltitudeCondition && (pos.f_82480_ < Configs.Generic.creeperAltitudeDamageMinY || pos.f_82480_ > Configs.Generic.creeperAltitudeDamageMaxY)) {
                    mode = Explosion.BlockInteraction.NONE;
                }
                if (mode == Explosion.BlockInteraction.NONE) {
                    explosion.m_46080_();
                }
                this.finalizeExplosion(world, explosion, mode, false, causesFire, explosionSize, isCreeper);
                for (ServerPlayer player : serverWorld.m_6907_()) {
                    if (!(player.m_20275_(pos.f_82479_, pos.f_82480_, pos.f_82481_) < 4096.0)) continue;
                    player.f_8906_.m_141995_((Packet)new ClientboundExplodePacket(pos.f_82479_, pos.f_82480_, pos.f_82481_, explosionSize, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(player)));
                }
            } else {
                this.finalizeExplosion(world, explosion, mode, true, causesFire, explosionSize, isCreeper);
            }
        }
        catch (IllegalAccessException e) {
            EnvironmentalCreepers.logger.error("IllegalAccessException while reflecting explosion fields", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            EnvironmentalCreepers.logger.error("IllegalArgumentException while reflecting explosion fields", (Throwable)e);
        }
        event.setCanceled(true);
    }

    private void finalizeExplosion(Level world, Explosion explosion, Explosion.BlockInteraction mode, boolean spawnParticles, boolean causesFire, float explosionSize, boolean isCreeper) {
        Vec3 posVec = explosion.getPosition();
        Random rand = world.f_46441_;
        boolean breaksBlock = mode != Explosion.BlockInteraction.NONE && (isCreeper ? !Configs.Toggles.disableCreeperExplosionBlockDamage : !Configs.Toggles.disableOtherExplosionBlockDamage);
        world.m_6263_(null, posVec.f_82479_, posVec.f_82480_, posVec.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.2f) * 0.7f);
        if (spawnParticles) {
            if (explosionSize >= 2.0f && breaksBlock) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123812_, posVec.f_82479_, posVec.f_82480_, posVec.f_82481_, 1.0, 0.0, 0.0);
            } else {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, posVec.f_82479_, posVec.f_82480_, posVec.f_82481_, 1.0, 0.0, 0.0);
            }
        }
        float dropChance = (float)(isCreeper ? Configs.Generic.creeperExplosionBlockDropChance : Configs.Generic.otherExplosionBlockDropChance);
        EnvironmentalCreepers.logInfo("ExplosionEventHandler.doExplosionB() - Type: '{}', drop chance: {}", isCreeper ? "Creeper" : "Other", Float.valueOf(dropChance));
        if (breaksBlock) {
            ObjectArrayList drops = new ObjectArrayList();
            Collections.shuffle(explosion.m_46081_(), world.f_46441_);
            for (BlockPos pos : explosion.m_46081_()) {
                BlockState state = world.m_8055_(pos);
                if (state.m_60795_()) continue;
                world.m_46473_().m_6180_("explosion_blocks");
                if (world instanceof ServerLevel && state.canDropFromExplosion((BlockGetter)world, pos, explosion) && dropChance > 0.0f) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    BlockEntity te = state.m_155947_() ? world.m_7702_(pos) : null;
                    Entity exploder = this.getExploder(explosion);
                    LootContext.Builder builder = new LootContext.Builder(serverWorld).m_78977_(rand).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)te).m_78984_(LootContextParams.f_81455_, (Object)exploder);
                    if (dropChance < 1.0f) {
                        float size = 1.0f / dropChance;
                        builder.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(size));
                    }
                    state.m_60724_(builder).forEach(stack -> ExplosionEventHandler.mergeStackToPreviousDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)drops, stack, pos));
                }
                state.onBlockExploded(world, pos, explosion);
                world.m_46473_().m_7238_();
            }
            for (Pair pair : drops) {
                Block.m_49840_((Level)world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (causesFire) {
            BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
            for (BlockPos pos : explosion.m_46081_()) {
                if (rand.nextInt(3) != 0 || !world.m_8055_(pos).m_60795_()) continue;
                posMutable.m_122159_((Vec3i)pos, Direction.DOWN);
                if (!world.m_8055_((BlockPos)posMutable).m_60804_((BlockGetter)world, (BlockPos)posMutable)) continue;
                world.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)world, (BlockPos)pos));
            }
        }
    }

    @Nullable
    private Entity getExploder(Explosion explosion) {
        try {
            return (Entity)this.fieldExploder.get(explosion);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void mergeStackToPreviousDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> drops, ItemStack stack, BlockPos pos) {
        int size = drops.size();
        for (int i = 0; i < size; ++i) {
            Pair pair = (Pair)drops.get(i);
            ItemStack stackTmp = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)stackTmp, (ItemStack)stack)) continue;
            ItemStack stackNew = ItemEntity.m_32029_((ItemStack)stackTmp, (ItemStack)stack, (int)16);
            drops.set(i, (Object)Pair.of((Object)stackNew, (Object)((BlockPos)pair.getSecond())));
            if (!stack.m_41619_()) continue;
            return;
        }
        drops.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    private void causeCreeperChainReaction(Level world, Vec3 explosionPos) {
        EnvironmentalCreepers.logInfo("ExplosionEventHandler.causeCreeperChainReaction() - Explosion Position: '{}'", explosionPos);
        double r = Configs.Generic.creeperChainReactionMaxDistance;
        double rSq = r * r;
        AABB bb = new AABB(explosionPos.f_82479_ - r, explosionPos.f_82480_ - r, explosionPos.f_82481_ - r, explosionPos.f_82479_ + r, explosionPos.f_82480_ + r, explosionPos.f_82481_ + r);
        List list = world.m_6443_(Creeper.class, bb, ent -> ent.m_21223_() > 0.0f);
        for (Creeper creeper : list) {
            if (creeper.m_32311_() || !((double)world.f_46441_.nextFloat() < Configs.Generic.creeperChainReactionChance) || !(creeper.m_20275_(explosionPos.f_82479_, explosionPos.f_82480_, explosionPos.f_82481_) <= rSq)) continue;
            EnvironmentalCreepers.logInfo("ExplosionEventHandler.causeCreeperChainReaction() - Igniting Creeper: '{}'", creeper.toString());
            creeper.m_32312_();
        }
    }
}

