/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.environmentalcreepers;

import com.mojang.brigadier.CommandDispatcher;
import fi.dy.masa.environmentalcreepers.commands.CommandReloadConfig;
import fi.dy.masa.environmentalcreepers.config.Configs;
import fi.dy.masa.environmentalcreepers.event.ExplosionEventHandler;
import java.io.File;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="environmentalcreepers")
public class EnvironmentalCreepers {
    public static final Logger logger = LogManager.getLogger((String)"environmentalcreepers");

    public EnvironmentalCreepers() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configs.COMMON_CONFIG, "environmentalcreepers.toml");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (incoming, isNetwork) -> true));
        MinecraftForge.EVENT_BUS.register((Object)new ExplosionEventHandler());
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
        MinecraftForge.EVENT_BUS.addListener(this::onServerAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
        Configs.loadConfig(FMLPaths.CONFIGDIR.get().resolve("environmentalcreepers.toml"));
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        Configs.setGlobalConfigDirAndLoadConfigs(FMLPaths.CONFIGDIR.get().toFile());
    }

    private void onServerAboutToStart(ServerAboutToStartEvent event) {
        File dataDir = event.getServer().m_129843_(new LevelResource("environmentalcreepers")).toFile();
        Configs.loadConfigsFromPerWorldConfigIfExists(dataDir);
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        CommandReloadConfig.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void serverStopping(ServerStoppingEvent event) {
        Configs.loadConfigsFromGlobalConfigFile();
    }

    public static void logInfo(String message, Object ... params) {
        if (Configs.Generic.verboseLogging) {
            logger.info(message, params);
        }
    }
}

