/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.mojang.brigadier.CommandDispatcher;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.support.Env;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3414;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;

public final class Agnos {
    public static void runForCommandRegistration(CommandRegistrationCallback r) {
        net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback.EVENT.register(r::register);
    }

    @Environment(value=EnvType.CLIENT)
    public static void runForTooltipRender(TooltipRenderCallback r) {
        ItemTooltipCallback.EVENT.register((stack, ctx, lines) -> r.render(stack, lines));
    }

    @Environment(value=EnvType.CLIENT)
    public static void runForHudRender(HudRenderCallback r) {
        net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback.EVENT.register((ms, d) -> r.render(ms, d));
    }

    public static class_3414 registerSoundEvent(class_2960 id, class_3414 soundEvent) {
        return (class_3414)class_2378.method_10230((class_2378)class_2378.field_11156, (class_2960)id, (Object)soundEvent);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_304 registerKeyBinding(class_304 kb) {
        KeyBindingHelper.registerKeyBinding((class_304)kb);
        return kb;
    }

    public static boolean eventsAvailable() {
        return true;
    }

    public static Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static Env getCurrentEnv() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? Env.CLIENT : Env.SERVER;
    }

    public static boolean isModLoaded(String modid) {
        if (modid.startsWith("forge:")) {
            return false;
        }
        if (modid.startsWith("fabric:")) {
            modid = modid.substring(7);
        }
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    public static String getModVersion() {
        if (FabRefl.DEV) {
            return "DEV";
        }
        return ((ModContainer)FabricLoader.getInstance().getModContainer("fabrication").get()).getMetadata().getVersion().getFriendlyString();
    }

    public static byte[] getClassBytes(Class<?> clazz) {
        try {
            byte[] bys = FabricLauncherBase.getLauncher().getClassByteArray(clazz.getName(), true);
            ((IMixinTransformer)MixinEnvironment.getCurrentEnvironment().getActiveTransformer()).transformClassBytes(clazz.getName(), clazz.getName(), bys);
            return bys;
        }
        catch (Throwable e) {
            FabLog.warn("Failed to look up " + clazz, e);
            return null;
        }
    }

    public static String getLoaderVersion() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("fabricloader").get()).getMetadata().getVersion().getFriendlyString();
    }

    public static interface HudRenderCallback {
        public void render(class_4587 var1, float var2);
    }

    public static interface TooltipRenderCallback {
        public void render(class_1799 var1, List<class_2561> var2);
    }

    public static interface CommandRegistrationCallback {
        public void register(CommandDispatcher<class_2168> var1, boolean var2);
    }
}

