/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.escape.Escaper;
import com.google.common.io.BaseEncoding;
import com.google.common.io.Files;
import com.google.common.net.UrlEscapers;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.jna.Platform;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import com.unascribed.fabrication.support.ResolvedTrilean;
import com.unascribed.fabrication.support.Trilean;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ssl.HttpsURLConnection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_155;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL11;

public class Analytics {
    private static final Executor exec = Executors.newSingleThreadExecutor();
    private static String userId = null;
    private static long last = -1L;
    private static long first = -1L;

    public static void deleteId() {
        userId = null;
        last = -1L;
        first = -1L;
        Analytics.timerFile().delete();
        Analytics.userIdFile().delete();
        FabLog.info("Analytics user ID deleted due to opt-out");
    }

    public static void submit(String action) {
        Analytics.submit(action, Collections.emptyMap());
    }

    public static void submit(String action, Map<String, String> extraScoped) {
        if (!MixinConfigPlugin.isEnabled("*.data_upload")) {
            return;
        }
        exec.execute(() -> {
            Analytics.ensureUserIdPresent();
            Escaper ue = UrlEscapers.urlPathSegmentEscaper();
            try {
                byte[] rand = new byte[8];
                ThreadLocalRandom.current().nextBytes(rand);
                LinkedHashMap params = Maps.newLinkedHashMap();
                params.put("_id", userId);
                params.put("_idts", Long.toString(first));
                params.put("_viewts", Long.toString(last));
                params.put("url", "https://unascribed.com/fabrication");
                params.put("idsite", "2");
                params.put("rec", "1");
                params.put("apiv", "1");
                params.put("action_name", action);
                params.put("rand", BaseEncoding.base16().encode(rand));
                params.put("cookie", "0");
                params.put("send_image", "0");
                LinkedHashMap extra = Maps.newLinkedHashMap();
                extra.put("Version", Agnos.getModVersion());
                extra.put("OS", Platform.isWindows() ? "Windows" : (Platform.isMac() ? "macOS" : (Platform.isLinux() ? "Linux" : "Unknown (BSD?)")));
                extra.put("Java Version", System.getProperty("java.version"));
                extra.put("Java Vendor", System.getProperty("java.vendor"));
                String vm = System.getProperty("java.vm.name");
                vm = vm.endsWith("Zero VM") ? "Zero" : (vm.endsWith("Server VM") || vm.endsWith("Client VM") ? "HotSpot" : (vm.contains("OpenJ9") ? "OpenJ9" : "Unknown (" + vm + ")"));
                extra.put("Java VM", vm);
                extra.put("Minecraft Version", class_155.method_16673().getName());
                extra.put("Loader", (FabRefl.FORGE ? "Forge" : "Fabric") + " " + Agnos.getLoaderVersion());
                extra.put("Environment", Agnos.getCurrentEnv().name());
                extra.put("Profile", MixinConfigPlugin.getRawValue("general.profile"));
                if (Agnos.getCurrentEnv() == Env.CLIENT) {
                    Analytics.addClientData(extra);
                }
                params.put("_cvar", Analytics.processExtra(extra));
                params.put("cvar", Analytics.processExtra(extraScoped));
                String paramStr = Joiner.on((String)"&").withKeyValueSeparator("=").join(Maps.transformValues((Map)params, arg_0 -> ((Escaper)ue).escape(arg_0)));
                URL u = new URL("https://maxim.sleeping.town/matomo.php?" + paramStr);
                FabLog.debug("Submitting analytics: " + u);
                u.openStream().close();
            }
            catch (Throwable e) {
                FabLog.warn("Failed to submit Matomo data", e);
            }
            Analytics.touch();
        });
    }

    public static void submitConfig() {
        if (!MixinConfigPlugin.isEnabled("*.data_upload")) {
            return;
        }
        exec.execute(() -> {
            Analytics.ensureUserIdPresent();
            Escaper ue = UrlEscapers.urlPathSegmentEscaper();
            try {
                JsonArray requests = new JsonArray();
                for (String key : MixinConfigPlugin.getAllKeys()) {
                    ResolvedTrilean rt = MixinConfigPlugin.getResolvedValue(key);
                    requests.add("?_id=" + userId + "&_idts=" + first + "&_viewts=" + last + "&url=https://unascribed.com/fabrication/value/" + rt.value + "&idsite=2&rec=1&apiv=1&action_name=" + ue.escape(key) + "&cookie=0&cvar=" + ue.escape("{\"1\":[\"By Profile\",\"" + (rt.trilean == Trilean.UNSET ? "Yes" : "No") + "\"]}"));
                }
                JsonObject body = new JsonObject();
                body.add("requests", (JsonElement)requests);
                URL u = new URL("https://maxim.sleeping.town/matomo.php");
                HttpsURLConnection conn = (HttpsURLConnection)u.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                FabLog.debug("Submitting feature analytics: " + u);
                conn.connect();
                try (OutputStream os = conn.getOutputStream();){
                    os.write(new Gson().toJson((JsonElement)body).getBytes(Charsets.UTF_8));
                }
                conn.getInputStream().close();
            }
            catch (Throwable e) {
                FabLog.warn("Failed to submit Matomo data", e);
            }
            Analytics.touch();
        });
    }

    private static File userHome() {
        return new File(System.getProperty("user.home"));
    }

    private static File timerFile() {
        return new File(Analytics.userHome(), ".fabrication-timer");
    }

    private static File userIdFile() {
        return new File(Analytics.userHome(), ".fabrication-user-id");
    }

    private static void touch() {
        File timerFile = Analytics.timerFile();
        last = System.currentTimeMillis() / 1000L;
        timerFile.setLastModified(System.currentTimeMillis());
    }

    private static void ensureUserIdPresent() {
        File timerFile = Analytics.timerFile();
        if (userId == null) {
            File userIdFile = Analytics.userIdFile();
            if (!timerFile.exists()) {
                try {
                    timerFile.createNewFile();
                }
                catch (IOException e) {
                    FabLog.warn("Failed to create timer file", e);
                }
            }
            boolean needGenerate = true;
            if (userIdFile.exists()) {
                try {
                    String uid = Files.toString((File)userIdFile, (Charset)Charsets.UTF_8).trim();
                    if (uid.length() == 16 && CharMatcher.anyOf((CharSequence)"0123456789abcdefABCDEF").matchesAllOf((CharSequence)uid)) {
                        needGenerate = false;
                        userId = uid.trim();
                    }
                }
                catch (IOException e) {
                    FabLog.warn("Failed to load Matomo user id", e);
                }
            }
            if (needGenerate) {
                userId = BaseEncoding.base16().encode(SecureRandom.getSeed(8));
                FabLog.info("Analytics user ID created: " + userId);
                try {
                    Files.write((CharSequence)userId, (File)userIdFile, (Charset)Charsets.UTF_8);
                }
                catch (IOException e) {
                    FabLog.warn("Failed to save Matomo user id", e);
                }
            }
            first = userIdFile.lastModified() / 1000L;
            last = timerFile.lastModified() / 1000L;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void addClientData(Map<String, String> extra) {
        try {
            class_310.method_1551().method_19537(() -> {
                extra.put("OpenGL Version", GL11.glGetString((int)7938));
                class_1041 w = class_310.method_1551().method_22683();
                double ratio = (double)w.method_4480() / (double)w.method_4507();
                String ratioStr = Analytics.isBasically(ratio, 1.0) ? "1:1" : (Analytics.isBasically(ratio, 1.7777777777777777) ? "16:9" : (Analytics.isBasically(ratio, 1.3333333333333333) ? "4:3" : (Analytics.isBasically(ratio, 1.25) ? "5:4" : (Analytics.isBasically(ratio, 2.3333333333333335) ? "21:9" : (Analytics.isBasically(ratio, 2.0) ? "2:1" : (Analytics.isBasically(ratio, 0.5625) ? "9:16" : (Analytics.isBasically(ratio, 0.75) ? "3:4" : (Analytics.isBasically(ratio, 0.8) ? "4:5" : (Analytics.isBasically(ratio, 0.42857142857142855) ? "9:21" : (Analytics.isBasically(ratio, 0.5) ? "1:2" : (ratio < 1.3333333333333333 ? "? (narrower than 4:3)" : (ratio < 1.7777777777777777 ? "? (narrower than 16:9)" : (ratio > 2.3333333333333335 ? "? (wider than 21:9)" : "? (wider than 16:9)")))))))))))));
                extra.put("Aspect Ratio", ratioStr);
                extra.put("Language", class_310.method_1551().method_1526().method_4669().getCode());
            });
        }
        catch (Throwable e) {
            extra.put("OpenGL Version", "<error>");
            extra.put("Aspect Ratio", "<error>");
            extra.put("Language", "<error>");
        }
    }

    private static boolean isBasically(double a, double b) {
        return Math.abs(a - b) < 0.05;
    }

    private static String processExtra(Map<String, String> extra) {
        JsonObject extraJson = new JsonObject();
        int i = 1;
        for (Map.Entry<String, String> en : extra.entrySet()) {
            JsonArray arr = new JsonArray();
            arr.add(en.getKey());
            arr.add(en.getValue());
            extraJson.add(Integer.toString(i), (JsonElement)arr);
            ++i;
        }
        return new Gson().toJson((JsonElement)extraJson);
    }
}

