/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.base.Stopwatch;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import com.unascribed.fabrication.support.SpecialEligibility;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabLog {
    private static final Logger log = LogManager.getLogger((String)"Fabrication");
    private static final boolean PREFIX = MixinConfigPlugin.isMet(SpecialEligibility.NOT_FORGE);
    private static final boolean FAKE_DEBUG = Boolean.getBoolean("fabrication.debug") && MixinConfigPlugin.isMet(SpecialEligibility.NOT_FORGE);
    private static int warningsOld = -1;
    private static int warnings = 0;

    public static void startCountingWarnings() {
        if (warnings != -1) {
            warningsOld = warnings;
        }
        warnings = 0;
    }

    public static int stopCountingWarnings() {
        int w = warnings;
        if (warningsOld != -1) {
            warnings = warningsOld;
            warningsOld = -1;
        } else {
            warnings = -1;
        }
        return w;
    }

    private static String prefix(String message) {
        return PREFIX ? "[Fabrication] " + message : message;
    }

    public static void debug(String message) {
        if (FAKE_DEBUG) {
            FabLog.info(message);
            return;
        }
        log.debug(FabLog.prefix(message));
    }

    public static void debug(String message, Throwable t) {
        if (FAKE_DEBUG) {
            FabLog.info(message, t);
            return;
        }
        log.debug(FabLog.prefix(message), t);
    }

    public static void error(String message) {
        log.error(FabLog.prefix(message));
    }

    public static void error(String message, Throwable t) {
        log.error(FabLog.prefix(message), t);
    }

    public static void fatal(String message) {
        log.fatal(FabLog.prefix(message));
    }

    public static void fatal(String message, Throwable t) {
        log.fatal(FabLog.prefix(message), t);
    }

    public static void info(String message) {
        log.info(FabLog.prefix(message));
    }

    public static void info(String message, Throwable t) {
        log.info(FabLog.prefix(message), t);
    }

    public static void trace(String message) {
        log.trace(FabLog.prefix(message));
    }

    public static void trace(String message, Throwable t) {
        log.trace(FabLog.prefix(message), t);
    }

    public static void warn(String message) {
        if (warnings != -1) {
            ++warnings;
        }
        log.warn(FabLog.prefix(message));
    }

    public static void warn(String message, Throwable t) {
        if (warnings != -1) {
            ++warnings;
        }
        log.warn(FabLog.prefix(message), t);
    }

    public static void timeAndCountWarnings(String prefix, Runnable r) {
        Stopwatch sw = Stopwatch.createStarted();
        FabLog.startCountingWarnings();
        r.run();
        int w = FabLog.stopCountingWarnings();
        FabLog.info(prefix + " done in " + sw + " with " + w + " warning" + (w == 1 ? "" : "s"));
    }
}

