/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.unascribed.fabrication.FabLog;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;

public class FabricationResourcePack
implements class_3262 {
    private final String path;
    private final JsonObject meta;

    public FabricationResourcePack(String path) {
        JsonObject meta;
        this.path = path;
        try {
            meta = (JsonObject)new Gson().fromJson(Resources.toString((URL)this.url("pack.mcmeta"), (Charset)Charsets.UTF_8), JsonObject.class);
        }
        catch (Throwable t) {
            FabLog.warn("Failed to load meta for internal resource pack " + path);
            meta = new JsonObject();
        }
        this.meta = meta;
    }

    @Environment(value=EnvType.CLIENT)
    public InputStream method_14410(String fileName) throws IOException {
        if (fileName.contains("/") || fileName.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        if ("pack.png".equals(fileName)) {
            return this.getClass().getClassLoader().getResourceAsStream("assets/fabrication/icon.png");
        }
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.path + "/" + fileName);
        if (is == null) {
            throw new FileNotFoundException(fileName);
        }
        return is;
    }

    private URL url(class_3264 type, class_2960 id) {
        return this.url(type.method_14413() + "/" + id.method_12836() + "/" + id.method_12832());
    }

    private URL url(String path) {
        return this.getClass().getClassLoader().getResource("packs/" + this.path + "/" + path);
    }

    public InputStream method_14405(class_3264 type, class_2960 id) throws IOException {
        URL u = this.url(type, id);
        if (u == null) {
            throw new FileNotFoundException(id.toString());
        }
        return u.openStream();
    }

    public Collection<class_2960> method_14408(class_3264 type, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        return Collections.emptySet();
    }

    public boolean method_14411(class_3264 type, class_2960 id) {
        return this.url(type, id) != null;
    }

    public Set<String> method_14406(class_3264 type) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.meta.getAsJsonObject("fabrication").getAsJsonArray("namespaces"), JsonElement::getAsString));
    }

    public <T> T method_14407(class_3270<T> metaReader) throws IOException {
        if (!this.meta.has(metaReader.method_14420())) {
            return null;
        }
        return (T)metaReader.method_14421(this.meta.getAsJsonObject(metaReader.method_14420()));
    }

    public String method_14409() {
        return "Fabrication";
    }

    public void close() {
    }
}

