/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.QDIni;
import java.math.BigDecimal;

public class ParsedTime {
    private static final int SECOND_IN_TICKS = 20;
    private static final int MINUTE_IN_TICKS = 1200;
    private static final int HOUR_IN_TICKS = 72000;
    public static final ParsedTime UNSET = new ParsedTime(6000, false);
    public static final ParsedTime FOREVER = new ParsedTime(Integer.MAX_VALUE, false);
    public static final ParsedTime INVINCIBLE = new ParsedTime(Integer.MAX_VALUE, false);
    public static final ParsedTime INSTANTLY = new ParsedTime(0, false);
    public final int timeInTicks;
    public final boolean priority;

    private ParsedTime(int timeInTicks, boolean priority) {
        this.timeInTicks = timeInTicks;
        this.priority = priority;
    }

    public boolean overshadows(ParsedTime that) {
        if (this == that) {
            return false;
        }
        if (this == UNSET) {
            return false;
        }
        if (that == UNSET) {
            return true;
        }
        if (that.priority && !this.priority) {
            return false;
        }
        if (this.priority && !that.priority) {
            return true;
        }
        return this.timeInTicks > that.timeInTicks;
    }

    public String toString() {
        String s = this == UNSET ? "unset" : (this == FOREVER ? "forever" : (this == INVINCIBLE ? "invincible" : (this == INSTANTLY ? "instantly" : (this.timeInTicks % 72000 == 0 ? this.timeInTicks / 72000 + "h" : (this.timeInTicks % 1200 == 0 ? this.timeInTicks / 1200 + "m" : (this.timeInTicks % 20 == 0 ? this.timeInTicks / 20 + "s" : this.timeInTicks + "t"))))));
        return s + (this.priority ? "!" : "");
    }

    public static ParsedTime getFrom(QDIni cfg, String k) {
        String v = cfg.get(k).orElse("");
        try {
            return ParsedTime.parse(v);
        }
        catch (IllegalArgumentException e) {
            FabLog.warn(k + " must be one of unset, forever, f, invincible, invulnerable, i, instantly, or a timespec like 30s (got " + v + ") at " + cfg.getBlame(k));
            return UNSET;
        }
    }

    public static ParsedTime parse(String time) {
        int multiplier;
        Preconditions.checkNotNull((Object)time);
        if (time.isEmpty()) {
            throw new IllegalArgumentException("Timespec cannot be blank");
        }
        boolean priority = false;
        if (time.endsWith("!")) {
            priority = true;
            time = time.substring(0, time.length() - 1);
        }
        switch (time) {
            case "unset": {
                return UNSET;
            }
            case "forever": 
            case "f": {
                return FOREVER;
            }
            case "invincible": 
            case "invulnerable": 
            case "i": {
                return INVINCIBLE;
            }
            case "instantly": 
            case "0": {
                return INSTANTLY;
            }
        }
        char qualifier = time.charAt(time.length() - 1);
        String timeNumPart = time.substring(0, time.length() - 1);
        if (!CharMatcher.digit().matchesAllOf((CharSequence)timeNumPart)) {
            throw new IllegalArgumentException("Bad timespec " + time);
        }
        switch (qualifier) {
            case 't': {
                multiplier = 1;
                break;
            }
            case 's': {
                multiplier = 20;
                break;
            }
            case 'm': {
                multiplier = 1200;
                break;
            }
            case 'h': {
                multiplier = 72000;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown qualifier " + qualifier + " for time value " + time);
            }
        }
        return new ParsedTime(new BigDecimal(timeNumPart).multiply(new BigDecimal(multiplier)).intValueExact(), priority);
    }
}

