/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.base.Objects;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class Resolvable<T> {
    private static final ThreadLocal<Resolvable> MAP_KEY = ThreadLocal.withInitial(() -> new Resolvable(null, null, null));
    private class_2960 id;
    private class_2378<T> registry;
    private Optional<T> resolved;
    private final boolean resolvedImmediately;

    private Resolvable(class_2960 id, class_2378<T> registry, Optional<T> resolved) {
        this.id = id;
        this.registry = registry;
        this.resolved = resolved;
        this.resolvedImmediately = resolved != null && resolved.isPresent();
    }

    public class_2960 getId() {
        return this.id;
    }

    public Optional<T> get() {
        if (this.resolved == null) {
            throw new IllegalStateException("Cannot resolve a mapKey resolvable");
        }
        if (!this.resolved.isPresent()) {
            this.resolved = this.registry.method_17966(this.id);
        }
        return this.resolved;
    }

    public T getOrNull() {
        return this.get().orElse(null);
    }

    public boolean isResolved() {
        if (this.resolved == null) {
            throw new IllegalStateException("Cannot resolve a mapKey resolvable");
        }
        return this.resolved.isPresent();
    }

    public boolean wasResolvedImmediately() {
        if (this.resolved == null) {
            throw new IllegalStateException("Cannot resolve a mapKey resolvable");
        }
        return this.resolvedImmediately;
    }

    public static <T> Resolvable<T> of(class_2960 id, class_2378<T> registry) {
        return new Resolvable<T>(id, registry, registry.method_17966(id));
    }

    public static <T> Resolvable<T> mapKey(T obj, class_2378<T> registry) {
        return Resolvable.mapKey(registry.method_10221(obj), registry);
    }

    public static <T> Resolvable<T> mapKey(class_2960 id, class_2378<T> registry) {
        Resolvable r = MAP_KEY.get();
        r.id = id;
        r.registry = registry;
        return r;
    }

    public String toString() {
        if (this.resolved == null) {
            return "Resolvable(MapKey){id=" + this.id + "}";
        }
        return "Resolvable{id=" + this.id + ",resolved=" + this.isResolved() + ",resolvedImmediately=" + this.resolvedImmediately + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.registry == null ? 0 : this.registry.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resolvable other = (Resolvable)obj;
        if (!Objects.equal((Object)this.id, (Object)other.id)) {
            return false;
        }
        return this.registry == other.registry;
    }
}

