/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.collect.Sets;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.FabricationResourcePack;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.Feature;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3272;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;

public abstract class ResourcePackFeature
implements Feature,
class_3285 {
    private final String configKey;
    private final String path;
    private boolean active = false;
    @Environment(value=EnvType.CLIENT)
    private class_3262 pack;

    public ResourcePackFeature(String path) {
        this.configKey = "*." + path;
        this.path = path;
        if (Agnos.getCurrentEnv() == Env.CLIENT) {
            this.initClient();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void initClient() {
        HashSet providers = FabRefl.getProviders(class_310.method_1551().method_1520());
        try {
            providers.add((class_3285)this);
        }
        catch (UnsupportedOperationException e) {
            FabLog.info("Injecting mutable resource pack provider set, as no-one else has yet.");
            providers = Sets.newHashSet(providers);
            FabRefl.setProviders(class_310.method_1551().method_1520(), providers);
        }
    }

    public void method_14453(Consumer<class_3288> consumer, class_3288.class_5351 factory) {
        if (this.active) {
            Supplier<class_3262> f = () -> new FabricationResourcePack(this.path);
            consumer.accept(factory.create("Fabrication " + this.path, true, f, f.get(), new class_3272((class_2561)new class_2585("Internal Fabrication resources"), 6), class_3288.class_3289.field_14280, class_5352.field_25348));
        }
    }

    @Override
    public void apply() {
        this.active = true;
        if (Agnos.getCurrentEnv() == Env.CLIENT) {
            this.reloadClient();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void reloadClient() {
        if (class_310.method_1551().method_1478() != null) {
            class_310.method_1551().method_1521();
        }
    }

    @Override
    public boolean undo() {
        this.active = false;
        if (Agnos.getCurrentEnv() == Env.CLIENT) {
            this.reloadClient();
        }
        return true;
    }

    @Override
    public String getConfigKey() {
        return this.configKey;
    }
}

