/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.collect.Maps;
import java.util.TreeMap;

public class RomanNumeral {
    private static final TreeMap<Integer, String> map = Maps.newTreeMap();

    public static String format(int n) {
        if (n == 0) {
            return "N";
        }
        if (n > 1000000) {
            return "\u221e";
        }
        if (n > 10000) {
            return Integer.toString(n);
        }
        StringBuilder sb = new StringBuilder();
        while (n > 0) {
            int i = map.floorKey(n);
            sb.append(map.get(i));
            n -= i;
        }
        return sb.toString();
    }

    static {
        map.put(1000, "M");
        map.put(900, "CM");
        map.put(500, "D");
        map.put(400, "CD");
        map.put(100, "C");
        map.put(90, "XC");
        map.put(50, "L");
        map.put(40, "XL");
        map.put(10, "X");
        map.put(9, "IX");
        map.put(5, "V");
        map.put(4, "IV");
        map.put(1, "I");
    }
}

