/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.client;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.CommandDispatcher;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.FeaturesFile;
import com.unascribed.fabrication.interfaces.GetServerConfig;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import com.unascribed.fabrication.support.ResolvedTrilean;
import com.unascribed.fabrication.support.Trilean;
import io.github.queerbric.pride.PrideFlag;
import io.github.queerbric.pride.PrideFlags;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_634;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;

public class FabricationConfigScreen
extends class_437 {
    private final Map<String, String> SECTION_DESCRIPTIONS = Maps.newHashMap();
    private final Map<MixinConfigPlugin.Profile, String> PROFILE_DESCRIPTIONS = Maps.newHashMap();
    private static final ImmutableMap<MixinConfigPlugin.Profile, Integer> PROFILE_COLORS = ImmutableMap.builder().put((Object)MixinConfigPlugin.Profile.GREEN, (Object)-7617718).put((Object)MixinConfigPlugin.Profile.BLONDE, (Object)-13184).put((Object)MixinConfigPlugin.Profile.LIGHT, (Object)-6190977).put((Object)MixinConfigPlugin.Profile.MEDIUM, (Object)-9614271).put((Object)MixinConfigPlugin.Profile.DARK, (Object)-11652050).put((Object)MixinConfigPlugin.Profile.VIENNA, (Object)-13952232).put((Object)MixinConfigPlugin.Profile.BURNT, (Object)-15591397).build();
    private static final class_2960 BG = new class_2960("fabrication", "bg.png");
    private static long serverLaunchId = -1L;
    private static final Set<String> newlyFalseKeysClient = Sets.newHashSet();
    private static final Set<String> newlyFalseKeysServer = Sets.newHashSet();
    private static final Set<String> newlyNotFalseKeysClient = Sets.newHashSet();
    private static final Set<String> newlyNotFalseKeysServer = Sets.newHashSet();
    private static final Map<String, String> changedKeysWithoutRuntimeChecksClient = Maps.newHashMap();
    private static final Map<String, String> changedKeysWithoutRuntimeChecksServer = Maps.newHashMap();
    private static boolean runtimeChecksToggledClient;
    private static boolean runtimeChecksToggledServer;
    private final int random = ThreadLocalRandom.current().nextInt();
    private final class_437 parent;
    private final PrideFlag prideFlag;
    private float timeExisted;
    private boolean leaving = false;
    private float timeLeaving;
    private float sidebarScrollTarget;
    private float sidebarScroll;
    private float lastSidebarScroll;
    private float sidebarHeight;
    private boolean didClick;
    private float selectTime;
    private String selectedSection;
    private String prevSelectedSection;
    private float selectedSectionHeight;
    private float prevSelectedSectionHeight;
    private float selectedSectionScroll;
    private float prevSelectedSectionScroll;
    private float lastSelectedSectionScroll;
    private float lastPrevSelectedSectionScroll;
    private float selectedSectionScrollTarget;
    private float prevSelectedSectionScrollTarget;
    private int tooltipBlinkTicks = 0;
    private boolean configuringServer;
    private boolean hasClonked = true;
    private boolean isSingleplayer;
    private float serverAnimateTime;
    private String whyCantConfigureServer = null;
    private Set<String> serverKnownConfigKeys = Sets.newHashSet();
    private boolean serverReadOnly;
    private final Map<String, Trilean> optionPreviousValues = Maps.newHashMap();
    private final Map<String, Float> optionAnimationTime = Maps.newHashMap();
    private final Map<String, Float> disabledAnimationTime = Maps.newHashMap();
    private final Map<String, Float> disappearAnimationTime = Maps.newHashMap();
    private final Set<String> knownDisabled = Sets.newHashSet();
    private final Set<String> disappeared = Sets.newHashSet();
    private boolean bufferTooltips = false;
    private final List<Runnable> bufferedTooltips = Lists.newArrayList();
    private int noteIndex = 0;

    public FabricationConfigScreen(class_437 parent) {
        super((class_2561)new class_2585("Fabrication configuration"));
        this.parent = parent;
        this.prideFlag = PrideFlags.isPrideMonth() ? PrideFlags.getRandomFlag() : null;
        for (String sec : MixinConfigPlugin.getAllSections()) {
            this.SECTION_DESCRIPTIONS.put(sec, FeaturesFile.get((String)sec).desc);
        }
        for (MixinConfigPlugin.Profile prof : MixinConfigPlugin.Profile.values()) {
            this.PROFILE_DESCRIPTIONS.put(prof, FeaturesFile.get((String)new StringBuilder().append((String)"general.profile.").append((String)prof.name().toLowerCase((Locale)Locale.ROOT)).toString()).desc);
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.isSingleplayer = false;
        if (this.field_22787.field_1687 == null) {
            this.whyCantConfigureServer = "You're not connected to a server.";
        } else if (this.field_22787.method_1576() != null) {
            this.whyCantConfigureServer = "The singleplayer server shares the client settings.";
            this.isSingleplayer = true;
        } else {
            CommandDispatcher disp = this.field_22787.field_1724.field_3944.method_2886();
            if (disp.getRoot().getChild("fabrication") == null) {
                this.whyCantConfigureServer = "This server doesn't have Fabrication.";
            } else {
                class_634 cpnh = this.field_22787.method_1562();
                if (cpnh instanceof GetServerConfig) {
                    GetServerConfig gsc = (GetServerConfig)cpnh;
                    if (!gsc.fabrication$hasHandshook()) {
                        this.whyCantConfigureServer = "This server's version of Fabrication is too old.";
                    } else {
                        this.serverReadOnly = disp.getRoot().getChild("fabrication").getChild("config") == null;
                        this.serverKnownConfigKeys.clear();
                        this.serverKnownConfigKeys.addAll(gsc.fabrication$getServerTrileanConfig().keySet());
                        this.serverKnownConfigKeys.addAll(gsc.fabrication$getServerStringConfig().keySet());
                    }
                } else {
                    this.whyCantConfigureServer = "An internal error prevented initialization of the syncer.";
                }
            }
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.timeExisted == 0.0f && !MixinConfigPlugin.isEnabled("*.reduced_motion")) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14588, (float)2.0f, (float)0.1f));
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17604, (float)1.2f));
        }
        this.timeExisted += delta;
        if (this.leaving) {
            this.timeLeaving += delta;
        }
        if (this.parent != null && (this.leaving || this.timeExisted < 10.0f) && !MixinConfigPlugin.isEnabled("*.reduced_motion")) {
            float a = FabricationConfigScreen.sCurve5((this.leaving ? Math.max(0.0f, 10.0f - this.timeLeaving) : this.timeExisted) / 10.0f);
            class_4493.method_21926();
            class_4493.method_21999((float)((float)this.field_22789 / 2.0f), (float)this.field_22790, (float)0.0f);
            class_4493.method_21981((float)(a * (float)(this.leaving ? -180 : 180)), (float)0.0f, (float)0.0f, (float)1.0f);
            class_4493.method_21999((float)(-this.field_22789 / 2), (float)(-this.field_22790), (float)0.0f);
            class_4493.method_21926();
            class_4493.method_21999((float)0.0f, (float)this.field_22790, (float)0.0f);
            class_4493.method_21999((float)((float)this.field_22789 / 2.0f), (float)((float)this.field_22790 / 2.0f), (float)0.0f);
            class_4493.method_21981((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            class_4493.method_21999((float)((float)(-this.field_22789) / 2.0f), (float)((float)(-this.field_22790) / 2.0f), (float)0.0f);
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)(-this.field_22789), (int)(-this.field_22790), (int)(this.field_22789 * 2), (int)0, (int)-14575885);
            class_4493.method_21926();
            this.drawBackground(matrices, -200, -200, delta, 0, 0);
            this.drawForeground(matrices, -200, -200, delta);
            class_4493.method_21928();
            class_4493.method_21928();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 0; ++y) {
                    if (x == 0 && y == 0) continue;
                    class_4493.method_21926();
                    class_4493.method_21999((float)(this.field_22789 * x), (float)(this.field_22790 * y), (float)0.0f);
                    this.parent.method_25434(0);
                    class_4493.method_21928();
                }
            }
            this.parent.method_25394(matrices, -200, -200, delta);
            class_4493.method_21928();
        } else {
            class_4493.method_21926();
            this.drawBackground(matrices, mouseX, mouseY, delta, 0, 0);
            this.drawForeground(matrices, mouseX, mouseY, delta);
            class_4493.method_21928();
        }
        if (this.leaving && this.timeLeaving > 10.0f) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private void drawBackground(class_4587 matrices, int mouseX, int mouseY, float delta, int cutoffX, int cutoffY) {
        float cutoffV = (float)cutoffY / (float)this.field_22790;
        this.method_25296(matrices, cutoffX == 0 ? -this.field_22789 : cutoffX, cutoffY, this.field_22789 * 2, this.field_22790, this.lerpColor(-14575885, -16738680, cutoffV), -16738680);
        float ratio = 0.4648148f;
        float w = (float)this.field_22790 * ratio;
        float brk = Math.min((float)this.field_22789 - w, (float)(this.field_22789 * 2) / 3.0f - w / 3.0f);
        float brk2 = brk + w;
        float border = (float)(20.0 / this.field_22787.method_22683().method_4495());
        if (brk < (float)cutoffX) {
            brk = cutoffX;
        }
        class_1159 mat = matrices.method_23760().method_23761();
        class_4493.method_22056();
        RenderSystem.defaultBlendFunc();
        float time = this.selectedSection == null ? 10.0f - this.selectTime : (this.prevSelectedSection == null ? this.selectTime : 0.0f);
        class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4493.method_22078();
        class_287 bb = class_289.method_1348().method_1349();
        float top = 0.5277778f * (float)this.field_22790;
        float bottom = 0.8342593f * (float)this.field_22790;
        if ((float)cutoffY < bottom) {
            float h = bottom - top;
            float flagCutoffV = 0.0f;
            if (top < (float)cutoffY) {
                top = cutoffY;
                flagCutoffV = 1.0f - (bottom - top) / h;
            }
            if (this.prideFlag != null) {
                this.prideFlag.render(matrices, brk, top, w, bottom - top);
            } else {
                class_4493.method_22083((int)7425);
                class_4493.method_21912();
                bb.method_1328(7, class_290.field_1576);
                float r = class_3532.method_16439((float)flagCutoffV, (float)0.298f, (float)0.475f);
                float g = class_3532.method_16439((float)flagCutoffV, (float)0.686f, (float)0.333f);
                float b = class_3532.method_16439((float)flagCutoffV, (float)0.314f, (float)0.282f);
                bb.method_22918(mat, brk, top, 0.0f).method_22915(r, g, b, 1.0f).method_1344();
                bb.method_22918(mat, brk2, top, 0.0f).method_22915(r, g, b, 1.0f).method_1344();
                bb.method_22918(mat, brk2, bottom, 0.0f).method_22915(0.475f, 0.333f, 0.282f, 1.0f).method_1344();
                bb.method_22918(mat, brk, bottom, 0.0f).method_22915(0.475f, 0.333f, 0.282f, 1.0f).method_1344();
                bb.method_1326();
                class_286.method_1309((class_287)bb);
                class_4493.method_21910();
                class_4493.method_22083((int)7424);
            }
        }
        this.field_22787.method_1531().method_22813(BG);
        class_4493.method_21986((int)3553, (int)10240, (int)9729);
        class_4493.method_21986((int)3553, (int)10241, (int)9729);
        bb.method_1328(7, class_290.field_1585);
        bb.method_22918(mat, Math.max((float)cutoffX, border), (float)cutoffY, 0.0f).method_22913(0.0f, cutoffV).method_1344();
        bb.method_22918(mat, brk, (float)cutoffY, 0.0f).method_22913(0.0f, cutoffV).method_1344();
        bb.method_22918(mat, brk, (float)this.field_22790, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        bb.method_22918(mat, Math.max((float)cutoffX, border), (float)this.field_22790, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        bb.method_22918(mat, brk, (float)cutoffY, 0.0f).method_22913(0.0f, cutoffV).method_1344();
        bb.method_22918(mat, brk2, (float)cutoffY, 0.0f).method_22913(1.0f, cutoffV).method_1344();
        bb.method_22918(mat, brk2, (float)this.field_22790, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        bb.method_22918(mat, brk, (float)this.field_22790, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        bb.method_22918(mat, brk2, (float)cutoffY, 0.0f).method_22913(1.0f, cutoffV).method_1344();
        bb.method_22918(mat, (float)this.field_22789 - border, (float)cutoffY, 0.0f).method_22913(1.0f, cutoffV).method_1344();
        bb.method_22918(mat, (float)this.field_22789 - border, (float)this.field_22790, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        bb.method_22918(mat, brk2, (float)this.field_22790, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        bb.method_1326();
        class_286.method_1309((class_287)bb);
        float a = 1.0f - (0.3f + FabricationConfigScreen.sCurve5(time / 10.0f) * 0.7f);
        if (a > 0.0f) {
            int ai = (int)(a * 255.0f) << 24;
            this.method_25296(matrices, cutoffX == 0 ? -this.field_22789 : cutoffX, cutoffY, this.field_22789 * 2, this.field_22790, this.lerpColor(2201331, 38536, cutoffV) | ai, 0x9688 | ai);
        }
    }

    private int lerpColor(int from, int to, float delta) {
        float a = class_3532.method_16439((float)delta, (float)((float)(from >> 24 & 0xFF) / 255.0f), (float)((float)(to >> 24 & 0xFF) / 255.0f));
        float r = class_3532.method_16439((float)delta, (float)((float)(from >> 16 & 0xFF) / 255.0f), (float)((float)(to >> 16 & 0xFF) / 255.0f));
        float g = class_3532.method_16439((float)delta, (float)((float)(from >> 8 & 0xFF) / 255.0f), (float)((float)(to >> 8 & 0xFF) / 255.0f));
        float b = class_3532.method_16439((float)delta, (float)((float)(from >> 0 & 0xFF) / 255.0f), (float)((float)(to >> 0 & 0xFF) / 255.0f));
        int c = 0;
        c |= ((int)(a * 255.0f) & 0xFF) << 24;
        c |= ((int)(r * 255.0f) & 0xFF) << 16;
        c |= ((int)(g * 255.0f) & 0xFF) << 8;
        return c |= ((int)(b * 255.0f) & 0xFF) << 0;
    }

    private void drawForeground(class_4587 matrices, int mouseX, int mouseY, float delta) {
        boolean runtimeChecksToggled;
        Map<String, String> changedKeysWithoutRuntimeChecks;
        Set<String> newlyNotFalseKeys;
        Set<String> newlyFalseKeys;
        float a;
        if (this.serverAnimateTime > 0.0f) {
            this.serverAnimateTime -= delta;
        }
        if (this.serverAnimateTime < 0.0f) {
            this.serverAnimateTime = 0.0f;
        }
        if (this.selectTime > 0.0f) {
            this.selectTime -= delta;
        }
        if (this.selectTime < 0.0f) {
            this.selectTime = 0.0f;
        }
        if ((double)(a = FabricationConfigScreen.sCurve5(this.serverAnimateTime / 10.0f)) <= 0.05 && !this.hasClonked) {
            this.hasClonked = true;
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_21876, (float)1.0f, (float)0.5f));
        }
        if (this.configuringServer) {
            a = 1.0f - a;
        }
        FabricationConfigScreen.method_25294((class_4587)matrices, (int)(-this.field_22789), (int)(-this.field_22790), (int)130, (int)this.field_22790, (int)0x44000000);
        Multimap options = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), Lists::newArrayList);
        for (String key : MixinConfigPlugin.getAllKeys()) {
            int dot = key.indexOf(46);
            String section = key.substring(0, dot);
            String name = key.substring(dot + 1);
            options.put((Object)section, (Object)name);
        }
        float scroll = this.sidebarHeight < (float)this.field_22790 ? 0.0f : this.lastSidebarScroll + (this.sidebarScroll - this.lastSidebarScroll) * this.field_22787.method_1488();
        scroll = (float)(Math.floor((double)scroll * this.field_22787.method_22683().method_4495()) / this.field_22787.method_22683().method_4495());
        float y = 8.0f - scroll;
        int newHeight = 8;
        int i = 0;
        float selectedChoiceY = -60.0f;
        float prevSelectedChoiceY = -60.0f;
        for (String s2 : options.keySet()) {
            float selectA;
            if (s2.equals(this.selectedSection)) {
                selectA = FabricationConfigScreen.sCurve5((10.0f - this.selectTime) / 10.0f);
                selectedChoiceY = y;
            } else if (s2.equals(this.prevSelectedSection)) {
                selectA = FabricationConfigScreen.sCurve5(this.selectTime / 10.0f);
                prevSelectedChoiceY = y;
            } else {
                selectA = 0.0f;
            }
            if (selectA > 0.0f) {
                class_4493.method_22078();
                class_4493.method_22056();
                RenderSystem.defaultBlendFunc();
                class_4493.method_21912();
                class_4493.method_22012();
                class_4493.method_22083((int)7425);
                GL11.glBegin((int)7);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                GL11.glVertex2f((float)0.0f, (float)(y - 4.0f));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.2f + (1.0f - selectA) * 0.8f));
                GL11.glVertex2f((float)(130.0f * selectA), (float)(y - 4.0f));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.2f + (1.0f - selectA) * 0.8f));
                GL11.glVertex2f((float)(130.0f * selectA), (float)(y + 36.0f));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                GL11.glVertex2f((float)0.0f, (float)(y + 36.0f));
                GL11.glEnd();
                class_4493.method_22083((int)7424);
                class_4493.method_21910();
            }
            float startY = y;
            if (y >= -24.0f && y < (float)this.field_22790) {
                class_4493.method_22056();
                RenderSystem.defaultBlendFunc();
                this.field_22787.method_1531().method_22813(new class_2960("fabrication", "category/" + s2 + ".png"));
                class_4493.method_21986((int)3553, (int)10240, (int)9729);
                class_4493.method_21986((int)3553, (int)10241, (int)9729);
                class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                class_4493.method_21926();
                class_4493.method_21999((float)0.0f, (float)y, (float)0.0f);
                FabricationConfigScreen.method_25291((class_4587)matrices, (int)104, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)24, (int)Math.min(24, (int)Math.ceil((float)this.field_22790 - y)), (int)24, (int)24);
                class_4493.method_21928();
            }
            if (y >= -12.0f && y < (float)this.field_22790) {
                this.field_22793.method_1729(matrices, "\u00a7l" + FeaturesFile.get((String)s2).shortName, 4.0f, y, -1);
            }
            String desc = this.SECTION_DESCRIPTIONS.getOrDefault(s2, "No description available");
            y += 12.0f;
            newHeight += 12;
            int x = 8;
            boolean line = false;
            for (String word : Splitter.on((CharMatcher)CharMatcher.whitespace()).split((CharSequence)desc)) {
                int w = this.field_22793.method_1727(word);
                if (x + w > 100 && !line) {
                    x = 8;
                    y += 12.0f;
                    newHeight += 12;
                    line = true;
                }
                x = this.field_22793.method_1729(matrices, word + " ", (float)x, y, -1);
            }
            y += 12.0f;
            newHeight += 12;
            if (this.didClick && mouseX >= 0 && mouseX <= 130 && (float)mouseY > startY - 4.0f && (float)mouseY < y) {
                boolean deselect = s2.equals(this.selectedSection);
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14793, (float)(deselect ? 0.5f : 0.6f + (float)i * 0.1f), (float)1.0f));
                this.prevSelectedSection = this.selectedSection;
                this.selectedSection = deselect ? null : s2;
                this.prevSelectedSectionScroll = this.selectedSectionScroll;
                this.lastPrevSelectedSectionScroll = this.lastSelectedSectionScroll;
                this.prevSelectedSectionHeight = this.selectedSectionHeight;
                this.prevSelectedSectionScrollTarget = this.selectedSectionScrollTarget;
                this.selectedSectionScroll = 0.0f;
                this.lastSelectedSectionScroll = 0.0f;
                this.selectedSectionHeight = 0.0f;
                this.selectedSectionScrollTarget = 0.0f;
                this.selectTime = 10.0f - this.selectTime;
            }
            y += 8.0f;
            newHeight += 8;
            ++i;
        }
        this.sidebarHeight = newHeight;
        if (this.sidebarHeight >= (float)this.field_22790) {
            float knobHeight = (float)this.field_22790 / this.sidebarHeight * (float)this.field_22790;
            float knobY = scroll / (this.sidebarHeight - (float)this.field_22790) * ((float)this.field_22790 - knobHeight);
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)128, (int)((int)knobY), (int)130, (int)((int)(knobY + knobHeight)), (int)-1426063361);
        }
        this.bufferTooltips = true;
        this.drawSection(matrices, this.selectedSection, mouseX, mouseY, selectedChoiceY, FabricationConfigScreen.sCurve5((10.0f - this.selectTime) / 10.0f), true);
        if (!MixinConfigPlugin.isEnabled("general.reduced_motion") && !Objects.equal((Object)this.selectedSection, (Object)this.prevSelectedSection)) {
            this.drawSection(matrices, this.prevSelectedSection, -200.0f, -200.0f, prevSelectedChoiceY, FabricationConfigScreen.sCurve5(this.selectTime / 10.0f), false);
        }
        class_4493.method_21926();
        class_4493.method_22047();
        FabricationConfigScreen.method_25294((class_4587)matrices, (int)(this.field_22789 - 120), (int)0, (int)(this.field_22789 * 2), (int)16, (int)0x33000000);
        class_4493.method_21926();
        class_4493.method_21999((float)(this.field_22789 - 60), (float)8.0f, (float)0.0f);
        class_4493.method_21926();
        class_4493.method_21981((float)(a * -180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        float h = (40.0f + a * -100.0f) / 360.0f;
        if (h < 0.0f) {
            h = 1.0f + h;
        }
        class_4493.method_21926();
        class_4493.method_21980((float)((float)(1.0 - Math.abs(Math.sin((double)a * Math.PI)) / 2.0)), (float)1.0f, (float)1.0f);
        FabricationConfigScreen.method_25294((class_4587)matrices, (int)-60, (int)-8, (int)0, (int)8, (int)(class_3532.method_15369((float)h, (float)0.9f, (float)0.9f) | 0xFF000000));
        if (this.isSingleplayer) {
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)0, (int)-8, (int)60, (int)8, (int)(class_3532.method_15369((float)0.833333f, (float)0.9f, (float)0.9f) | 0xFF000000));
        }
        class_4493.method_21928();
        class_4493.method_21926();
        class_4493.method_21981((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = 5.656854f;
        class_4493.method_21980((float)f, (float)f, (float)1.0f);
        FabricationConfigScreen.method_25294((class_4587)matrices, (int)-1, (int)-1, (int)1, (int)1, (int)-1);
        class_4493.method_21928();
        if (!this.isSingleplayer) {
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)-6, (int)-1, (int)-2, (int)1, (int)-16777216);
        }
        class_4493.method_21928();
        FabricationConfigScreen.method_25294((class_4587)matrices, (int)-2, (int)-2, (int)2, (int)2, (int)-16777216);
        class_4493.method_21928();
        this.field_22793.method_1729(matrices, "CLIENT", (float)(this.field_22789 - 115), 4.0f, -16777216);
        this.field_22793.method_1729(matrices, "SERVER", (float)(this.field_22789 - 40), 4.0f, this.whyCantConfigureServer == null || this.isSingleplayer ? -16777216 : 0x44000000);
        if (this.serverReadOnly && this.whyCantConfigureServer == null) {
            this.field_22787.method_1531().method_22813(new class_2960("fabrication", "lock.png"));
            class_4493.method_22000((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            FabricationConfigScreen.method_25291((class_4587)matrices, (int)(this.field_22789 - 49), (int)3, (int)0, (float)0.0f, (float)0.0f, (int)8, (int)8, (int)8, (int)8);
        }
        this.drawBackground(matrices, mouseX, mouseY, delta, 130, this.field_22790 - 20);
        ArrayList notes = Lists.newArrayList();
        boolean hasYellowNote = false;
        boolean hasRedNote = false;
        if (this.configuringServer) {
            this.checkServerData();
            newlyFalseKeys = newlyFalseKeysServer;
            newlyNotFalseKeys = newlyNotFalseKeysServer;
            changedKeysWithoutRuntimeChecks = changedKeysWithoutRuntimeChecksServer;
            runtimeChecksToggled = runtimeChecksToggledServer;
        } else {
            newlyFalseKeys = newlyFalseKeysClient;
            newlyNotFalseKeys = newlyNotFalseKeysClient;
            changedKeysWithoutRuntimeChecks = changedKeysWithoutRuntimeChecksClient;
            runtimeChecksToggled = runtimeChecksToggledClient;
        }
        if (!changedKeysWithoutRuntimeChecks.isEmpty()) {
            notes.add("\u00a7c" + changedKeysWithoutRuntimeChecks.size() + " change" + (changedKeysWithoutRuntimeChecks.size() == 1 ? "" : "s") + " made while Runtime Checks\n\u00a7cis disabled will not be applied until\n\u00a7cthe {} is restarted.");
            hasRedNote = true;
        }
        if (!newlyNotFalseKeys.isEmpty()) {
            notes.add("\u00a7c" + newlyNotFalseKeys.size() + " newly undisabled option" + (newlyNotFalseKeys.size() == 1 ? "" : "s") + " will\n\u00a7cnot activate until the {} is\n\u00a7crestarted.");
            hasRedNote = true;
        }
        if (runtimeChecksToggled) {
            notes.add("\u00a7eThe {} must be restarted for\n\u00a7echanges to Runtime Checks to apply.");
            hasYellowNote = true;
        }
        if (!newlyFalseKeys.isEmpty() && this.isEnabled("general.runtime_checks") && !runtimeChecksToggled) {
            notes.add(newlyFalseKeys.size() + " newly disabled option" + (newlyFalseKeys.size() == 1 ? "" : "s") + " will be\nentirely unloaded when the {} is\nrestarted.");
        }
        if (this.noteIndex < 0) {
            this.noteIndex = 0;
        }
        if (this.noteIndex >= notes.size()) {
            this.noteIndex = 0;
        }
        int textHeight = this.drawWrappedText(matrices, 136.0f, this.field_22790, (hasRedNote ? "\u00a7c\u26a0 " : (hasYellowNote ? "\u00a7e" : "")) + notes.size() + " note" + (notes.size() == 1 ? "" : "s") + (notes.isEmpty() ? " \u263a" : " - hover to see " + (notes.size() == 1 ? "it" : "them")), this.field_22789 - 250, -1, true);
        if (mouseX >= 136 && mouseX <= this.field_22789 - 100 && mouseY >= this.field_22790 - textHeight && !notes.isEmpty()) {
            ArrayList lines = Lists.newArrayList();
            for (String s3 : ((String)notes.get(this.noteIndex)).replace("{}", this.configuringServer ? "server" : "client").split("\n")) {
                lines.add(new class_2585(s3));
            }
            if (notes.size() > 1) {
                lines.add(new class_2585("\u00a77Click to see other notes"));
            }
            this.method_30901(matrices, lines, mouseX, mouseY);
            if (this.didClick && notes.size() > 1) {
                ++this.noteIndex;
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14920, (float)1.0f));
            }
        }
        if (this.drawButton(matrices, this.field_22789 - 100, this.field_22790 - 20, 100, 20, "Done", mouseX, mouseY)) {
            this.method_25419();
        }
        if (this.didClick) {
            this.didClick = false;
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.bufferTooltips = false;
        for (Runnable r : this.bufferedTooltips) {
            r.run();
        }
        this.bufferedTooltips.clear();
        if (mouseX > this.field_22789 - 120 && mouseY < 16) {
            String msg;
            if (this.whyCantConfigureServer != null) {
                msg = (this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "\u00a7e") + this.whyCantConfigureServer;
            } else {
                int srv = this.serverKnownConfigKeys.size();
                int cli = MixinConfigPlugin.getAllKeys().size();
                msg = "\u00a7dServer has Fabrication and is recognized.";
                if (srv != cli) {
                    msg = msg + "\n\u00a7oMismatch: Server has " + srv + " options. Client has " + cli + ".";
                    if (srv > cli) {
                        msg = msg + "\n\u00a7cOptions unknown to the client will not appear.";
                    } else if (cli > srv) {
                        msg = msg + "\n\u00a7eOptions unknown to the server will be disabled.";
                    }
                }
            }
            if (this.serverReadOnly) {
                msg = msg + "\n\u00a7fYou cannot configure this server.";
                if (this.configuringServer) {
                    msg = msg + "\n\u00a7fChanges cannot be made.";
                }
            }
            if (!(this.isSingleplayer || this.serverReadOnly && this.configuringServer)) {
                msg = msg + "\n\u00a7fChanges will apply to the " + (this.configuringServer ? "\u00a7dSERVER" : "\u00a76CLIENT") + "\u00a7f.";
            }
            this.method_30901(matrices, Lists.transform((List)Lists.newArrayList((Object[])msg.split("\n")), s -> new class_2585(s)), mouseX + 10, 20 + mouseY);
        }
        class_4493.method_21928();
    }

    private void checkServerData() {
        long launchId;
        class_634 cpnh = this.field_22787.method_1562();
        if (cpnh != null && cpnh instanceof GetServerConfig && (launchId = ((GetServerConfig)cpnh).fabrication$getLaunchId()) != serverLaunchId) {
            newlyFalseKeysServer.clear();
            newlyNotFalseKeysServer.clear();
            changedKeysWithoutRuntimeChecksServer.clear();
            runtimeChecksToggledServer = false;
            serverLaunchId = launchId;
        }
    }

    private int drawWrappedText(class_4587 matrices, float x, float y, String str, int width, int color, boolean fromBottom) {
        int height = 0;
        List lines = this.field_22793.method_1728((class_5348)new class_2585(str), width);
        if (fromBottom) {
            y -= 12.0f;
            lines = Lists.reverse((List)lines);
        }
        for (class_5481 ot : lines) {
            this.field_22793.method_27528(matrices, ot, x, y, color);
            y += (float)(fromBottom ? -12 : 12);
            height += 12;
        }
        return height;
    }

    private void drawSection(class_4587 matrices, String section, float mouseX, float mouseY, float choiceY, float a, boolean selected) {
        int startY;
        if (a <= 0.0f) {
            return;
        }
        if (MixinConfigPlugin.isEnabled("general.reduced_motion")) {
            a = 1.0f;
        }
        class_4493.method_21926();
        class_4493.method_21999((float)60.0f, (float)(choiceY + 16.0f), (float)0.0f);
        class_4493.method_21980((float)a, (float)a, (float)1.0f);
        class_4493.method_21999((float)-60.0f, (float)(-(choiceY + 16.0f)), (float)0.0f);
        float lastScrollOfs = selected ? this.lastSelectedSectionScroll : this.lastPrevSelectedSectionScroll;
        float scrollOfs = selected ? this.selectedSectionScroll : this.prevSelectedSectionScroll;
        float scroll = (selected ? this.selectedSectionHeight : this.prevSelectedSectionHeight) < (float)(this.field_22790 - 36) ? 0.0f : lastScrollOfs + (scrollOfs - lastScrollOfs) * this.field_22787.method_1488();
        int y = startY = 16 - (int)scroll;
        if (section == null) {
            String v = this.getVersion();
            String blurb = "\u00a7lFabrication v" + v + " \u00a7rby unascribed\n" + (this.configuringServer ? "(Local version: v" + Agnos.getModVersion() + ")" : "") + "\nClick a category on the left to change settings.";
            int height = this.drawWrappedText(matrices, 140.0f, 20.0f, blurb, this.field_22789 - 130, -1, false);
            if (this.drawButton(matrices, 140, 20 + height + 32, 120, 20, "Reload files", mouseX, mouseY)) {
                MixinConfigPlugin.reload();
            }
            y += height;
            y += 22;
        } else {
            class_4493.method_22056();
            RenderSystem.defaultBlendFunc();
            this.field_22787.method_1531().method_22813(new class_2960("fabrication", "category/" + section + ".png"));
            class_4493.method_21986((int)3553, (int)10240, (int)9729);
            class_4493.method_21986((int)3553, (int)10241, (int)9729);
            class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
            class_4493.method_21926();
            class_4493.method_21999((float)(130.0f + (float)(this.field_22789 - 130) / 2.0f), (float)((float)this.field_22790 / 2.0f), (float)0.0f);
            class_4493.method_22021();
            GL11.glDisable((int)3008);
            FabricationConfigScreen.method_25291((class_4587)matrices, (int)-80, (int)-80, (int)0, (float)0.0f, (float)0.0f, (int)160, (int)160, (int)160, (int)160);
            class_4493.method_22012();
            class_4493.method_21928();
            if ("general".equals(section)) {
                class_4493.method_22056();
                RenderSystem.defaultBlendFunc();
                this.field_22787.method_1531().method_22813(new class_2960("fabrication", "coffee_bean.png"));
                class_4493.method_21986((int)3553, (int)10240, (int)9729);
                class_4493.method_21986((int)3553, (int)10241, (int)9729);
                int x = 0;
                Enum hovered = null;
                for (MixinConfigPlugin.Profile p : MixinConfigPlugin.Profile.values()) {
                    boolean profSel = this.getRawValue("general.profile").toUpperCase(Locale.ROOT).equals(p.name());
                    if (mouseX >= (float)(134 + x) && mouseX <= (float)(134 + x + 16) && mouseY >= 18.0f && mouseY <= 34.0f) {
                        hovered = p;
                    }
                    if (this.didClick && mouseX >= (float)(134 + x) && mouseX <= (float)(134 + x + 16) && mouseY >= 18.0f && mouseY <= 34.0f) {
                        if (p == MixinConfigPlugin.Profile.BURNT) {
                            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14725, (float)1.8f, (float)1.0f));
                            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15145, (float)1.0f));
                            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14993, (float)1.0f, (float)1.0f));
                        } else if (p == MixinConfigPlugin.Profile.GREEN) {
                            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14624, (float)0.5f, (float)1.0f));
                        } else {
                            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_18309, (float)(0.707107f + (float)p.ordinal() * 0.22f), (float)1.0f));
                        }
                        this.setValue("general.profile", p.name().toLowerCase(Locale.ROOT));
                    }
                    this.color((Integer)PROFILE_COLORS.get((Object)p), profSel ? 1.0f : (hovered == p ? 0.6f : 0.3f));
                    FabricationConfigScreen.method_25291((class_4587)matrices, (int)(134 + x), (int)18, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                    x += 18;
                }
                FeaturesFile.FeatureEntry profile = FeaturesFile.get("general.profile");
                int textRight = this.field_22793.method_1729(matrices, profile.name, 136.0f, 6.0f, -1);
                if (mouseX >= 136.0f && mouseX <= (float)textRight && mouseY >= 6.0f && mouseY <= 18.0f) {
                    this.renderWrappedTooltip(matrices, profile.desc, mouseX, mouseY);
                }
                if (hovered != null) {
                    FeaturesFile.FeatureEntry hoveredEntry = FeaturesFile.get("general.profile." + hovered.name().toLowerCase(Locale.ROOT));
                    this.renderWrappedTooltip(matrices, "\u00a7l" + hoveredEntry.name + "\n\u00a7f" + hoveredEntry.desc, mouseX, mouseY);
                }
                y = 40;
                FeaturesFile.FeatureEntry rchecks = FeaturesFile.get("general.runtime_checks");
                y = this.drawTrilean(matrices, "general.runtime_checks", rchecks.name, rchecks.desc, y, mouseX, mouseY, new TrileanFlag[0]);
                FeaturesFile.FeatureEntry rmot = FeaturesFile.get("general.reduced_motion");
                y = this.drawTrilean(matrices, "general.reduced_motion", rmot.name, rmot.desc, y, mouseX, mouseY, TrileanFlag.CLIENT_ONLY);
                FeaturesFile.FeatureEntry dup = FeaturesFile.get("general.data_upload");
                y = this.drawTrilean(matrices, "general.data_upload", dup.name, dup.desc, y, mouseX, mouseY, new TrileanFlag[0]);
            } else {
                for (Map.Entry en : FeaturesFile.getAll().entrySet()) {
                    if (!((String)en.getKey()).startsWith(section + ".")) continue;
                    FeaturesFile.FeatureEntry fe = (FeaturesFile.FeatureEntry)en.getValue();
                    if (fe.meta) continue;
                    TrileanFlag[] flags = new TrileanFlag[]{};
                    if (fe.sides == FeaturesFile.Sides.CLIENT_ONLY) {
                        flags = (TrileanFlag[])ArrayUtils.add((Object[])flags, (Object)((Object)TrileanFlag.CLIENT_ONLY));
                    }
                    y = this.drawTrilean(matrices, (String)en.getKey(), fe.name, fe.desc, y, mouseX, mouseY, flags);
                }
            }
        }
        if (y == startY) {
            this.field_22793.method_1729(matrices, "There are no available features in this category", 136.0f, (float)(startY + 14), -1);
        }
        float h = y - startY;
        if (selected) {
            this.selectedSectionHeight = h;
        } else {
            this.prevSelectedSectionHeight = h;
        }
        int sh = this.field_22790 - 36;
        if (h > (float)sh) {
            float knobHeight = (float)sh / h * (float)sh;
            float knobY = (selected ? this.selectedSectionScroll : this.prevSelectedSectionScroll) / (h - (float)sh) * ((float)sh - knobHeight) + 16.0f;
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)(this.field_22789 - 2), (int)Math.max(16, (int)knobY), (int)this.field_22789, (int)Math.min(this.field_22790 - 20, (int)(knobY + knobHeight)), (int)-1426063361);
        }
        class_4493.method_21928();
    }

    private boolean drawButton(class_4587 matrices, int x, int y, int w, int h, String text, float mouseX, float mouseY) {
        boolean click = false;
        boolean hover = mouseX >= (float)x && mouseX <= (float)(x + w) && mouseY >= (float)y && mouseY <= (float)(y + h);
        FabricationConfigScreen.method_25294((class_4587)matrices, (int)x, (int)y, (int)(x + w), (int)(y + h), (int)0x55000000);
        if (hover) {
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)x, (int)y, (int)(x + w), (int)(y + 1), (int)-1);
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)x, (int)y, (int)(x + 1), (int)(y + h), (int)-1);
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)x, (int)(y + h - 1), (int)(x + w), (int)(y + h), (int)-1);
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)(x + w - 1), (int)y, (int)(x + w), (int)(y + h), (int)-1);
            if (this.didClick) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                click = true;
            }
        }
        int textWidth = this.field_22793.method_1727(text);
        this.field_22793.method_1729(matrices, text, (float)(x + (w - textWidth) / 2), (float)(y + (h - 8) / 2), -1);
        return click;
    }

    private int drawTrilean(class_4587 matrices, String key, String title, String desc, int y, float mouseX, float mouseY, TrileanFlag ... flags) {
        int curX;
        int prevHue;
        int prevX;
        Trilean prevValue;
        float scale;
        boolean animateDisabled;
        if (y < -12 || y > this.field_22790 - 16) {
            return y + 14;
        }
        boolean clientOnly = ArrayUtils.contains((Object[])flags, (Object)((Object)TrileanFlag.CLIENT_ONLY));
        boolean disappear = clientOnly && this.configuringServer;
        boolean requiresFabricApi = ArrayUtils.contains((Object[])flags, (Object)((Object)TrileanFlag.REQUIRES_FABRIC_API));
        boolean noFabricApi = false;
        boolean failed = this.isFailed(key);
        boolean disabled = failed || noFabricApi || this.configuringServer && (this.serverReadOnly || clientOnly) || !this.isValid(key);
        boolean noValue = noFabricApi || this.configuringServer && clientOnly || !this.isValid(key);
        float time = this.optionAnimationTime.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
        float disabledTime = this.disabledAnimationTime.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
        float disappearTime = this.disappearAnimationTime.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
        if (disappear && !this.disappeared.contains(key)) {
            disappearTime = this.disappearAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue()))).floatValue();
            this.disappeared.add(key);
        } else if (!disappear && this.disappeared.contains(key)) {
            disappearTime = this.disappearAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue()))).floatValue();
            this.disappeared.remove(key);
        }
        if (disappear && disappearTime <= 0.0f) {
            return y;
        }
        boolean bl = animateDisabled = disabledTime > 0.0f;
        if (disabled && !this.knownDisabled.contains(key)) {
            disabledTime = this.disabledAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue()))).floatValue();
            this.knownDisabled.add(key);
        } else if (!disabled && this.knownDisabled.contains(key)) {
            disabledTime = this.disabledAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue()))).floatValue();
            this.knownDisabled.remove(key);
        }
        if (time > 0.0f) {
            if ((time -= this.field_22787.method_1534()) <= 0.0f) {
                this.optionAnimationTime.remove(key);
                time = 0.0f;
            } else {
                this.optionAnimationTime.put(key, Float.valueOf(time));
            }
        }
        if (disabledTime > 0.0f) {
            if ((disabledTime -= this.field_22787.method_1534()) <= 0.0f) {
                this.disabledAnimationTime.remove(key);
                disabledTime = 0.0f;
            } else {
                this.disabledAnimationTime.put(key, Float.valueOf(disabledTime));
            }
        }
        if (disappearTime > 0.0f) {
            if ((disappearTime -= this.field_22787.method_1534()) <= 0.0f) {
                this.disappearAnimationTime.remove(key);
                disappearTime = 0.0f;
            } else {
                this.disappearAnimationTime.put(key, Float.valueOf(disappearTime));
            }
        }
        class_4493.method_21926();
        class_4493.method_21999((float)0.0f, (float)y, (float)0.0f);
        float dia = FabricationConfigScreen.sCurve5((5.0f - disappearTime) / 5.0f);
        if (disappear) {
            scale = 1.0f - dia;
            class_4493.method_21980((float)1.0f, (float)scale, (float)1.0f);
        } else {
            scale = dia;
            class_4493.method_21980((float)1.0f, (float)scale, (float)1.0f);
        }
        boolean noUnset = key.startsWith("general.");
        Trilean currentValue = noUnset ? (this.isEnabled(key) ? Trilean.TRUE : Trilean.FALSE) : this.getValue(key);
        boolean keyEnabled = this.isEnabled(key);
        Trilean trilean = prevValue = animateDisabled ? currentValue : this.optionPreviousValues.getOrDefault(key, currentValue);
        int n = prevValue == Trilean.FALSE ? 0 : (prevValue == Trilean.TRUE ? (noUnset ? 23 : 30) : (prevX = 15));
        int n2 = prevValue == Trilean.FALSE ? 0 : (prevHue = prevValue == Trilean.TRUE ? 120 : 55);
        int n3 = currentValue == Trilean.FALSE ? 0 : (currentValue == Trilean.TRUE ? (noUnset ? 23 : 30) : (curX = 15));
        int curHue = currentValue == Trilean.FALSE ? 0 : (currentValue == Trilean.TRUE ? 120 : 55);
        float a = FabricationConfigScreen.sCurve5((5.0f - time) / 5.0f);
        float da = FabricationConfigScreen.sCurve5((5.0f - disabledTime) / 5.0f);
        if (!disabled) {
            da = 1.0f - da;
        }
        if (clientOnly) {
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)133, (int)0, (int)180, (int)11, (int)-22016);
        } else {
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)133, (int)0, (int)180, (int)11, (int)-1);
        }
        FabricationConfigScreen.method_25294((class_4587)matrices, (int)134, (int)1, (int)179, (int)10, (int)0x66000000);
        if (!noUnset) {
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)149, (int)1, (int)164, (int)10, (int)0x33000000);
        }
        class_4493.method_21926();
        class_4493.method_21999((float)(134.0f + ((float)prevX + (float)(curX - prevX) * a)), (float)0.0f, (float)0.0f);
        int knobAlpha = (int)((noValue ? 1.0f - da : 1.0f) * 255.0f) << 24;
        FabricationConfigScreen.method_25294((class_4587)matrices, (int)0, (int)1, (int)(noUnset ? 22 : 15), (int)10, (int)(class_3532.method_15369((float)(((float)prevHue + (float)(curHue - prevHue) * a) / 360.0f), (float)0.9f, (float)0.8f) | knobAlpha));
        if (!noUnset && a >= 1.0f && currentValue == Trilean.UNSET) {
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)(keyEnabled ? 15 : -1), (int)1, (int)(keyEnabled ? 16 : 0), (int)10, (int)(class_3532.method_15369((float)((float)(keyEnabled ? 120 : 0) / 360.0f), (float)0.9f, (float)0.8f) | knobAlpha));
        }
        class_4493.method_21928();
        class_4493.method_22056();
        RenderSystem.defaultBlendFunc();
        this.field_22787.method_1531().method_22813(new class_2960("fabrication", "trilean.png"));
        class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f + (1.0f - da) * 0.5f));
        class_4493.method_21910();
        if (noUnset) {
            FabricationConfigScreen.method_25290((class_4587)matrices, (int)137, (int)1, (float)0.0f, (float)0.0f, (int)15, (int)9, (int)45, (int)9);
            FabricationConfigScreen.method_25290((class_4587)matrices, (int)160, (int)1, (float)30.0f, (float)0.0f, (int)15, (int)9, (int)45, (int)9);
        } else {
            FabricationConfigScreen.method_25290((class_4587)matrices, (int)134, (int)1, (float)0.0f, (float)0.0f, (int)45, (int)9, (int)45, (int)9);
        }
        class_4493.method_21912();
        if (this.didClick && mouseX >= 134.0f && mouseX <= 179.0f && mouseY >= (float)(y + 1) && mouseY <= (float)(y + 10)) {
            float pitch = (float)y * 0.005f;
            if (disabled) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_18310, (float)0.8f, (float)1.0f));
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_18310, (float)0.7f, (float)1.0f));
                this.tooltipBlinkTicks = 20;
            } else {
                int clickedIndex = (int)((mouseX - 134.0f) / (float)(noUnset ? 22 : 15));
                Trilean newValue = clickedIndex == 0 ? Trilean.FALSE : (clickedIndex == 1 && !noUnset ? Trilean.UNSET : Trilean.TRUE);
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)(newValue == Trilean.FALSE ? class_3417.field_14624 : (newValue == Trilean.UNSET ? class_3417.field_18309 : class_3417.field_14725)), (float)(0.6f + pitch), (float)1.0f));
                if (newValue != currentValue) {
                    this.optionPreviousValues.put(key, currentValue);
                    this.optionAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue())));
                    this.setValue(key, newValue.toString().toLowerCase(Locale.ROOT));
                }
            }
        }
        int textAlpha = (int)((0.7f + (1.0f - da) * 0.3f) * 255.0f) << 24;
        int startY = y;
        int startX = 186;
        y = (int)((float)y + (float)this.drawWrappedText(matrices, startX, 2.0f, title, this.field_22789 - startX - 6, 0xFFFFFF | textAlpha, false) * scale);
        int endX = this.field_22789 - 6;
        class_4493.method_21928();
        if (mouseX >= (float)startX && mouseX <= (float)endX && mouseY >= (float)startY && mouseY <= (float)y) {
            String prefix = "";
            if (clientOnly) {
                prefix = prefix + "\u00a76Client Only ";
            }
            if (requiresFabricApi) {
                prefix = prefix + "\u00a7bRequires Fabric API ";
            }
            if (!prefix.isEmpty()) {
                prefix = prefix + "\u00a7r\n";
            }
            this.renderWrappedTooltip(matrices, prefix + desc, mouseX, mouseY);
        } else if (mouseX >= 134.0f && mouseX <= 179.0f && mouseY >= (float)startY && mouseY <= (float)(startY + 10)) {
            if (disabled) {
                if (noFabricApi) {
                    this.method_25424(matrices, (class_2561)new class_2585((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "This option requires Fabric API"), (int)mouseX, (int)mouseY);
                } else if (noValue) {
                    this.method_25424(matrices, (class_2561)new class_2585((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "The server does not recognize this option"), (int)mouseX, (int)mouseY);
                } else if (failed) {
                    this.method_25424(matrices, (class_2561)new class_2585((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "This feature failed to initialize"), (int)mouseX, (int)mouseY);
                } else {
                    this.method_25424(matrices, (class_2561)new class_2585((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "You cannot configure this server"), (int)mouseX, (int)mouseY);
                }
            } else {
                int index = (int)((mouseX - 134.0f) / (float)(noUnset ? 22 : 15));
                if (index == 0) {
                    this.method_25424(matrices, (class_2561)new class_2585("\u00a7cDisable"), (int)mouseX, (int)mouseY);
                } else if (index == 1 && !noUnset) {
                    if (currentValue == Trilean.UNSET) {
                        this.method_30901(matrices, Lists.newArrayList((Object[])new class_2561[]{new class_2585("\u00a7eUse default value \u00a7f(see General > Profile)"), new class_2585("\u00a7rCurrent default: " + (keyEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))}), (int)mouseX, (int)mouseY);
                    } else {
                        this.method_25424(matrices, (class_2561)new class_2585("\u00a7eUse default value \u00a7f(see General > Profile)"), (int)mouseX, (int)mouseY);
                    }
                } else {
                    this.method_25424(matrices, (class_2561)new class_2585("\u00a7aEnable"), (int)mouseX, (int)mouseY);
                }
            }
        }
        return y + 2;
    }

    private void renderWrappedTooltip(class_4587 matrices, String str, float mouseX, float mouseY) {
        this.method_25417(matrices, this.field_22793.method_1728((class_5348)new class_2585(str), mouseX < (float)(this.field_22789 / 2) ? (int)((float)this.field_22789 - mouseX - 30.0f) : (int)mouseX - 20), (int)mouseX, (int)(20.0f + mouseY));
    }

    public static String formatTitleCase(String in) {
        String[] pieces = new String[]{in};
        if (in.contains(" ")) {
            pieces = in.toLowerCase().split(" ");
        } else if (in.contains("_")) {
            pieces = in.toLowerCase().split("_");
        }
        StringBuilder result = new StringBuilder();
        for (String s : pieces) {
            String t;
            if (s == null || (t = s.trim().toLowerCase()).isEmpty()) continue;
            result.append(Character.toUpperCase(t.charAt(0)));
            if (t.length() > 1) {
                result.append(t.substring(1));
            }
            result.append(" ");
        }
        return result.toString().trim();
    }

    private void color(int packed) {
        this.color(packed, (float)(packed >> 24 & 0xFF) / 255.0f);
    }

    private void color(int packed, float alpha) {
        class_4493.method_22000((float)((float)(packed >> 16 & 0xFF) / 255.0f), (float)((float)(packed >> 8 & 0xFF) / 255.0f), (float)((float)(packed >> 0 & 0xFF) / 255.0f), (float)alpha);
    }

    public void method_25419() {
        if (!MixinConfigPlugin.isEnabled("*.reduced_motion") && !this.leaving) {
            this.leaving = true;
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17603, (float)0.7f));
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_21933, (float)2.0f, (float)1.0f));
        } else {
            this.field_22787.method_1507(this.parent);
        }
        try {
            if (this.parent instanceof ModsScreen) {
                ((ModsScreen)this.parent).configScreenCache.remove("fabrication");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void method_25393() {
        float h;
        super.method_25393();
        if (this.sidebarHeight > (float)this.field_22790) {
            this.lastSidebarScroll = this.sidebarScroll;
            this.sidebarScroll += (this.sidebarScrollTarget - this.sidebarScroll) / 2.0f;
            if (this.sidebarScrollTarget < 0.0f) {
                this.sidebarScrollTarget /= 2.0f;
            }
            if (this.sidebarScrollTarget > (h = this.sidebarHeight - (float)this.field_22790)) {
                this.sidebarScrollTarget = h + (this.sidebarScrollTarget - h) / 2.0f;
            }
        }
        if (this.selectedSectionHeight > (float)(this.field_22790 - 36)) {
            this.lastSelectedSectionScroll = this.selectedSectionScroll;
            this.selectedSectionScroll += (this.selectedSectionScrollTarget - this.selectedSectionScroll) / 2.0f;
            if (this.selectedSectionScrollTarget < 0.0f) {
                this.selectedSectionScrollTarget /= 2.0f;
            }
            if (this.selectedSectionScrollTarget > (h = this.selectedSectionHeight - (float)(this.field_22790 - 36))) {
                this.selectedSectionScrollTarget = h + (this.selectedSectionScrollTarget - h) / 2.0f;
            }
        }
        if (this.prevSelectedSectionHeight > (float)(this.field_22790 - 36)) {
            this.lastPrevSelectedSectionScroll = this.prevSelectedSectionScroll;
            this.prevSelectedSectionScroll += (this.prevSelectedSectionScrollTarget - this.prevSelectedSectionScroll) / 2.0f;
            if (this.prevSelectedSectionScrollTarget < 0.0f) {
                this.prevSelectedSectionScrollTarget /= 2.0f;
            }
            if (this.prevSelectedSectionScrollTarget > (h = this.prevSelectedSectionHeight - (float)(this.field_22790 - 36))) {
                this.prevSelectedSectionScrollTarget = h + (this.prevSelectedSectionScrollTarget - h) / 2.0f;
            }
        }
        if (this.tooltipBlinkTicks > 0) {
            --this.tooltipBlinkTicks;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (mouseX <= 120.0) {
            this.sidebarScrollTarget = (float)((double)this.sidebarScrollTarget - amount * 20.0);
        } else {
            this.selectedSectionScrollTarget = (float)((double)this.selectedSectionScrollTarget - amount * 20.0);
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.configuringServer) {
                if (mouseX > (double)(this.field_22789 - 120) && mouseY < 16.0) {
                    this.hasClonked = false;
                    this.serverAnimateTime = 10.0f - this.serverAnimateTime;
                    this.configuringServer = false;
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14776, (float)0.8f, (float)1.0f));
                }
            } else if (mouseX > (double)(this.field_22789 - 120) && mouseY < 16.0) {
                if (this.whyCantConfigureServer == null) {
                    this.hasClonked = false;
                    this.serverAnimateTime = 10.0f - this.serverAnimateTime;
                    this.configuringServer = true;
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14776, (float)1.2f, (float)1.0f));
                } else {
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_18310, (float)0.8f, (float)1.0f));
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_18310, (float)0.7f, (float)1.0f));
                    this.tooltipBlinkTicks = 20;
                }
            }
            this.didClick = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private String getVersion() {
        if (this.configuringServer) {
            return ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerVersion();
        }
        return Agnos.getModVersion();
    }

    private boolean isFailed(String key) {
        if (this.configuringServer) {
            return ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerFailedConfig().contains(key);
        }
        return MixinConfigPlugin.isFailed(key);
    }

    private boolean isValid(String key) {
        if (this.configuringServer) {
            return ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerTrileanConfig().containsKey(key) || ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerStringConfig().containsKey(key);
        }
        return MixinConfigPlugin.isValid(key);
    }

    private boolean isTrilean(String key) {
        if (this.configuringServer) {
            return ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerTrileanConfig().containsKey(key);
        }
        return MixinConfigPlugin.isTrilean(key);
    }

    private ResolvedTrilean getResolvedValue(String key) {
        if (this.configuringServer) {
            return ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerTrileanConfig().getOrDefault(key, ResolvedTrilean.DEFAULT_FALSE);
        }
        return MixinConfigPlugin.getResolvedValue(key);
    }

    private Trilean getValue(String key) {
        return this.getResolvedValue((String)key).trilean;
    }

    private boolean isEnabled(String key) {
        return this.getResolvedValue((String)key).value;
    }

    private String getRawValue(String key) {
        if (this.configuringServer) {
            if (this.isTrilean(key)) {
                return this.getValue(key).toString().toLowerCase(Locale.ROOT);
            }
            return ((GetServerConfig)this.field_22787.method_1562()).fabrication$getServerStringConfig().get(key);
        }
        return MixinConfigPlugin.getRawValue(key);
    }

    private void setValue(String key, String value) {
        boolean runtimeChecksToggled;
        Map<String, String> changedKeysWithoutRuntimeChecks;
        Set<String> newlyNotFalseKeys;
        Set<String> newlyFalseKeys;
        if (this.configuringServer) {
            this.checkServerData();
            newlyFalseKeys = newlyFalseKeysServer;
            newlyNotFalseKeys = newlyNotFalseKeysServer;
            changedKeysWithoutRuntimeChecks = changedKeysWithoutRuntimeChecksServer;
            runtimeChecksToggled = runtimeChecksToggledServer;
        } else {
            newlyFalseKeys = newlyFalseKeysClient;
            newlyNotFalseKeys = newlyNotFalseKeysClient;
            changedKeysWithoutRuntimeChecks = changedKeysWithoutRuntimeChecksClient;
            runtimeChecksToggled = runtimeChecksToggledClient;
        }
        String oldValue = this.getRawValue(key);
        if ("general.runtime_checks".equals(key)) {
            runtimeChecksToggled = !runtimeChecksToggled;
        } else if (!MixinConfigPlugin.isRuntimeConfigurable(key)) {
            if (value.equals("false")) {
                if (newlyNotFalseKeys.contains(key)) {
                    newlyNotFalseKeys.remove(key);
                } else {
                    newlyFalseKeys.add(key);
                }
            } else if (oldValue.equals("false")) {
                if (newlyFalseKeys.contains(key)) {
                    newlyFalseKeys.remove(key);
                } else {
                    newlyNotFalseKeys.add(key);
                }
            }
        }
        if (!("general.runtime_checks".equals(key) || this.isEnabled("general.runtime_checks") || runtimeChecksToggled || MixinConfigPlugin.isRuntimeConfigurable(key))) {
            if (changedKeysWithoutRuntimeChecks.containsKey(key)) {
                if (changedKeysWithoutRuntimeChecks.get(key).equals(value)) {
                    changedKeysWithoutRuntimeChecks.remove(key);
                }
            } else {
                changedKeysWithoutRuntimeChecks.put(key, oldValue);
            }
        }
        if (this.configuringServer) {
            runtimeChecksToggledServer = runtimeChecksToggled;
            class_2540 data = new class_2540(Unpooled.buffer());
            data.method_10804(1);
            data.method_10814(key);
            data.method_10814(value);
            this.field_22787.method_1562().method_2883((class_2596)new class_2817(new class_2960("fabrication", "config"), data));
        } else {
            runtimeChecksToggledClient = runtimeChecksToggled;
            MixinConfigPlugin.set(key, value);
            if (FabricationMod.isAvailableFeature(key)) {
                FabricationMod.updateFeature(key);
            }
        }
    }

    public static float sCurve5(float a) {
        float a3 = a * a * a;
        float a4 = a3 * a;
        float a5 = a4 * a;
        return 6.0f * a5 - 15.0f * a4 + 10.0f * a3;
    }

    /*
     * WARNING - void declaration
     */
    public void method_25417(class_4587 matrices, List<? extends class_5481> lines, int x, int y) {
        if (!lines.isEmpty()) {
            int n;
            if (this.bufferTooltips) {
                int yf = y;
                this.bufferedTooltips.add(() -> this.method_25417(matrices, lines, x, yf));
                return;
            }
            if (y < 20) {
                y += 20;
            }
            int maxWidth = 0;
            for (class_5481 class_54812 : lines) {
                int width = this.field_22793.method_30880(class_54812);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            int innerX = x + 12;
            int n2 = y - 12;
            int totalHeight = 8;
            if (lines.size() > 1) {
                totalHeight += (lines.size() - 1) * 10;
            }
            if (innerX + maxWidth > this.field_22789) {
                innerX -= 28 + maxWidth;
            }
            if (n2 + totalHeight + 6 > this.field_22790) {
                n = this.field_22790 - totalHeight - 6;
            }
            matrices.method_22903();
            FabricationConfigScreen.method_25294((class_4587)matrices, (int)(innerX - 3), (int)(n - 3), (int)(innerX + maxWidth + 3), (int)(n + totalHeight + 3), (int)-1442840576);
            class_4597.class_4598 vcp = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            matrices.method_22904(0.0, 0.0, 400.0);
            for (int i = 0; i < lines.size(); ++i) {
                class_5481 line = lines.get(i);
                if (line != null) {
                    void var7_12;
                    this.field_22793.method_22942(line, (float)innerX, (float)var7_12, -1, false, matrices.method_23760().method_23761(), (class_4597)vcp, false, 0, 0xF000F0);
                }
                var7_12 += 10;
            }
            vcp.method_22993();
            matrices.method_22909();
        }
    }

    public static enum TrileanFlag {
        CLIENT_ONLY,
        REQUIRES_FABRIC_API;

    }
}

