/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Sets;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.loaders.LoaderDimensionalTools;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.Feature;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

@EligibleIf(configEnabled="*.dimensional_tools")
public class FeatureDimensionalTools
implements Feature {
    private static final NumberFormat format = NumberFormat.getNumberInstance();
    private boolean applied = false;
    private boolean active = false;

    @Override
    public void apply() {
        this.active = true;
        if (!this.applied) {
            this.applied = true;
            if (Agnos.getCurrentEnv() == Env.CLIENT) {
                this.applyClient();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void applyClient() {
        Agnos.runForTooltipRender((stack, lines) -> {
            if (this.active && !stack.method_7960() && stack.method_7985() && stack.method_7969().method_10545("fabrication:PartialDamage")) {
                for (int i = 0; i < lines.size(); ++i) {
                    Object t = lines.get(i);
                    double part = stack.method_7969().method_10574("fabrication:PartialDamage");
                    if (!(t instanceof class_2588) || !((class_2588)t).method_11022().equals("item.durability")) continue;
                    lines.set(i, new class_2588("item.durability", new Object[]{format.format((double)(stack.method_7936() - stack.method_7919()) + (1.0 - part)), stack.method_7936()}));
                }
            }
        });
    }

    @Override
    public boolean undo() {
        this.active = false;
        return true;
    }

    @Override
    public String getConfigKey() {
        return "*.dimensional_tools";
    }

    public static void handleCraft(class_1715 inv, class_1799 stack) {
        if (LoaderDimensionalTools.isSubstitutable(stack.method_7909())) {
            int count = 0;
            HashMultiset dimensions = null;
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 ing = inv.method_5438(i);
                if (ing.method_7960()) continue;
                Set<LoaderDimensionalTools.MohsIdentifier> assoc = LoaderDimensionalTools.getAssociatedDimensionsForIngredient(ing);
                if (assoc.isEmpty()) {
                    return;
                }
                if (assoc.contains(null)) continue;
                ++count;
                if (dimensions == null) {
                    dimensions = HashMultiset.create();
                }
                dimensions.addAll(assoc);
            }
            if (dimensions != null) {
                HashSet finalDimensions = Sets.newHashSet();
                for (Object en : dimensions.entrySet()) {
                    if (en.getCount() != count) continue;
                    finalDimensions.add((LoaderDimensionalTools.MohsIdentifier)en.getElement());
                }
                if (!finalDimensions.isEmpty()) {
                    String s = class_2477.method_10517().method_4679(stack.method_7922());
                    for (LoaderDimensionalTools.NameSubstitution sub : LoaderDimensionalTools.nameSubstitutions) {
                        if (!finalDimensions.contains(new LoaderDimensionalTools.MohsIdentifier(true, sub.dimId)) && !finalDimensions.contains(new LoaderDimensionalTools.MohsIdentifier(false, sub.dimId))) continue;
                        s = s.replace(sub.find, sub.replace);
                    }
                    stack.method_7977((class_2561)new class_2585("\u00a7f" + s));
                    class_2499 li = new class_2499();
                    for (LoaderDimensionalTools.MohsIdentifier dim : finalDimensions) {
                        li.add((Object)class_2519.method_23256((String)dim.toString()));
                    }
                    stack.method_7969().method_10566("fabrication:HonoraryDimensions", (class_2520)li);
                }
            }
        }
    }

    static {
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(2);
    }
}

