/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.Cardinal;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabricationClientCommands;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.FeaturesFile;
import com.unascribed.fabrication.PlayerTag;
import com.unascribed.fabrication.interfaces.TaggablePlayer;
import com.unascribed.fabrication.support.Feature;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2164;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5458;

public class FeatureFabricationCommand
implements Feature {
    @Override
    public void apply() {
        Agnos.runForCommandRegistration((dispatcher, dedi) -> {
            try {
                LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)"fabrication");
                FeatureFabricationCommand.addConfig(root, dedi);
                LiteralArgumentBuilder tag = LiteralArgumentBuilder.literal((String)"tag");
                tag.requires(scs -> MixinConfigPlugin.isEnabled("*.taggable_players") && scs.method_9259(2));
                LiteralArgumentBuilder add = LiteralArgumentBuilder.literal((String)"add");
                LiteralArgumentBuilder remove = LiteralArgumentBuilder.literal((String)"remove");
                LiteralArgumentBuilder get = LiteralArgumentBuilder.literal((String)"get");
                LiteralArgumentBuilder clear = LiteralArgumentBuilder.literal((String)"clear");
                for (PlayerTag pt : PlayerTag.values()) {
                    add.then(((LiteralArgumentBuilder)class_2170.method_9247((String)pt.lowerName()).executes(c -> this.addTag((CommandContext<class_2168>)c, Collections.singleton(((class_2168)c.getSource()).method_9207()), pt))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(c -> this.addTag((CommandContext<class_2168>)c, class_2186.method_9312((CommandContext)c, (String)"players"), pt))));
                    remove.then(((LiteralArgumentBuilder)class_2170.method_9247((String)pt.lowerName()).executes(c -> this.removeTag((CommandContext<class_2168>)c, Collections.singleton(((class_2168)c.getSource()).method_9207()), pt))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(c -> this.removeTag((CommandContext<class_2168>)c, class_2186.method_9312((CommandContext)c, (String)"players"), pt))));
                }
                ((LiteralArgumentBuilder)get.executes(c -> this.getTags((CommandContext<class_2168>)c, ((class_2168)c.getSource()).method_9207()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(c -> this.getTags((CommandContext<class_2168>)c, class_2186.method_9315((CommandContext)c, (String)"player"))));
                ((LiteralArgumentBuilder)clear.executes(c -> this.clearTags((CommandContext<class_2168>)c, Collections.singleton(((class_2168)c.getSource()).method_9207())))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(c -> this.clearTags((CommandContext<class_2168>)c, class_2186.method_9312((CommandContext)c, (String)"players"))));
                tag.then((ArgumentBuilder)add);
                tag.then((ArgumentBuilder)remove);
                tag.then((ArgumentBuilder)get);
                tag.then((ArgumentBuilder)clear);
                root.then((ArgumentBuilder)tag);
                LiteralArgumentBuilder analyze = LiteralArgumentBuilder.literal((String)"analyze");
                analyze.requires(scs -> scs.method_9259(4));
                LiteralArgumentBuilder biome = class_2170.method_9247((String)"biome");
                for (Map.Entry en : class_5458.field_25933.method_29722()) {
                    class_2960 id = ((class_5321)en.getKey()).method_29177();
                    class_2960 b = ((class_5321)en.getKey()).method_29177();
                    Command exec = c -> {
                        class_1937 w;
                        HashSet set = Sets.newHashSet((Object[])new class_2960[]{b});
                        try {
                            c.getArgument("dimension", class_2960.class);
                            w = class_2181.method_9289((CommandContext)c, (String)"dimension");
                        }
                        catch (IllegalArgumentException e) {
                            w = ((class_2168)c.getSource()).method_9229().field_6002;
                        }
                        return this.analyzeBlockDistribution((CommandContext<class_2168>)c, w, set);
                    };
                    if (id.method_12836().equals("minecraft")) {
                        biome.then(class_2170.method_9247((String)id.method_12832()).executes(exec));
                    }
                    biome.then(class_2170.method_9247((String)id.toString()).executes(exec));
                }
                analyze.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"block_distribution").executes(c -> this.analyzeBlockDistribution((CommandContext<class_2168>)c, ((class_2168)c.getSource()).method_9229().field_6002, null))).then((ArgumentBuilder)biome)).then(class_2170.method_9247((String)"in").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).then((ArgumentBuilder)biome)).executes(c -> this.analyzeBlockDistribution((CommandContext<class_2168>)c, (class_1937)class_2181.method_9289((CommandContext)c, (String)"dimension"), null)))));
                root.then((ArgumentBuilder)analyze);
                dispatcher.register(root);
            }
            catch (Throwable t) {
                FabricationMod.featureError(this, t);
            }
        });
    }

    private int analyzeBlockDistribution(CommandContext<class_2168> c, class_1937 world, Set<class_2960> biomesIn) {
        HashSet biomes = Sets.newHashSet();
        for (class_2960 b : biomesIn) {
            biomes.add((class_1959)((class_2168)c.getSource()).method_9211().method_30611().method_30530(class_2378.field_25114).method_10223(b));
        }
        String name = "fabrication_block_distribution_" + System.currentTimeMillis() + ".tsv";
        ((class_2168)c.getSource()).method_9226((class_2561)new class_2585("Starting background block distribution analysis"), false);
        ((class_2168)c.getSource()).method_9226((class_2561)new class_2585("This could take a while, but the server should remain usable"), false);
        ((class_2168)c.getSource()).method_9226((class_2561)new class_2585("Once complete a file named " + name + " will appear in the server directory"), false);
        ((class_2168)c.getSource()).method_9226((class_2561)new class_2585("Progress reports will go to the console"), false);
        new Thread(() -> {
            class MutableLong {
                long value = 1L;

                MutableLong() {
                }
            }
            int x = 0;
            int z = 0;
            Cardinal dir = Cardinal.WEST;
            int legLength = 0;
            int i = 0;
            int j = 0;
            int scannedChunks = 0;
            long scanned = 0L;
            long skipped = 0L;
            long goal = (biomes.isEmpty() ? 8000 : 1000) * 16 * 16 * world.method_8322();
            HashMap counts = Maps.newHashMap();
            block12: while (true) {
                class_2791 chunk;
                if ((chunk = world.method_8402(x, z, class_2806.field_12803, false)) == null) {
                    try {
                        int fx = x;
                        int fz = z;
                        chunk = (class_2791)world.method_8503().method_5385(() -> world.method_8402(fx, fz, class_2806.field_12803, true)).get();
                    }
                    catch (Exception e) {
                        FabLog.warn("Failed to generate chunk at " + x + ", " + z + " for block distribution analysis");
                    }
                }
                if (chunk != null) {
                    class_2791 e = chunk;
                    synchronized (e) {
                        for (int cY = 0; cY < chunk.method_8322(); ++cY) {
                            for (int cX = 0; cX < 16; ++cX) {
                                for (int cZ = 0; cZ < 16; ++cZ) {
                                    class_1959 b2;
                                    if (biomes != null && !biomes.contains(b2 = ((class_3218)world).method_14178().method_12129().method_12098().method_16359(cX + chunk.method_12004().method_8326(), cY, cZ + chunk.method_12004().method_8328()))) {
                                        if (++skipped <= goal || scanned != 0L) continue;
                                        FabLog.warn("We have skipped more blocks than our goal and found nothing matching the given biome. Giving up.");
                                        return;
                                    }
                                    class_2826 section = chunk.method_12006()[cY / 16];
                                    class_2680 state = section != null ? section.method_12254(cX, cY % 16, cZ) : class_2246.field_10243.method_9564();
                                    counts.compute(state, (bs, ml) -> {
                                        if (ml == null) {
                                            return new MutableLong();
                                        }
                                        ++ml.value;
                                        return ml;
                                    });
                                    if (++scanned < goal) continue;
                                    break block12;
                                }
                            }
                        }
                    }
                    if (++scannedChunks % 20 == 0) {
                        FabLog.info("Scanned " + scanned + "/" + goal + " blocks... (skipped " + skipped + ") " + scanned * 100L / goal + "% done");
                    }
                }
                if (i >= legLength) {
                    dir = dir.ccw();
                    i = 0;
                    if (++j % 2 == 0) {
                        ++legLength;
                    }
                }
                x += dir.xOfs();
                z += dir.yOfs();
                ++i;
            }
            FabLog.info("Scanned " + scanned + "/" + goal + " blocks (skipped " + skipped + "), 100% done. Writing file");
            FabLog.info("NOTE: Fabrication block distribution analysis is NOT A BENCHMARK. Chunk generation speed is intentionally limited to keep servers responsive and not crashing.");
            ArrayList sorted = Lists.newArrayList(counts.entrySet());
            sorted.sort((a, b) -> Long.compare(((MutableLong)b.getValue()).value, ((MutableLong)a.getValue()).value));
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(name)), Charsets.UTF_8);){
                osw.write("blockstate\tpercentage\r\n");
                BigDecimal scannedBD = new BigDecimal(scanned);
                BigDecimal hundred = new BigDecimal(100);
                for (Map.Entry en : sorted) {
                    osw.write(class_2378.field_11146.method_10221((Object)((class_2680)en.getKey()).method_26204()).toString().replace("\t", "    "));
                    if (!((class_2680)en.getKey()).method_11656().isEmpty()) {
                        osw.write("[");
                        boolean first = true;
                        for (Map.Entry stateEn : ((class_2680)en.getKey()).method_11656().entrySet()) {
                            if (first) {
                                first = false;
                            } else {
                                osw.write(",");
                            }
                            osw.write(((class_2769)stateEn.getKey()).method_11899().replace("\t", "    "));
                            osw.write("=");
                            osw.write(((class_2769)stateEn.getKey()).method_11901((Comparable)stateEn.getValue()).replace("\t", "    "));
                        }
                        osw.write("]");
                    }
                    osw.write("\t");
                    osw.write(new BigDecimal(((MutableLong)en.getValue()).value).divide(scannedBD, MathContext.DECIMAL64).multiply(hundred).toString());
                    osw.write("\r\n");
                }
                FabLog.info(name + " written to disk.");
            }
            catch (IOException e) {
                FabLog.error("Failed to save block distribution data", e);
            }
        }, "Fabrication block analysis").start();
        return 1;
    }

    public static <T extends class_2172> void addConfig(LiteralArgumentBuilder<T> root, boolean dediServer) {
        LiteralArgumentBuilder config = LiteralArgumentBuilder.literal((String)"config");
        config.requires(s -> {
            class_1297 e;
            if (!(s instanceof class_2168)) {
                return true;
            }
            class_2168 scs = (class_2168)s;
            if (scs.method_9259(2)) {
                return true;
            }
            return scs.method_9211().method_3724() && scs.method_9228() != null && (e = scs.method_9228()) instanceof class_1657 && scs.method_9211().method_3811().equals(((class_1657)e).method_7334().getName());
        });
        LiteralArgumentBuilder get = LiteralArgumentBuilder.literal((String)"get");
        for (String s2 : MixinConfigPlugin.getAllKeys()) {
            LiteralArgumentBuilder key = LiteralArgumentBuilder.literal((String)s2);
            key.executes(c -> {
                String value = MixinConfigPlugin.getRawValue(s2);
                boolean tri = MixinConfigPlugin.isTrilean(s2);
                if (value.isEmpty() && tri) {
                    value = "unset";
                }
                boolean def = MixinConfigPlugin.getDefault(s2);
                class_2585 txt = new class_2585(s2 + " = " + value + (tri ? " (default " + def + ")" : ""));
                if (tri && !MixinConfigPlugin.isEnabled(s2)) {
                    throw new class_2164((class_2561)txt.method_27692(class_124.field_1068));
                }
                FeatureFabricationCommand.sendFeedback((CommandContext<? extends class_2172>)c, txt, false);
                return 1;
            });
            get.then((ArgumentBuilder)key);
        }
        config.then((ArgumentBuilder)get);
        LiteralArgumentBuilder set = LiteralArgumentBuilder.literal((String)"set");
        for (String s3 : MixinConfigPlugin.getAllKeys()) {
            if (dediServer && FeaturesFile.get((String)s3).sides == FeaturesFile.Sides.CLIENT_ONLY) continue;
            LiteralArgumentBuilder key = LiteralArgumentBuilder.literal((String)s3);
            String[] values = s3.equals("general.runtime_checks") ? new String[]{"true", "false"} : (s3.equals("general.profile") ? MixinConfigPlugin.Profile.stringValues() : new String[]{"unset", "true", "false"});
            for (String v : values) {
                key.then(LiteralArgumentBuilder.literal((String)v).executes(c -> {
                    FeatureFabricationCommand.setKeyWithFeedback((CommandContext<? extends class_2172>)c, s3, v);
                    return 1;
                }));
            }
            set.then((ArgumentBuilder)key);
        }
        config.then((ArgumentBuilder)set);
        config.then(LiteralArgumentBuilder.literal((String)"reload").executes(c -> {
            MixinConfigPlugin.reload();
            if (c.getSource() instanceof class_2168) {
                FabricationMod.sendConfigUpdate(((class_2168)c.getSource()).method_9211(), null);
            }
            FeatureFabricationCommand.sendFeedback((CommandContext<? extends class_2172>)c, new class_2585("Fabrication configuration reloaded"), true);
            FeatureFabricationCommand.sendFeedback((CommandContext<? extends class_2172>)c, new class_2585("\u00a7eYou may need to restart the game for the changes to take effect."), false);
            return 1;
        }));
        root.then((ArgumentBuilder)config);
    }

    private static void sendFeedback(CommandContext<? extends class_2172> c, class_2585 text, boolean broadcast) {
        if (c.getSource() instanceof class_2168) {
            ((class_2168)c.getSource()).method_9226((class_2561)text, broadcast);
        } else {
            FeatureFabricationCommand.sendFeedbackClient(c, text);
        }
    }

    private static void sendFeedbackClient(CommandContext<? extends class_2172> c, class_2585 text) {
        FabricationClientCommands.sendFeedback(c, text);
    }

    private int clearTags(CommandContext<class_2168> c, Collection<class_3222> players) {
        for (class_3222 spe : players) {
            ((TaggablePlayer)spe).fabrication$clearTags();
            ((class_2168)c.getSource()).method_9226((class_2561)new class_2585("Cleared tags for ").method_10852(spe.method_5476()), true);
        }
        return 1;
    }

    private int getTags(CommandContext<class_2168> c, class_3222 player) {
        class_2585 lt = new class_2585("Tags: ");
        Set<PlayerTag> tags = ((TaggablePlayer)player).fabrication$getTags();
        if (tags.isEmpty()) {
            lt.method_27693("none");
        } else {
            lt.method_27693(Joiner.on((String)", ").join((Iterable)Collections2.transform(tags, PlayerTag::lowerName)));
        }
        ((class_2168)c.getSource()).method_9226((class_2561)lt, false);
        return 1;
    }

    private int addTag(CommandContext<class_2168> c, Collection<class_3222> players, PlayerTag pt) {
        for (class_3222 spe : players) {
            ((TaggablePlayer)spe).fabrication$setTag(pt, true);
            ((class_2168)c.getSource()).method_9226((class_2561)new class_2585("Added tag " + pt.lowerName() + " to ").method_10852(spe.method_5476()), true);
        }
        return 1;
    }

    private int removeTag(CommandContext<class_2168> c, Collection<class_3222> players, PlayerTag pt) {
        for (class_3222 spe : players) {
            ((TaggablePlayer)spe).fabrication$setTag(pt, false);
            ((class_2168)c.getSource()).method_9226((class_2561)new class_2585("Removed tag " + pt.lowerName() + " from ").method_10852(spe.method_5476()), true);
        }
        return 1;
    }

    private static void setKeyWithFeedback(CommandContext<? extends class_2172> c, String key, String value) {
        String oldValue = MixinConfigPlugin.getRawValue(key);
        boolean def = MixinConfigPlugin.getDefault(key);
        boolean tri = MixinConfigPlugin.isTrilean(key);
        if (value.equals(oldValue)) {
            FeatureFabricationCommand.sendFeedback(c, new class_2585(key + " is already set to " + value + (tri ? " (default " + def + ")" : "")), false);
        } else {
            MixinConfigPlugin.set(key, value);
            if (c.getSource() instanceof class_2168) {
                FabricationMod.sendConfigUpdate(((class_2168)c.getSource()).method_9211(), key);
            }
            FeatureFabricationCommand.sendFeedback(c, new class_2585(key + " is now set to " + value + (tri ? " (default " + def + ")" : "")), true);
            if (FabricationMod.isAvailableFeature(key) && FabricationMod.updateFeature(key)) {
                return;
            }
            if ("general.runtime_checks".equals(key)) {
                FeatureFabricationCommand.sendFeedback(c, new class_2585("\u00a7cYou will need to restart the game for this change to take effect."), false);
            } else if (!MixinConfigPlugin.RUNTIME_CHECKS_WAS_ENABLED && !MixinConfigPlugin.isRuntimeConfigurable(key)) {
                FeatureFabricationCommand.sendFeedback(c, new class_2585("\u00a7cgeneral.runtime_checks is disabled, you may need to restart the game for this change to take effect."), false);
            }
        }
    }

    @Override
    public boolean undo() {
        return false;
    }

    @Override
    public String getConfigKey() {
        return null;
    }
}

