/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.google.common.collect.Lists;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.interfaces.GetSuppressedSlots;
import com.unascribed.fabrication.interfaces.SetFabricationConfigAware;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Feature;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2744;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

@EligibleIf(configEnabled="*.hide_armor")
public class FeatureHideArmor
implements Feature {
    private static final class_1304[] ALL_ARMOR = new class_1304[]{class_1304.field_6166, class_1304.field_6172, class_1304.field_6174, class_1304.field_6169};
    private boolean applied = false;
    private boolean registered = false;

    @Override
    public void apply() {
        this.applied = true;
        if (!this.registered) {
            this.registered = true;
            Agnos.runForCommandRegistration((dispatcher, dedi) -> {
                dispatcher.register(this.buildCommand("hidearmor", true));
                dispatcher.register(this.buildCommand("showarmor", false));
            });
        }
    }

    private LiteralArgumentBuilder<class_2168> buildCommand(String cmd, boolean hidden) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)cmd).requires(scs -> MixinConfigPlugin.isEnabled("*.hide_armor") && this.applied)).then(class_2170.method_9247((String)"all").executes(c -> this.setArmorHidden((CommandContext<class_2168>)c, hidden, ALL_ARMOR)))).then(class_2170.method_9247((String)"head").executes(c -> this.setArmorHidden((CommandContext<class_2168>)c, hidden, class_1304.field_6169)))).then(class_2170.method_9247((String)"chest").executes(c -> this.setArmorHidden((CommandContext<class_2168>)c, hidden, class_1304.field_6174)))).then(class_2170.method_9247((String)"legs").executes(c -> this.setArmorHidden((CommandContext<class_2168>)c, hidden, class_1304.field_6172)))).then(class_2170.method_9247((String)"feet").executes(c -> this.setArmorHidden((CommandContext<class_2168>)c, hidden, class_1304.field_6166)))).then(class_2170.method_9247((String)"!head").executes(c -> this.setArmorHidden((CommandContext<class_2168>)c, hidden, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166)))).then(class_2170.method_9247((String)"!chest").executes(c -> this.setArmorHidden((CommandContext<class_2168>)c, hidden, class_1304.field_6169, class_1304.field_6172, class_1304.field_6166)))).then(class_2170.method_9247((String)"!legs").executes(c -> this.setArmorHidden((CommandContext<class_2168>)c, hidden, class_1304.field_6174, class_1304.field_6169, class_1304.field_6166)))).then(class_2170.method_9247((String)"!feet").executes(c -> this.setArmorHidden((CommandContext<class_2168>)c, hidden, class_1304.field_6174, class_1304.field_6172, class_1304.field_6169)))).executes(c -> this.setArmorHidden((CommandContext<class_2168>)c, hidden, ALL_ARMOR));
    }

    private int setArmorHidden(CommandContext<class_2168> c, boolean hidden, class_1304 ... slots) throws CommandSyntaxException {
        class_3222 ent = ((class_2168)c.getSource()).method_9207();
        if (ent instanceof GetSuppressedSlots) {
            String verb;
            ArrayList li = Lists.newArrayList();
            int amt = 0;
            for (class_1304 es : slots) {
                if (hidden) {
                    if (!((GetSuppressedSlots)ent).fabrication$getSuppressedSlots().add(es)) continue;
                    ++amt;
                    li.add(Pair.of((Object)es, (Object)class_1799.field_8037));
                    continue;
                }
                if (!((GetSuppressedSlots)ent).fabrication$getSuppressedSlots().remove(es)) continue;
                ++amt;
                li.add(Pair.of((Object)es, (Object)ent.method_6118(es)));
            }
            ((class_3218)ent.field_6002).method_14178().method_18754((class_1297)ent, (class_2596)new class_2744(ent.method_5628(), (List)li));
            FeatureHideArmor.sendSuppressedSlotsForSelf(ent);
            String string = verb = hidden ? "hidden" : "shown";
            if (amt == 4) {
                ((class_2168)c.getSource()).method_9226((class_2561)new class_2585("All armor slots " + verb), false);
            } else if (amt > 1) {
                ((class_2168)c.getSource()).method_9226((class_2561)new class_2585(amt + " armor slots " + verb), false);
            } else if (amt > 0) {
                ((class_2168)c.getSource()).method_9226((class_2561)new class_2585("1 armor slot " + verb), false);
            } else {
                ((class_2168)c.getSource()).method_9226((class_2561)new class_2585("All specified slots are already " + verb), false);
            }
        } else {
            ((class_2168)c.getSource()).method_9226((class_2561)new class_2585("Patch error!"), false);
        }
        return 1;
    }

    @Override
    public boolean undo() {
        this.applied = false;
        return true;
    }

    @Override
    public String getConfigKey() {
        return "*.hide_armor";
    }

    public static List<Pair<class_1304, class_1799>> muddle(class_1297 entity, List<Pair<class_1304, class_1799>> equipmentList) {
        if (MixinConfigPlugin.isEnabled("*.hide_armor") && entity instanceof GetSuppressedSlots) {
            Set<class_1304> slots = ((GetSuppressedSlots)entity).fabrication$getSuppressedSlots();
            return Lists.transform(equipmentList, pair -> slots.contains(pair.getFirst()) ? Pair.of((Object)((class_1304)pair.getFirst()), (Object)class_1799.field_8037) : pair);
        }
        return equipmentList;
    }

    public static void sendSuppressedSlotsForSelf(class_3222 ent) {
        if (ent instanceof SetFabricationConfigAware && ((SetFabricationConfigAware)ent).fabrication$isConfigAware()) {
            class_2540 data = new class_2540(Unpooled.buffer());
            int bits = 0;
            for (class_1304 es : ((GetSuppressedSlots)ent).fabrication$getSuppressedSlots()) {
                bits |= 1 << es.method_5927();
            }
            data.method_10804(bits);
            class_2658 pkt = new class_2658(new class_2960("fabrication", "hide_armor"), data);
            ent.field_13987.method_14364((class_2596)pkt);
        }
    }
}

