/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Feature;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import com.unascribed.fabrication.support.SpecialEligibility;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;

@EligibleIf(configEnabled="*.mods_command", specialConditions={SpecialEligibility.NOT_FORGE})
public class FeatureModsCommandFabric
implements Feature {
    private boolean applied = false;

    @Override
    public void apply() {
        if (this.applied) {
            return;
        }
        this.applied = true;
        CommandRegistrationCallback.EVENT.register((dispatcher, dedi) -> {
            try {
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"mods").requires(s -> MixinConfigPlugin.isEnabled("*.mods_command"))).then(LiteralArgumentBuilder.literal((String)"all").executes(c -> {
                    this.sendMods((CommandContext<class_2168>)c, true);
                    return 1;
                }))).executes(c -> {
                    this.sendMods((CommandContext<class_2168>)c, false);
                    return 1;
                }));
                try {
                    Class.forName("org.bukkit.Bukkit");
                }
                catch (Throwable t) {
                    dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"plugins").executes(c -> {
                        ((class_2168)c.getSource()).method_9226((class_2561)new class_2585("\u00a7cThis ain't no Bukkit!\nTry /mods"), false);
                        return 1;
                    }));
                }
            }
            catch (Throwable t) {
                FabricationMod.featureError(this, t);
            }
        });
    }

    @Override
    public boolean undo() {
        return true;
    }

    private void sendMods(CommandContext<class_2168> c, boolean all) {
        class_2585 mt = new class_2585("Mods: ");
        boolean first = true;
        for (ModContainer mc : FabricLoader.getInstance().getAllMods()) {
            ModMetadata mm = mc.getMetadata();
            if (mm.getId().equals("minecraft") || mm.getId().startsWith("fabric-") && !all) continue;
            if (!first) {
                mt.method_10852((class_2561)new class_2585(", ").method_10862(class_2583.field_24360.method_10977(class_124.field_1070)));
            } else {
                first = false;
            }
            StringBuilder desc = new StringBuilder(mm.getDescription().replace("\r", ""));
            if (desc.length() > 0) {
                desc.append("\n\n");
            }
            if (!mm.getAuthors().isEmpty()) {
                desc.append("Authors: ");
                boolean firstAuthor = true;
                for (Person p : mm.getAuthors()) {
                    if (!firstAuthor) {
                        desc.append(", ");
                    } else {
                        firstAuthor = false;
                    }
                    desc.append(p.getName());
                }
                desc.append("\n");
            }
            desc.append("ID: ");
            desc.append(mm.getId());
            class_2585 lt = new class_2585(mm.getName());
            class_2583 s = class_2583.field_24360.method_10977(class_124.field_1060).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(desc.toString())));
            if (mm.getContact() != null && mm.getContact().get("homepage").isPresent()) {
                s = s.method_10958(new class_2558(class_2558.class_2559.field_11749, (String)mm.getContact().get("homepage").get()));
            }
            lt.method_10862(s);
            mt.method_10852((class_2561)lt);
        }
        ((class_2168)c.getSource()).method_9226((class_2561)mt, false);
    }

    @Override
    public String getConfigKey() {
        return "*.mods_command";
    }
}

