/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.loaders;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.MoreFiles;
import com.google.common.io.Resources;
import com.ibm.icu.impl.locale.XCldrStub;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.QDIni;
import com.unascribed.fabrication.Resolvable;
import com.unascribed.fabrication.support.ConfigLoader;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_151;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

@EligibleIf(envMatches=Env.CLIENT)
public class LoaderBlockLogo
implements ConfigLoader {
    public static boolean invalidated = true;
    public static boolean unrecoverableLoadError = false;
    public static class_1011 image;
    public static BooleanSupplier getReverse;
    public static final Map<Integer, Supplier<class_2680>> colorToState;
    public static boolean sound;

    @Override
    public void load(Path configDir, QDIni config, boolean loadError) {
        colorToState.clear();
        invalidated = true;
        unrecoverableLoadError = false;
        if (image != null) {
            image.close();
            image = null;
        }
        getReverse = config.getEnum((String)"general.reverse", Reverse.class).orElse((Reverse)Reverse.FALSE).sup;
        sound = config.getBoolean("general.sound").orElse(false);
        if (loadError) {
            unrecoverableLoadError = true;
            return;
        }
        FabLog.timeAndCountWarnings("Loading of block_logo.png", () -> {
            Path imageFile = configDir.resolve("block_logo.png");
            if (!Files.exists(imageFile, new LinkOption[0])) {
                try {
                    Resources.asByteSource((URL)MixinConfigPlugin.class.getClassLoader().getResource("default_block_logo.png")).copyTo(MoreFiles.asByteSink((Path)imageFile, (OpenOption[])new OpenOption[0]));
                }
                catch (IOException e) {
                    FabLog.warn("Failed to write default block logo", e);
                    unrecoverableLoadError = true;
                    return;
                }
            }
            try (InputStream is = Files.newInputStream(imageFile, new OpenOption[0]);){
                image = class_1011.method_4309((InputStream)is);
            }
            catch (IOException e) {
                FabLog.warn("Failed to load block logo", e);
                unrecoverableLoadError = true;
                return;
            }
            for (int x = 0; x < image.method_4307(); ++x) {
                for (int y = 0; y < image.method_4323(); ++y) {
                    int color = image.method_4315(x, y);
                    int alpha = color >> 24 & 0xFF;
                    if (alpha <= 0 || alpha >= 255) continue;
                    FabLog.warn("At " + x + ", " + y + " in block_logo.png: Found a pixel that is not fully transparent or fully opaque; ignoring it");
                    image.method_4305(x, y, 0);
                }
            }
        });
        for (String key : config.keySet()) {
            if (!key.startsWith("pixels.")) continue;
            String color = key.substring(7);
            if (color.length() != 6) {
                FabLog.warn(key + " must be a 24-bit hex color like FF0000 (got " + color + ") at " + config.getBlame(key));
                continue;
            }
            int colorInt = Integer.parseInt(color, 16);
            int swapped = colorInt & 0xFF00;
            swapped |= (colorInt & 0xFF0000) >> 16;
            swapped |= (colorInt & 0xFF) << 16;
            ArrayList blocks = Lists.newArrayList();
            for (String s : XCldrStub.Splitter.on((char)' ').split(config.get(key).orElse(""))) {
                try {
                    blocks.add(Resolvable.of(new class_2960(s), class_2378.field_11146));
                }
                catch (class_151 e) {
                    FabLog.warn(s + " is not a valid identifier at " + config.getBlame(key));
                }
            }
            colorToState.put(swapped, () -> {
                Resolvable res = (Resolvable)blocks.get(ThreadLocalRandom.current().nextInt(blocks.size()));
                Optional opt = res.get();
                if (!opt.isPresent()) {
                    FabLog.warn("Couldn't find a block with ID " + res.getId() + " when rendering block logo");
                    return class_2246.field_10124.method_9564();
                }
                return ((class_2248)opt.get()).method_9564();
            });
        }
        for (int x = 0; x < image.method_4307(); ++x) {
            for (int y = 0; y < image.method_4323(); ++y) {
                int color = image.method_4315(x, y);
                int alpha = color >> 24 & 0xFF;
                if (alpha != 255 || colorToState.containsKey(color &= 0xFFFFFF)) continue;
                FabLog.warn("At " + x + ", " + y + " in block_logo.png: Found a pixel with a color that isn't in the config: " + Integer.toHexString(color | 0xFF000000).substring(2).toUpperCase(Locale.ROOT) + "; ignoring it");
                image.method_4305(x, y, 0);
            }
        }
    }

    @Override
    public String getConfigName() {
        return "block_logo";
    }

    static {
        getReverse = () -> false;
        colorToState = Maps.newHashMap();
        sound = false;
    }

    public static enum Reverse {
        FALSE(() -> false),
        TRUE(() -> true),
        RANDOM(() -> ThreadLocalRandom.current().nextBoolean());

        public final BooleanSupplier sup;

        private Reverse(BooleanSupplier sup) {
            this.sup = sup;
        }
    }
}

