/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.loaders;

import com.google.common.collect.Lists;
import com.unascribed.fabrication.QDIni;
import com.unascribed.fabrication.support.ConfigLoader;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.Trilean;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

@EligibleIf(envMatches=Env.CLIENT)
public class LoaderClassicBlockDrops
implements ConfigLoader {
    public static final List<Function<class_2960, Trilean>> rules = Lists.newArrayList();
    private static final Map<class_2248, Boolean> cache = new WeakHashMap<class_2248, Boolean>();

    public static boolean isSafe(class_2248 b) {
        if (cache.containsKey(b)) {
            return cache.get(b);
        }
        class_2960 id = class_2378.field_11146.method_10221((Object)b);
        if (id == null) {
            return false;
        }
        for (Function<class_2960, Trilean> rule : rules) {
            Trilean t = rule.apply(id);
            if (t == Trilean.UNSET) continue;
            boolean r = t.resolve(true);
            cache.put(b, r);
            return r;
        }
        cache.put(b, false);
        return false;
    }

    @Override
    public void load(Path configDir, QDIni config, boolean loadError) {
        rules.clear();
        cache.clear();
        for (String k : config.keySet()) {
            if (k.startsWith("@heuristics.")) {
                if (k.contains("\\E") || k.contains("\\Q")) {
                    throw new IllegalArgumentException("No.");
                }
                StringBuffer buf = new StringBuffer("^\\Q");
                Matcher m = Pattern.compile("*", 16).matcher(k.substring(12));
                while (m.find()) {
                    m.appendReplacement(buf, "\\\\E.*\\\\Q");
                }
                m.appendTail(buf);
                buf.append("\\E$");
                Pattern p = Pattern.compile(buf.toString());
                Optional<Boolean> valueOpt = config.getBoolean(k);
                if (!valueOpt.isPresent()) continue;
                boolean value = valueOpt.get();
                rules.add(id -> {
                    if (p.matcher(id.method_12832()).matches()) {
                        return value ? Trilean.TRUE : Trilean.FALSE;
                    }
                    return Trilean.UNSET;
                });
                continue;
            }
            Optional<Boolean> valueOpt = config.getBoolean(k);
            if (!valueOpt.isPresent()) continue;
            boolean value = valueOpt.get();
            rules.add(id -> {
                if (id.toString().equals(k)) {
                    return value ? Trilean.TRUE : Trilean.FALSE;
                }
                return Trilean.UNSET;
            });
        }
    }

    @Override
    public String getConfigName() {
        return "classic_block_drops";
    }
}

