/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.loaders;

import com.google.common.base.Function;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.QDIni;
import com.unascribed.fabrication.support.ConfigLoader;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2499;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_5414;
import org.jetbrains.annotations.Nullable;

public class LoaderDimensionalTools
implements ConfigLoader {
    public static final SetMultimap<class_2960, MohsIdentifier> blockAssociations = HashMultimap.create();
    public static final SetMultimap<class_2960, MohsIdentifier> blockTagAssociations = HashMultimap.create();
    public static final SetMultimap<class_2960, MohsIdentifier> toolAssociations = HashMultimap.create();
    public static final SetMultimap<class_2960, MohsIdentifier> toolTagAssociations = HashMultimap.create();
    public static final SetMultimap<class_2960, @Nullable MohsIdentifier> ingredientAssociations = HashMultimap.create();
    public static final SetMultimap<class_2960, @Nullable MohsIdentifier> ingredientTagAssociations = HashMultimap.create();
    public static final Set<class_2960> substitutableItems = Sets.newHashSet();
    public static final Set<class_2960> substitutableItemTags = Sets.newHashSet();
    public static final List<NameSubstitution> nameSubstitutions = Lists.newArrayList();
    public static final Table<MohsIdentifier, class_2960, Integer> oneToOneDamageFactors = HashBasedTable.create();
    public static final Map<class_2960, Integer> foreignOnNativeDamageFactors = Maps.newHashMap();
    public static final Map<class_2960, Integer> foreignHardOnNativeDamageFactors = Maps.newHashMap();
    public static final Map<MohsIdentifier, Integer> nativeOnForeignDamageFactors = Maps.newHashMap();

    public static int getDamageFactor(@Nullable MohsIdentifier tool, @Nullable class_2960 block) {
        if (tool != null) {
            if (oneToOneDamageFactors.contains((Object)tool, (Object)block)) {
                return (Integer)oneToOneDamageFactors.get((Object)tool, (Object)block);
            }
            MohsIdentifier toolSoft = tool.asSoft();
            if (tool.isHard() && oneToOneDamageFactors.contains((Object)toolSoft, (Object)block)) {
                return (Integer)oneToOneDamageFactors.get((Object)toolSoft, (Object)block);
            }
            if (!tool.getId().equals((Object)block)) {
                if (nativeOnForeignDamageFactors.containsKey(tool)) {
                    return nativeOnForeignDamageFactors.get(tool);
                }
                if (tool.isHard() && nativeOnForeignDamageFactors.containsKey(toolSoft)) {
                    return nativeOnForeignDamageFactors.get(toolSoft);
                }
            }
        }
        if (tool == null || !tool.getId().equals((Object)block)) {
            if (tool != null && tool.isHard() && foreignHardOnNativeDamageFactors.containsKey(block)) {
                return foreignHardOnNativeDamageFactors.get(block);
            }
            if (foreignOnNativeDamageFactors.containsKey(block)) {
                return foreignOnNativeDamageFactors.get(block);
            }
        }
        return 1;
    }

    public static Set<MohsIdentifier> getAssociatedDimensionsForTool(class_1799 stack) {
        HashSet dims = LoaderDimensionalTools.processTags(toolAssociations.get((Object)class_2378.field_11142.method_10221((Object)stack.method_7909())), toolTagAssociations, class_3489.method_15106(), arg_0 -> ((class_1792)stack.method_7909()).method_7855(arg_0));
        if (stack.method_7985()) {
            if (stack.method_7969().method_10577("fabrication:ActLikeGold")) {
                dims = Sets.newHashSet(dims);
                dims.add(new MohsIdentifier(true, class_2874.field_26753));
            }
            if (stack.method_7969().method_10573("fabrication:HonoraryDimensions", 9)) {
                dims = Sets.newHashSet((Iterable)dims);
                class_2499 li = stack.method_7969().method_10554("fabrication:HonoraryDimensions", 8);
                for (int i = 0; i < li.size(); ++i) {
                    try {
                        dims.add(MohsIdentifier.parse(li.method_10608(i)));
                        continue;
                    }
                    catch (class_151 e) {
                        FabLog.warn("Bad honorary dimension " + li.method_10608(i) + " in stack " + class_2378.field_11142.method_10221((Object)stack.method_7909()) + stack.method_7969());
                    }
                }
            }
        }
        return dims;
    }

    public static Set<MohsIdentifier> getAssociatedDimensionsForIngredient(class_1799 stack) {
        return LoaderDimensionalTools.processTags(ingredientAssociations.get((Object)class_2378.field_11142.method_10221((Object)stack.method_7909())), ingredientTagAssociations, class_3489.method_15106(), arg_0 -> ((class_1792)stack.method_7909()).method_7855(arg_0));
    }

    public static Set<MohsIdentifier> getAssociatedDimensions(class_2248 block) {
        return LoaderDimensionalTools.processTags(blockAssociations.get((Object)class_2378.field_11146.method_10221((Object)block)), blockTagAssociations, class_3481.method_15073(), arg_0 -> ((class_2248)block).method_9525(arg_0));
    }

    private static <T, U> Set<U> processTags(Set<U> out, SetMultimap<class_2960, U> assoc, class_5414<T> tagGroup, Predicate<class_3494<T>> isIn) {
        boolean cloned = false;
        for (Map.Entry en : assoc.entries()) {
            class_3494 tag = tagGroup.method_30210((class_2960)en.getKey());
            if (tag == null || !isIn.test(tag)) continue;
            if (!cloned) {
                out = Sets.newHashSet(out);
                cloned = true;
            }
            out.add(en.getValue());
        }
        return out;
    }

    public static boolean isSubstitutable(class_1792 item) {
        if (substitutableItems.contains(class_2378.field_11142.method_10221((Object)item))) {
            return true;
        }
        for (class_2960 id : substitutableItemTags) {
            class_3494 tag = class_3489.method_15106().method_30210(id);
            if (tag == null || !item.method_7855(tag)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void load(Path configDir, QDIni config, boolean loadError) {
        LoaderDimensionalTools.blockAssociations.clear();
        LoaderDimensionalTools.blockTagAssociations.clear();
        LoaderDimensionalTools.toolAssociations.clear();
        LoaderDimensionalTools.toolTagAssociations.clear();
        LoaderDimensionalTools.ingredientAssociations.clear();
        LoaderDimensionalTools.ingredientTagAssociations.clear();
        LoaderDimensionalTools.substitutableItems.clear();
        LoaderDimensionalTools.substitutableItemTags.clear();
        LoaderDimensionalTools.nameSubstitutions.clear();
        LoaderDimensionalTools.oneToOneDamageFactors.clear();
        LoaderDimensionalTools.foreignOnNativeDamageFactors.clear();
        LoaderDimensionalTools.foreignHardOnNativeDamageFactors.clear();
        LoaderDimensionalTools.nativeOnForeignDamageFactors.clear();
        var4_4 = config.keySet().iterator();
        while (var4_4.hasNext()) {
            block30: {
                block33: {
                    block32: {
                        block31: {
                            block29: {
                                realKey = key = var4_4.next();
                                defaultNamespace = "minecraft";
                                colon = key.indexOf(58);
                                if (colon != -1) {
                                    dot = key.indexOf(46);
                                    defaultNamespace = key.substring(dot + 1, colon);
                                    key = key.substring(0, dot + 1) + key.substring(colon + 1);
                                }
                                starValid = false;
                                tagTargetMohs = null;
                                targetMohs = null;
                                tagTarget = null;
                                target = null;
                                setTagTarget = null;
                                setTarget = null;
                                if (!key.startsWith("blocks.")) break block29;
                                key = key.substring(7);
                                targetMohs = LoaderDimensionalTools.blockAssociations;
                                tagTargetMohs = LoaderDimensionalTools.blockTagAssociations;
                                break block30;
                            }
                            if (!key.startsWith("tools.")) break block31;
                            key = key.substring(6);
                            targetMohs = LoaderDimensionalTools.toolAssociations;
                            tagTargetMohs = LoaderDimensionalTools.toolTagAssociations;
                            break block30;
                        }
                        if (!key.startsWith("materials.")) break block32;
                        key = key.substring(10);
                        targetMohs = LoaderDimensionalTools.ingredientAssociations;
                        tagTargetMohs = LoaderDimensionalTools.ingredientTagAssociations;
                        starValid = true;
                        break block30;
                    }
                    if (!key.startsWith("substitutable.")) break block33;
                    key = key.substring(14);
                    setTarget = LoaderDimensionalTools.substitutableItems;
                    setTagTarget = LoaderDimensionalTools.substitutableItemTags;
                    break block30;
                }
                if (key.startsWith("name_substitutions.")) {
                    slash = (key = key.substring(19)).indexOf(47);
                    if (slash == -1) {
                        FabLog.warn(key + " is not a valid substitution at " + config.getBlame(realKey, 0));
                        continue;
                    }
                    dim = key.substring(0, slash);
                    find = key.substring(slash + 1);
                    try {
                        dimId = FabricationMod.createIdWithCustomDefault(defaultNamespace, dim);
                    }
                    catch (class_151 e) {
                        FabLog.warn(key + " is not a valid identifier at " + config.getBlame(realKey, 0));
                        continue;
                    }
                    for (String replace : config.getAll(realKey)) {
                        LoaderDimensionalTools.nameSubstitutions.add(new NameSubstitution(dimId, find, replace));
                    }
                    continue;
                }
                if (!key.startsWith("damage_factors.")) break block30;
                angle = (key = key.substring(15)).indexOf(62);
                if (angle == -1) {
                    FabLog.warn(key + " is not a valid damage factor mapping at " + config.getBlame(realKey));
                    continue;
                }
                tool = key.substring(0, angle);
                toolHard = tool.endsWith("!");
                if (toolHard) {
                    tool = tool.substring(0, tool.length() - 1);
                }
                toolId = "*".equals(tool) != false ? null : FabricationMod.createIdWithCustomDefault(defaultNamespace, tool);
                dim = key.substring(angle + 1);
                v0 = dimId = "*".equals(dim) != false ? null : FabricationMod.createIdWithCustomDefault(defaultNamespace, dim);
                if (toolId == null && dimId == null) {
                    FabLog.warn(key + " is not a valid damage factor mapping at " + config.getBlame(realKey));
                    continue;
                }
                valueOpt = config.getInt(realKey);
                if (valueOpt.isPresent()) ** GOTO lbl95
                if ("Infinity".equals(config.get(realKey))) {
                    value = 0x7FFFFFFF;
                } else {
                    FabLog.warn(config.get(realKey) + " is not a valid damage factor value at " + config.getBlame(realKey));
                    continue;
lbl95:
                    // 1 sources

                    value = valueOpt.get();
                }
                if (toolId == null) {
                    (toolHard != false ? LoaderDimensionalTools.foreignHardOnNativeDamageFactors : LoaderDimensionalTools.foreignOnNativeDamageFactors).put(dimId, value);
                    continue;
                }
                if (dimId == null) {
                    LoaderDimensionalTools.nativeOnForeignDamageFactors.put(new MohsIdentifier(toolHard, toolId), value);
                    continue;
                }
                LoaderDimensionalTools.oneToOneDamageFactors.put((Object)new MohsIdentifier(toolHard, toolId), (Object)dimId, (Object)value);
                continue;
            }
            if (targetMohs != null || target != null || setTarget != null) {
                tag = key.startsWith("#");
                if (tag) {
                    key = key.substring(1);
                }
                try {
                    keyId = FabricationMod.createIdWithCustomDefault(defaultNamespace, key);
                }
                catch (class_151 e) {
                    FabLog.warn(key + " is not a valid identifier at " + config.getBlame(realKey, 0));
                    continue;
                }
                if (targetMohs != null) {
                    i = 0;
                    for (String s : config.getAll(realKey)) {
                        hard = s.endsWith("!");
                        if (hard && targetMohs == null) {
                            FabLog.warn(s + " is not a valid identifier at " + config.getBlame(realKey, i));
                            continue;
                        }
                        if (hard) {
                            s = s.substring(0, s.length() - 1);
                        }
                        wrapper = targetMohs != null ? (Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$load$0(boolean net.minecraft.class_2960 ), (Lnet/minecraft/class_2960;)Ljava/lang/Object;)((boolean)hard) : (Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$load$1(net.minecraft.class_2960 ), (Lnet/minecraft/class_2960;)Ljava/lang/Object;)();
                        if (tag) {
                            tgt = targetMohs != null ? tagTargetMohs : tagTarget;
                        } else {
                            v1 /* !! */  = tgt = targetMohs != null ? targetMohs : tagTarget;
                        }
                        if (s.equals("*")) {
                            if (!starValid) {
                                FabLog.warn(s + " is not a valid identifier at " + config.getBlame(realKey, i));
                                continue;
                            }
                            tgt.put((Object)keyId, null);
                            continue;
                        }
                        try {
                            valueId = FabricationMod.createIdWithCustomDefault(defaultNamespace, s);
                            tgt.put((Object)keyId, wrapper.apply((Object)valueId));
                        }
                        catch (class_151 e) {
                            FabLog.warn(s + " is not a valid identifier at " + config.getBlame(realKey, i));
                            continue;
                        }
                        ++i;
                    }
                    continue;
                }
                if (setTarget == null || !config.getBoolean(realKey).orElse(false).booleanValue()) continue;
                (tag != false ? setTagTarget : setTarget).add(keyId);
                continue;
            }
            for (i = 0; i < config.getAll(realKey).size(); ++i) {
                FabLog.warn("Don't know what to do with " + config.getBlame(realKey, i));
            }
        }
    }

    @Override
    public String getConfigName() {
        return "dimensional_tools";
    }

    private static /* synthetic */ Object lambda$load$1(class_2960 id) {
        return id;
    }

    private static /* synthetic */ Object lambda$load$0(boolean hard, class_2960 id) {
        return new MohsIdentifier(hard, id);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    private static @interface DimensionId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    private static @interface ItemTagId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    private static @interface ItemId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    private static @interface BlockTagId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    private static @interface BlockId {
    }

    public static final class NameSubstitution {
        public final class_2960 dimId;
        public final String find;
        public final String replace;

        private NameSubstitution(class_2960 dimId, String find, String replace) {
            this.dimId = dimId;
            this.find = find;
            this.replace = replace;
        }
    }

    public static final class MohsIdentifier {
        private final boolean hard;
        private final class_2960 id;

        public MohsIdentifier(boolean hard, class_2960 id) {
            this.hard = hard;
            this.id = id;
        }

        public static MohsIdentifier createHard(class_2960 id) {
            return new MohsIdentifier(true, id);
        }

        public static MohsIdentifier createSoft(class_2960 id) {
            return new MohsIdentifier(false, id);
        }

        public static MohsIdentifier parse(String s) {
            boolean hard = s.endsWith("!");
            if (hard) {
                s = s.substring(0, s.length() - 1);
            }
            return new MohsIdentifier(hard, new class_2960(s));
        }

        public MohsIdentifier asSoft() {
            if (!this.hard) {
                return this;
            }
            return new MohsIdentifier(false, this.id);
        }

        public boolean isHard() {
            return this.hard;
        }

        public class_2960 getId() {
            return this.id;
        }

        public String getPath() {
            return this.id.method_12832();
        }

        public String getNamespace() {
            return this.id.method_12836();
        }

        public String toString() {
            return this.id.toString() + (this.hard ? "!" : "");
        }

        public int hashCode() {
            return Objects.hash(this.id, this.hard);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MohsIdentifier that = (MohsIdentifier)obj;
            if (this.hard != that.hard) {
                return false;
            }
            return Objects.equals(this.id, that.id);
        }
    }
}

