/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.b_utility.item_despawn;

import com.google.common.primitives.Ints;
import com.unascribed.fabrication.ParsedTime;
import com.unascribed.fabrication.Resolvable;
import com.unascribed.fabrication.interfaces.SetFromPlayerDeath;
import com.unascribed.fabrication.loaders.LoaderItemDespawn;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_2777;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@EligibleIf(configEnabled="*.item_despawn")
@Mixin(value={class_1542.class})
public abstract class MixinItemEntity
extends class_1297
implements SetFromPlayerDeath {
    private long fabrication$trueAge;
    private int fabrication$extraTime;
    private boolean fabrication$invincible;
    private boolean fabrication$fromPlayerDeath;
    @Shadow
    private int field_7204;
    @Shadow
    private UUID field_7200;

    public MixinItemEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    public abstract class_1799 method_6983();

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    public void tickHead(CallbackInfo ci) {
        if (this.fabrication$extraTime > 0) {
            --this.fabrication$extraTime;
            --this.field_7204;
        }
        ++this.fabrication$trueAge;
        if (this.method_19538().field_1351 < -32.0 && this.fabrication$invincible) {
            this.method_20620(this.method_19538().field_1352, 1.0, this.method_19538().field_1350);
            this.method_18800(0.0, 0.0, 0.0);
            if (!this.field_6002.field_9236) {
                ((class_3218)this.field_6002).method_14178().method_18751((class_1297)this, (class_2596)new class_2777((class_1297)this));
                ((class_3218)this.field_6002).method_14178().method_18751((class_1297)this, (class_2596)new class_2743((class_1297)this));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, cancellable=true)
    public void damage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> ci) {
        if (this.fabrication$invincible || MixinConfigPlugin.isEnabled("*.item_despawn") && this.field_6002.field_9236) {
            ci.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setStack(Lnet/minecraft/item/ItemStack;)V"})
    public void setStack(class_1799 stack, CallbackInfo ci) {
        this.calculateDespawn();
    }

    @Inject(at={@At(value="TAIL")}, method={"setThrower(Ljava/util/UUID;)V"})
    public void setThrower(UUID id, CallbackInfo ci) {
        this.calculateDespawn();
    }

    @ModifyConstant(constant={@Constant(intValue=-32768)}, method={"canMerge()Z"})
    public int modifyIllegalAge(int orig) {
        return this.fabrication$invincible ? this.field_7204 - 1 : orig;
    }

    @Override
    public void fabrication$setFromPlayerDeath(boolean b) {
        this.fabrication$fromPlayerDeath = b;
        this.calculateDespawn();
    }

    @Unique
    private void calculateDespawn() {
        if (this.field_6002.field_9236) {
            return;
        }
        boolean debug = false;
        class_1799 stack = this.method_6983();
        ParsedTime time = ParsedTime.UNSET;
        ParsedTime itemTime = LoaderItemDespawn.itemDespawns.get(Resolvable.mapKey(stack.method_7909(), class_2378.field_11142));
        if (itemTime != null) {
            time = itemTime;
        }
        if (!time.priority) {
            for (class_1887 class_18872 : class_1890.method_8222((class_1799)stack).keySet()) {
                ParsedTime enchTime;
                if (class_18872.method_8195()) {
                    if (LoaderItemDespawn.curseDespawn.overshadows(time)) {
                        time = LoaderItemDespawn.curseDespawn;
                    }
                } else {
                    if (LoaderItemDespawn.normalEnchDespawn.overshadows(time)) {
                        time = LoaderItemDespawn.normalEnchDespawn;
                    }
                    if (class_18872.method_8193() && LoaderItemDespawn.treasureDespawn.overshadows(time)) {
                        time = LoaderItemDespawn.treasureDespawn;
                    }
                }
                if ((enchTime = LoaderItemDespawn.enchDespawns.get(Resolvable.mapKey(class_18872, class_2378.field_11160))) == null || !enchTime.overshadows(time)) continue;
                time = enchTime;
            }
            for (Map.Entry entry : LoaderItemDespawn.tagDespawns.entrySet()) {
                class_3494 itemTag = class_3489.method_15106().method_30210((class_2960)entry.getKey());
                if (itemTag != null && itemTag.method_15141((Object)stack.method_7909()) && ((ParsedTime)entry.getValue()).overshadows(time)) {
                    time = (ParsedTime)entry.getValue();
                }
                if (!(stack.method_7909() instanceof class_1747)) continue;
                class_1747 bi = (class_1747)stack.method_7909();
                class_3494 blockTag = class_3481.method_15073().method_30210((class_2960)entry.getKey());
                if (blockTag == null || !blockTag.method_15141((Object)bi.method_7711()) || !((ParsedTime)entry.getValue()).overshadows(time)) continue;
                time = (ParsedTime)entry.getValue();
            }
            if (stack.method_7985()) {
                for (Map.Entry entry : LoaderItemDespawn.nbtBools.entrySet()) {
                    if (!stack.method_7969().method_10577((String)entry.getKey()) || !((ParsedTime)entry.getValue()).overshadows(time)) continue;
                    time = (ParsedTime)entry.getValue();
                }
            }
        }
        if (this.fabrication$fromPlayerDeath && LoaderItemDespawn.playerDeathDespawn.overshadows(time)) {
            time = LoaderItemDespawn.playerDeathDespawn;
        }
        if (time == ParsedTime.UNSET) {
            time = this.field_7200 == null ? LoaderItemDespawn.dropsDespawn : LoaderItemDespawn.defaultDespawn;
        }
        this.fabrication$invincible = false;
        if (time == ParsedTime.FOREVER) {
            this.fabrication$extraTime = 0;
            this.field_7204 = Short.MIN_VALUE;
        } else if (time == ParsedTime.INVINCIBLE) {
            this.fabrication$extraTime = 0;
            this.field_7204 = Short.MIN_VALUE;
            this.fabrication$invincible = true;
        } else if (time == ParsedTime.INSTANTLY) {
            this.method_5650();
        } else if (time == ParsedTime.UNSET) {
            this.fabrication$extraTime = 0;
        } else {
            int extra = time.timeInTicks - 6000;
            if ((extra -= Ints.saturatedCast((long)this.fabrication$trueAge)) < 0) {
                this.field_7204 = -extra;
                this.fabrication$extraTime = 0;
            } else {
                this.field_7204 = 0;
                this.fabrication$extraTime = extra;
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"writeCustomDataToTag(Lnet/minecraft/nbt/CompoundTag;)V"})
    public void writeCustomDataToTag(class_2487 tag, CallbackInfo ci) {
        if (this.fabrication$extraTime > 0) {
            tag.method_10569("fabrication:ExtraTime", this.fabrication$extraTime);
        }
        tag.method_10544("fabrication:TrueAge", this.fabrication$trueAge);
        if (this.fabrication$fromPlayerDeath) {
            tag.method_10556("fabrication:FromPlayerDeath", true);
        }
        if (this.fabrication$invincible) {
            tag.method_10556("fabrication:Invincible", true);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"readCustomDataFromTag(Lnet/minecraft/nbt/CompoundTag;)V"})
    public void readCustomDataFromTag(class_2487 tag, CallbackInfo ci) {
        this.fabrication$extraTime = tag.method_10550("fabrication:ExtraTime");
        this.fabrication$trueAge = tag.method_10537("fabrication:TrueAge");
        this.fabrication$fromPlayerDeath = tag.method_10577("fabrication:FromPlayerDeath");
        this.fabrication$invincible = tag.method_10577("fabrication:Invincible");
    }
}

