/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.b_utility.taggable_players;

import com.google.common.base.Enums;
import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.PlayerTag;
import com.unascribed.fabrication.interfaces.SetSaturation;
import com.unascribed.fabrication.interfaces.TaggablePlayer;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@EligibleIf(configEnabled="*.taggable_players")
@Mixin(value={class_3222.class})
public abstract class MixinServerPlayerEntity
extends class_1657
implements TaggablePlayer {
    private final EnumSet<PlayerTag> fabrication$tags = EnumSet.noneOf(PlayerTag.class);

    public MixinServerPlayerEntity(class_1937 world, class_2338 pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Override
    public Set<PlayerTag> fabrication$getTags() {
        return ImmutableSet.copyOf(this.fabrication$tags);
    }

    @Override
    public void fabrication$clearTags() {
        this.fabrication$tags.clear();
    }

    @Override
    public void fabrication$setTag(PlayerTag tag, boolean enabled) {
        if (enabled) {
            this.fabrication$tags.add(tag);
        } else if (this.fabrication$tags.remove((Object)tag)) {
            if (tag == PlayerTag.PERMANENT_DOLPHINS_GRACE && !this.needsReplacing(class_1294.field_5900)) {
                this.method_6016(class_1294.field_5900);
            } else if (tag == PlayerTag.PERMANENT_CONDUIT_POWER && !this.needsReplacing(class_1294.field_5927)) {
                this.method_6016(class_1294.field_5927);
            }
        }
    }

    @Override
    public boolean fabrication$hasTag(PlayerTag tag) {
        return this.fabrication$tags.contains((Object)tag);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void tick(CallbackInfo ci) {
        if (MixinConfigPlugin.isEnabled("*.taggable_players")) {
            if (this.fabrication$tags.contains((Object)PlayerTag.NO_HUNGER)) {
                this.method_7344().method_7580(this.method_6032() >= this.method_6063() ? 20 : 17);
                ((SetSaturation)this.method_7344()).fabrication$setSaturation(10.0f);
            }
            if (this.fabrication$tags.contains((Object)PlayerTag.CAN_BREATHE_WATER)) {
                this.method_5855(this.method_5748());
            }
            if (this.fabrication$tags.contains((Object)PlayerTag.PERMANENT_DOLPHINS_GRACE) && this.needsReplacing(class_1294.field_5900)) {
                this.method_6092(new class_1293(class_1294.field_5900, Integer.MAX_VALUE, 0, true, false));
            }
            if (this.fabrication$tags.contains((Object)PlayerTag.PERMANENT_CONDUIT_POWER) && this.needsReplacing(class_1294.field_5927)) {
                this.method_6092(new class_1293(class_1294.field_5927, Integer.MAX_VALUE, 0, true, false));
            }
        }
    }

    @Unique
    private boolean needsReplacing(class_1291 se) {
        return !this.method_6059(se) || !this.method_6112(se).method_5591() || this.method_6112(se).method_5592() || this.method_6112(se).method_5581();
    }

    @Inject(at={@At(value="HEAD")}, method={"copyFrom(Lnet/minecraft/server/network/ServerPlayerEntity;Z)V"}, cancellable=true)
    public void copyFrom(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        this.fabrication$tags.clear();
        this.fabrication$tags.addAll(((TaggablePlayer)oldPlayer).fabrication$getTags());
    }

    @Inject(at={@At(value="TAIL")}, method={"writeCustomDataToTag(Lnet/minecraft/nbt/CompoundTag;)V"})
    public void writeCustomDataToTag(class_2487 tag, CallbackInfo ci) {
        class_2499 li = new class_2499();
        for (PlayerTag pt : this.fabrication$tags) {
            li.add((Object)class_2519.method_23256((String)pt.lowerName()));
        }
        if (!li.isEmpty()) {
            tag.method_10566("fabrication:Tags", (class_2520)li);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"readCustomDataFromTag(Lnet/minecraft/nbt/CompoundTag;)V"})
    public void readCustomDataFromTag(class_2487 tag, CallbackInfo ci) {
        this.fabrication$tags.clear();
        class_2499 li = tag.method_10554("fabrication:Tags", 8);
        for (int i = 0; i < li.size(); ++i) {
            PlayerTag pt = (PlayerTag)((Object)Enums.getIfPresent(PlayerTag.class, (String)li.method_10608(i).toUpperCase(Locale.ROOT)).orNull());
            if (pt == null) {
                FabLog.warn("Unrecognized tag " + li.method_10608(i) + " while loading player");
                continue;
            }
            this.fabrication$tags.add(pt);
        }
    }
}

