/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.support;

import com.google.common.base.Charsets;
import com.google.common.base.Enums;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.common.io.MoreFiles;
import com.google.common.io.Resources;
import com.google.common.reflect.ClassPath;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.Analytics;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.QDIni;
import com.unascribed.fabrication.support.ConfigLoader;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.ResolvedTrilean;
import com.unascribed.fabrication.support.SpecialEligibility;
import com.unascribed.fabrication.support.Trilean;
import com.unascribed.fabrication.support.injection.FailsoftCallbackInjectionInfo;
import com.unascribed.fabrication.support.injection.FailsoftModifyArgInjectionInfo;
import com.unascribed.fabrication.support.injection.FailsoftModifyArgsInjectionInfo;
import com.unascribed.fabrication.support.injection.FailsoftModifyConstantInjectionInfo;
import com.unascribed.fabrication.support.injection.FailsoftModifyVariableInjectionInfo;
import com.unascribed.fabrication.support.injection.FailsoftRedirectInjectionInfo;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    private static final ImmutableSet<String> VIENNA_EXCEPTIONS = ImmutableSet.of((Object)"balance.infinity_mending", (Object)"balance.anvil_damage_only_on_fall", (Object)"balance.food_always_edible", (Object)"weird_tweaks.photoallergic_creepers", (Object)"weird_tweaks.photoresistant_mobs", (Object)"weird_tweaks.underwater_explosions", (Object[])new String[]{"woina.old_sheep_shear"});
    private static final ImmutableSet<String> NEVER_DEFAULT_EXCEPT_BURNT = ImmutableSet.of((Object)"minor_mechanics.spiders_cant_climb_while_wet");
    private static final ImmutableSet<String> NEVER_DEFAULT = ImmutableSet.of((Object)"tweaks.ghost_chest_woo_woo", (Object)"woina.janky_arm", (Object)"woina.flat_items", (Object)"woina.billboard_drops", (Object)"woina.oof", (Object)"woina.no_experience", (Object[])new String[]{"general.data_upload", "balance.loading_furnace_minecart"});
    private static final ImmutableSet<String> NON_TRILEANS = ImmutableSet.of((Object)"general.profile");
    private static final ImmutableSet<String> RUNTIME_CONFIGURABLE = ImmutableSet.of((Object)"general.reduced_motion", (Object)"general.data_upload", (Object)"minor_mechanics.feather_falling_five_damages_boots", (Object)"minor_mechanics.observers_see_entities_living_only");
    private static final ImmutableMap<Profile, ImmutableMap<String, Boolean>> defaultsByProfile;
    private static final ImmutableSet<String> validSections;
    private static final ImmutableSet<String> validKeys;
    private static final ImmutableMap<String, String> starMap;
    private static ImmutableMap<String, Boolean> defaults;
    private static final Set<SpecialEligibility> metSpecialEligibility;
    private static final List<ConfigLoader> loaders;
    private static Profile profile;
    private static QDIni rawConfig;
    private static Map<String, Trilean> config;
    private static final Set<String> failures;
    private static final Set<String> failuresReadOnly;
    private static final SetMultimap<String, String> configKeysForDiscoveredClasses;
    private static boolean analyticsSafe;
    public static boolean RUNTIME_CHECKS_WAS_ENABLED;

    public static void setMet(SpecialEligibility se, boolean met) {
        if (met) {
            metSpecialEligibility.add(se);
        } else {
            metSpecialEligibility.remove((Object)se);
        }
    }

    public static boolean isMet(SpecialEligibility se) {
        return metSpecialEligibility.contains((Object)se);
    }

    public static void submitConfigAnalytics() {
        Analytics.submitConfig();
        analyticsSafe = true;
    }

    public static String remap(String configKey) {
        return (String)starMap.getOrDefault((Object)configKey, (Object)configKey);
    }

    public static Set<String> getConfigKeysForDiscoveredClass(String clazz) {
        return Collections.unmodifiableSet(configKeysForDiscoveredClasses.get((Object)clazz.replace('/', '.')));
    }

    private static RuntimeException devError(String msg) {
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
            JFrame dummyFrame = new JFrame();
            dummyFrame.setIconImage(Toolkit.getDefaultToolkit().createImage(MixinConfigPlugin.class.getClassLoader().getResource("assets/fabrication/icon.png")));
            dummyFrame.setSize(1, 1);
            dummyFrame.setLocationRelativeTo(null);
            JOptionPane.showOptionDialog(dummyFrame, msg, "Fabrication Dev Error", 0, 0, null, new String[]{"Exit"}, "Exit");
            System.exit(1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new RuntimeException(msg);
    }

    public static boolean isEnabled(String configKey) {
        if (MixinConfigPlugin.isFailed(configKey)) {
            return false;
        }
        if (!validKeys.contains((Object)(configKey = MixinConfigPlugin.remap(configKey)))) {
            FabLog.error("Cannot look up value for config key " + configKey + " with no default");
            return false;
        }
        if (!config.containsKey(configKey)) {
            return defaults != null && (Boolean)defaults.get((Object)configKey) != false;
        }
        return config.get(configKey).resolve(defaults == null ? false : (Boolean)defaults.get((Object)configKey));
    }

    public static boolean isFailed(String configKey) {
        return failures.contains(MixinConfigPlugin.remap(configKey));
    }

    public static Trilean getValue(String configKey) {
        if (MixinConfigPlugin.isFailed(configKey)) {
            return Trilean.FALSE;
        }
        return config.getOrDefault(MixinConfigPlugin.remap(configKey), Trilean.UNSET);
    }

    public static ResolvedTrilean getResolvedValue(String configKey) {
        if (MixinConfigPlugin.isFailed(configKey)) {
            return ResolvedTrilean.FALSE;
        }
        return config.getOrDefault(MixinConfigPlugin.remap(configKey), Trilean.UNSET).resolveSemantically(defaults != null && (Boolean)defaults.get((Object)configKey) != false);
    }

    public static boolean isTrilean(String s) {
        return !NON_TRILEANS.contains((Object)s);
    }

    public static boolean isRuntimeConfigurable(String s) {
        return RUNTIME_CONFIGURABLE.contains((Object)s);
    }

    public static String getRawValue(String configKey) {
        configKey = MixinConfigPlugin.remap(MixinConfigPlugin.remap(configKey));
        return rawConfig.get(configKey).orElse(configKey.equals("general.profile") ? "light" : "");
    }

    public static boolean isValid(String configKey) {
        return validKeys.contains((Object)MixinConfigPlugin.remap(configKey));
    }

    public static boolean getDefault(String configKey) {
        return defaults != null && (Boolean)defaults.get((Object)MixinConfigPlugin.remap(configKey)) != false;
    }

    public static ImmutableSet<String> getAllKeys() {
        return validKeys;
    }

    public static ImmutableSet<String> getAllSections() {
        return validSections;
    }

    public static Set<String> getAllFailures() {
        return failuresReadOnly;
    }

    public static void addFailure(String configKey) {
        failures.add(MixinConfigPlugin.remap(configKey));
    }

    public static void set(final String configKey, final String newValue) {
        if (MixinConfigPlugin.isTrilean(configKey)) {
            switch (newValue) {
                case "true": 
                case "false": 
                case "unset": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Trilean key " + configKey + " cannot be set to " + newValue);
                }
            }
        } else if ("general.profile".equals(configKey) && !Enums.getIfPresent(Profile.class, (String)newValue.toUpperCase(Locale.ROOT)).isPresent()) {
            throw new IllegalArgumentException("Cannot set profile to " + newValue);
        }
        rawConfig.put(configKey, newValue);
        if ("general.profile".equals(configKey)) {
            profile = rawConfig.getEnum("general.profile", Profile.class).orElse(Profile.LIGHT);
            defaults = (ImmutableMap)defaultsByProfile.get((Object)profile);
        } else {
            config.put(configKey, Trilean.parseTrilean(newValue));
        }
        if ("general.data_upload".equals(configKey)) {
            if ("true".equals(newValue)) {
                Analytics.submit("enable_analytics");
                MixinConfigPlugin.submitConfigAnalytics();
            } else {
                Analytics.deleteId();
            }
        }
        Path configFile = Agnos.getConfigDir().resolve("fabrication").resolve("features.ini");
        Stopwatch watch = Stopwatch.createStarted();
        StringWriter sw = new StringWriter();
        try {
            QDIni.loadAndTransform(configFile, new QDIni.IniTransformer(){
                boolean found = false;
                boolean foundEmptySection = false;

                @Override
                public String transformLine(String path, String line) {
                    if (line != null && line.startsWith("[]")) {
                        this.foundEmptySection = true;
                    }
                    if ((line == null || line.equals("; Notices: (Do not edit anything past this line; it will be overwritten)")) && !this.found) {
                        this.found = true;
                        return (this.foundEmptySection ? "" : "[]\r\n") + "; Added by runtime reconfiguration as a last resort as this key could\r\n; not be found elsewhere in the file.\r\n" + configKey + "=" + newValue + "\r\n" + (line == null ? "" : "\r\n" + line);
                    }
                    return line;
                }

                @Override
                public String transformValueComment(String key, String value, String comment) {
                    return comment;
                }

                @Override
                public String transformValue(String key, String value) {
                    if (configKey.equals(key)) {
                        this.found = true;
                        return newValue;
                    }
                    return value;
                }
            }, (Writer)sw);
            Files.write(configFile, sw.toString().getBytes(Charsets.UTF_8), new OpenOption[0]);
            FabLog.info("Update of features.ini done in " + watch);
        }
        catch (IOException e) {
            FabLog.warn("Failed to update configuration file", e);
        }
    }

    public static void introduce(ConfigLoader ldr) {
        MixinConfigPlugin.load(ldr);
        loaders.add(ldr);
    }

    public static void reload() {
        FabLog.info("Reloading configs...");
        Path dir = Agnos.getConfigDir().resolve("fabrication");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e1) {
            throw new RuntimeException("Failed to create fabrication config directory", e1);
        }
        Path configFile = dir.resolve("features.ini");
        MixinConfigPlugin.checkForAndSaveDefaultsOrUpgrade(configFile, "default_features_config.ini");
        FabLog.timeAndCountWarnings("Loading of features.ini", () -> {
            StringWriter sw = new StringWriter();
            try {
                rawConfig = QDIni.loadAndTransform(configFile, new QDIni.IniTransformer(){
                    final String NOTICES_HEADER = "; Notices: (Do not edit anything past this line; it will be overwritten)";
                    boolean encounteredNotices = false;
                    Set encounteredKeys = Sets.newHashSet();
                    List notices = Lists.newArrayList();

                    @Override
                    public String transformLine(String path, String line) {
                        if (!this.encounteredNotices && line == null || line != null && line.trim().equals("; Notices: (Do not edit anything past this line; it will be overwritten)")) {
                            this.encounteredNotices = true;
                            boolean badKeys = false;
                            for (String s : validKeys) {
                                if (this.encounteredKeys.contains(s)) continue;
                                this.notices.add("- " + s + " was not found");
                                badKeys = true;
                            }
                            for (String s : this.encounteredKeys) {
                                if (validKeys.contains((Object)s)) continue;
                                this.notices.add("- " + s + " is not recognized");
                                badKeys = true;
                            }
                            if (badKeys) {
                                this.notices.add("Consider updating this config file by renaming it to fabrication.ini.old");
                            }
                            if (this.notices.isEmpty()) {
                                return "; Notices: (Do not edit anything past this line; it will be overwritten)\r\n; - No notices. You're in the clear!";
                            }
                            return "; Notices: (Do not edit anything past this line; it will be overwritten)\r\n; " + Joiner.on((String)"\r\n; ").join((Iterable)this.notices);
                        }
                        return this.encounteredNotices ? null : line;
                    }

                    @Override
                    public String transformValueComment(String key, String value, String comment) {
                        return comment;
                    }

                    @Override
                    public String transformValue(String key, String value) {
                        this.encounteredKeys.add(key);
                        return value;
                    }
                }, (Writer)sw);
                profile = rawConfig.getEnum("general.profile", Profile.class).orElse(Profile.LIGHT);
                defaults = (ImmutableMap)defaultsByProfile.get((Object)profile);
                config = new HashMap<String, Trilean>();
                for (String k : rawConfig.keySet()) {
                    if (!MixinConfigPlugin.isTrilean(k)) continue;
                    try {
                        config.put(k, rawConfig.getEnum(k, Trilean.class).get());
                    }
                    catch (QDIni.BadValueException e) {
                        FabLog.warn(e.getMessage() + " - assuming unset");
                        config.put(k, Trilean.UNSET);
                    }
                }
            }
            catch (QDIni.SyntaxErrorException e) {
                FabLog.warn("Failed to load configuration file: " + e.getMessage() + "; will assume defaults");
                config = Maps.transformValues(defaults, v -> Trilean.UNSET);
            }
            catch (IOException e) {
                FabLog.warn("Failed to load configuration file; will assume defaults", e);
                config = Maps.transformValues(defaults, v -> Trilean.UNSET);
            }
            try {
                Files.write(configFile, sw.toString().getBytes(Charsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                FabLog.warn("Failed to transform configuration file", e);
            }
        });
        if (analyticsSafe) {
            MixinConfigPlugin.submitConfigAnalytics();
        }
        for (ConfigLoader ldr : loaders) {
            MixinConfigPlugin.load(ldr);
        }
    }

    private static void load(ConfigLoader ldr) {
        String name = ldr.getConfigName();
        Path dir = Agnos.getConfigDir().resolve("fabrication");
        Path file = dir.resolve(name + ".ini");
        MixinConfigPlugin.checkForAndSaveDefaultsOrUpgrade(file, "default_" + name + "_config.ini");
        FabLog.timeAndCountWarnings("Loading of " + name + ".ini", () -> {
            try {
                QDIni qd = QDIni.load(file);
                qd.setYapLog(FabLog::warn);
                ldr.load(dir, qd, false);
            }
            catch (QDIni.SyntaxErrorException e) {
                FabLog.warn("Failed to load " + name + ": " + e.getMessage());
                ldr.load(dir, QDIni.load("<empty>", ""), true);
            }
            catch (IOException e) {
                FabLog.warn("Failed to load " + name + " configuration file", e);
            }
        });
    }

    private static void checkForAndSaveDefaultsOrUpgrade(Path configFile, String defaultName) {
        if (!Files.exists(configFile, new LinkOption[0])) {
            Path configFileLegacy = configFile.getParent().getParent().resolve(defaultName.equals("default_features_config.ini") ? "fabrication.ini" : "fabrication_" + configFile.getFileName().toString());
            boolean migrated = false;
            if (Files.exists(configFileLegacy, new LinkOption[0])) {
                try {
                    Files.move(configFileLegacy, configFile, new CopyOption[0]);
                    migrated = true;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to move legacy config file into directory");
                }
            }
            Path configFileLegacyOld = configFileLegacy.resolveSibling(configFileLegacy.getFileName() + ".old");
            Path configFileOld = configFile.resolveSibling(configFile.getFileName() + ".old");
            if (Files.exists(configFileLegacyOld, new LinkOption[0])) {
                try {
                    Files.move(configFileLegacyOld, configFileOld, new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to move legacy old config file into directory");
                }
            }
            if (Files.exists(configFileOld, new LinkOption[0])) {
                try {
                    final QDIni currentValues = QDIni.load(configFileOld);
                    try (InputStream is = MixinConfigPlugin.class.getClassLoader().getResourceAsStream(defaultName);
                         OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(configFile, new OpenOption[0]), Charsets.UTF_8);){
                        QDIni.loadAndTransform(defaultName, new InputStreamReader(is, Charsets.UTF_8), new QDIni.IniTransformer(){

                            @Override
                            public String transformLine(String path, String line) {
                                return line;
                            }

                            @Override
                            public String transformValueComment(String key, String value, String comment) {
                                return comment;
                            }

                            @Override
                            public String transformValue(String key, String value) {
                                return currentValues.get(key).orElse(value);
                            }
                        }, (Writer)osw);
                    }
                    Files.delete(configFileOld);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to upgrade config", e);
                }
            }
            if (!migrated) {
                try {
                    Resources.asByteSource((URL)MixinConfigPlugin.class.getClassLoader().getResource(defaultName)).copyTo(MoreFiles.asByteSink((Path)configFile, (OpenOption[])new OpenOption[0]));
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to write default config", e);
                }
            }
        }
    }

    public void onLoad(String mixinPackage) {
        MixinConfigPlugin.reload();
        RUNTIME_CHECKS_WAS_ENABLED = MixinConfigPlugin.isEnabled("general.runtime_checks");
        Mixins.registerErrorHandlerClass((String)"com.unascribed.fabrication.support.MixinErrorHandler_THIS_ERROR_HANDLER_IS_FOR_SOFT_FAILURE_IN_FABRICATION_ITSELF_AND_DOES_NOT_IMPLY_FABRICATION_IS_RESPONSIBLE_FOR_THE_BELOW_ERROR");
        InjectionInfo.register(FailsoftCallbackInjectionInfo.class);
        InjectionInfo.register(FailsoftModifyArgInjectionInfo.class);
        InjectionInfo.register(FailsoftModifyArgsInjectionInfo.class);
        InjectionInfo.register(FailsoftRedirectInjectionInfo.class);
        InjectionInfo.register(FailsoftModifyVariableInjectionInfo.class);
        InjectionInfo.register(FailsoftModifyConstantInjectionInfo.class);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        FabLog.debug("\u2615 Profile: " + profile.name().toLowerCase(Locale.ROOT));
        return MixinConfigPlugin.discoverClassesInPackage("com.unascribed.fabrication.mixin", true);
    }

    public static List<String> discoverClassesInPackage(String pkg, boolean truncate) {
        FabLog.debug("Starting discovery pass...");
        try {
            int count = 0;
            int enabled = 0;
            int skipped = 0;
            ArrayList rtrn = Lists.newArrayList();
            for (ClassPath.ClassInfo ci : MixinConfigPlugin.getClassesInPackage(pkg)) {
                if (ci.getName().contains("$")) continue;
                ++count;
                String truncName = ci.getName().substring(pkg.length() + 1);
                FabLog.debug("--");
                FabLog.debug((Math.random() < 0.01 ? "\ud83d\udc45" : "\ud83d\udc40") + " Considering " + truncName);
                ClassReader cr = new ClassReader(ci.asByteSource().read());
                ClassNode cn = new ClassNode();
                cr.accept((ClassVisitor)cn, 7);
                boolean eligible = true;
                ArrayList eligibilityFailures = Lists.newArrayList();
                ArrayList eligibilityNotes = Lists.newArrayList();
                ArrayList eligibilitySuccesses = Lists.newArrayList();
                boolean anyRestrictions = false;
                if (cn.visibleAnnotations != null) {
                    for (AnnotationNode an : cn.visibleAnnotations) {
                        if (!an.desc.equals("Lcom/unascribed/fabrication/support/EligibleIf;") || an.values == null) continue;
                        for (int i = 0; i < an.values.size(); i += 2) {
                            anyRestrictions = true;
                            String k = (String)an.values.get(i);
                            Object v = an.values.get(i + 1);
                            if (k.equals("configEnabled")) {
                                if (!defaults.containsKey((Object)MixinConfigPlugin.remap((String)v))) {
                                    FabLog.debug("\ud83d\ude48 Dev error! Exploding.");
                                    throw MixinConfigPlugin.devError(cn.name.substring(pkg.length() + 1).replace('/', '.') + " references an unknown config key " + v + "\n\nDid you forget to add it to features.txt and run build-features.sh?");
                                }
                                if (MixinConfigPlugin.getValue((String)v) == Trilean.UNSET && RUNTIME_CHECKS_WAS_ENABLED) {
                                    eligibilitySuccesses.add("Runtime checks is enabled and required config key " + MixinConfigPlugin.remap((String)v) + " is unset");
                                } else if (!MixinConfigPlugin.isEnabled((String)v)) {
                                    eligibilityFailures.add("Required config setting " + MixinConfigPlugin.remap((String)v) + " is disabled " + (config.get(MixinConfigPlugin.remap((String)v)) == Trilean.FALSE ? "explicitly" : "by profile"));
                                    eligible = false;
                                } else {
                                    eligibilitySuccesses.add("Required config setting " + MixinConfigPlugin.remap((String)v) + " is enabled " + (config.get(MixinConfigPlugin.remap((String)v)) == Trilean.TRUE ? "explicitly" : "by profile"));
                                }
                                configKeysForDiscoveredClasses.put((Object)ci.getName(), (Object)((String)v));
                                continue;
                            }
                            if (k.equals("configDisabled")) {
                                if (MixinConfigPlugin.getValue((String)v) == Trilean.UNSET && RUNTIME_CHECKS_WAS_ENABLED) {
                                    eligibilitySuccesses.add("Runtime checks is enabled and conflicting config key " + MixinConfigPlugin.remap((String)v) + " is unset");
                                    continue;
                                }
                                if (!MixinConfigPlugin.isEnabled((String)v)) {
                                    eligibilitySuccesses.add("Conflicting config setting " + MixinConfigPlugin.remap((String)v) + " is disabled " + (config.get(MixinConfigPlugin.remap((String)v)) == Trilean.FALSE ? "explicitly" : "by profile"));
                                    continue;
                                }
                                eligibilityFailures.add("Conflicting config setting " + MixinConfigPlugin.remap((String)v) + " is enabled " + (config.get(MixinConfigPlugin.remap((String)v)) == Trilean.TRUE ? "explicitly" : "by profile"));
                                eligible = false;
                                continue;
                            }
                            if (k.equals("envMatches")) {
                                String[] arr = (String[])v;
                                if (!arr[0].equals("Lcom/unascribed/fabrication/support/Env;")) continue;
                                Env e = Env.valueOf(arr[1]);
                                Env curEnv = Agnos.getCurrentEnv();
                                if (!curEnv.matches(e)) {
                                    eligibilityFailures.add("Environment is incorrect (want " + e.name().toLowerCase(Locale.ROOT) + ", got " + curEnv.name().toLowerCase(Locale.ROOT) + ")");
                                    eligible = false;
                                    continue;
                                }
                                eligibilitySuccesses.add("Environment is correct (" + e.name().toLowerCase(Locale.ROOT) + ")");
                                continue;
                            }
                            if (k.equals("modLoaded")) {
                                for (String s : (List)v) {
                                    if (!Agnos.isModLoaded(s)) {
                                        eligibilityFailures.add("Required mod " + s + " is not loaded");
                                        eligible = false;
                                        continue;
                                    }
                                    eligibilitySuccesses.add("Required mod " + s + " is loaded");
                                }
                                continue;
                            }
                            if (k.equals("modNotLoaded")) {
                                for (String s : (List)v) {
                                    if (Agnos.isModLoaded(s)) {
                                        eligibilityFailures.add("Conflicting mod " + s + " is loaded");
                                        eligible = false;
                                        continue;
                                    }
                                    eligibilitySuccesses.add("Conflicting mod " + s + " is not loaded");
                                }
                                continue;
                            }
                            if (k.equals("classPresent")) {
                                for (String s : (List)v) {
                                    try {
                                        Class.forName(s, false, MixinConfigPlugin.class.getClassLoader());
                                        eligibilitySuccesses.add("Required class " + s + " is present");
                                    }
                                    catch (ClassNotFoundException e) {
                                        eligibilityFailures.add("Required class " + s + " is not present");
                                        eligible = false;
                                    }
                                }
                                continue;
                            }
                            if (k.equals("classNotPresent")) {
                                for (String s : (List)v) {
                                    try {
                                        Class.forName(s, false, MixinConfigPlugin.class.getClassLoader());
                                        eligibilityFailures.add("Conflicting class " + s + " is present");
                                        eligible = false;
                                    }
                                    catch (ClassNotFoundException e) {
                                        eligibilitySuccesses.add("Conflicting class " + s + " is not present");
                                    }
                                }
                                continue;
                            }
                            if (k.equals("anyConfigEnabled")) {
                                boolean allDisabled = true;
                                boolean foundAny = false;
                                for (String s : (List)v) {
                                    if (MixinConfigPlugin.isEnabled(s = MixinConfigPlugin.remap(s))) {
                                        foundAny = true;
                                        allDisabled = false;
                                        eligibilitySuccesses.add("Relevant config setting " + s + " is enabled " + (config.get(s) == Trilean.TRUE ? "explicitly" : "by profile"));
                                    } else {
                                        if (MixinConfigPlugin.getValue(s) != Trilean.FALSE) {
                                            allDisabled = false;
                                        }
                                        eligibilityNotes.add("Relevant config setting " + s + " is disabled " + (config.get(s) == Trilean.FALSE ? "explicitly" : "by profile"));
                                    }
                                    configKeysForDiscoveredClasses.put((Object)ci.getName(), (Object)s);
                                }
                                if (allDisabled) {
                                    eligibilityFailures.add("All of the relevant config settings are explicitly disabled");
                                    eligible = false;
                                    continue;
                                }
                                if (foundAny) continue;
                                if (RUNTIME_CHECKS_WAS_ENABLED) {
                                    eligibilityNotes.add("None of the relevant config settings are enabled, but runtime checks is enabled");
                                    continue;
                                }
                                eligibilityFailures.add("None of the relevant config settings are enabled");
                                eligible = false;
                                continue;
                            }
                            if (k.equals("specialConditions")) {
                                List li = (List)v;
                                if (li.isEmpty()) {
                                    eligibilityNotes.add("Special conditions is present but empty - ignoring");
                                    continue;
                                }
                                for (String[] e : li) {
                                    if (!"Lcom/unascribed/fabrication/support/SpecialEligibility;".equals(e[0])) {
                                        eligibilityNotes.add("Unknown special condition type " + e[0] + " - ignoring");
                                        continue;
                                    }
                                    try {
                                        SpecialEligibility se = SpecialEligibility.valueOf(e[1]);
                                        if (RUNTIME_CHECKS_WAS_ENABLED && se.ignorableWithRuntimeChecks) {
                                            eligibilityNotes.add("Runtime checks is enabled, ignoring special condition " + (Object)((Object)se));
                                            continue;
                                        }
                                        if (MixinConfigPlugin.isMet(se)) {
                                            eligibilitySuccesses.add("Special condition " + (Object)((Object)se) + " is met");
                                            continue;
                                        }
                                        eligibilityFailures.add("Special condition " + (Object)((Object)se) + " is not met");
                                        eligible = false;
                                    }
                                    catch (IllegalArgumentException ex) {
                                        eligibilityFailures.add("Unknown special condition " + e[1]);
                                        eligible = false;
                                    }
                                }
                                continue;
                            }
                            FabLog.warn("Unknown annotation setting " + k);
                        }
                    }
                }
                if (!anyRestrictions) {
                    eligibilityNotes.add("No restrictions on eligibility");
                }
                for (String s : eligibilityNotes) {
                    FabLog.debug("  \u2139\ufe0f " + s);
                }
                for (String s : eligibilitySuccesses) {
                    FabLog.debug("  \u2705 " + s);
                }
                for (String s : eligibilityFailures) {
                    FabLog.debug("  \u274c " + s);
                }
                if (eligible) {
                    ++enabled;
                    FabLog.debug("\ud83d\udc4d Eligibility requirements met. Applying " + truncName);
                    rtrn.add(truncate ? truncName : ci.getName());
                    continue;
                }
                ++skipped;
                FabLog.debug("\u270b Eligibility requirements not met. Skipping " + truncName);
            }
            FabLog.debug("Discovery pass complete. Found " + count + " candidates, enabled " + enabled + ", skipped " + skipped + ".");
            return rtrn;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Iterable<ClassPath.ClassInfo> getClassesInPackage(String pkg) {
        block12: {
            try {
                InputStream is;
                block13: {
                    is = MixinConfigPlugin.class.getClassLoader().getResourceAsStream("classes.txt");
                    if (is == null) break block12;
                    break block13;
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                Constructor cons = ClassPath.ClassInfo.class.getDeclaredConstructor(String.class, ClassLoader.class);
                cons.setAccessible(true);
                ArrayList rtrn = Lists.newArrayList();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
                String prefix = pkg.replace('.', '/') + "/";
                while (true) {
                    String line;
                    if ((line = br.readLine()) == null) {
                        ArrayList arrayList = rtrn;
                        return arrayList;
                    }
                    if (!line.startsWith(prefix)) continue;
                    rtrn.add((ClassPath.ClassInfo)cons.newInstance(line, MixinConfigPlugin.class.getClassLoader()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            return ClassPath.from((ClassLoader)MixinConfigPlugin.class.getClassLoader()).getTopLevelClassesRecursive(pkg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        metSpecialEligibility = EnumSet.noneOf(SpecialEligibility.class);
        loaders = Lists.newArrayList();
        try {
            Class.forName(new String(BaseEncoding.base64().decode((CharSequence)"bmV0LmZhYnJpY21jLmxvYWRlci5hcGkuRmFicmljTG9hZGVy"), Charsets.UTF_8));
            MixinConfigPlugin.setMet(SpecialEligibility.NOT_FORGE, true);
        }
        catch (Throwable t) {
            MixinConfigPlugin.setMet(SpecialEligibility.FORGE, true);
        }
        try {
            Class.forName("optifine.Installer", false, MixinConfigPlugin.class.getClassLoader());
        }
        catch (Throwable t) {
            MixinConfigPlugin.setMet(SpecialEligibility.NO_OPTIFINE, true);
        }
        if (MixinConfigPlugin.class.getClassLoader().getResource("default_features_config.ini") == null) {
            throw MixinConfigPlugin.devError("You must run build-features.sh before running the game.");
        }
        try (InputStream is = MixinConfigPlugin.class.getClassLoader().getResourceAsStream("default_features_config.ini");){
            Set<String> keys = QDIni.load("default_features_config.ini", is).keySet();
            HashSet sections = Sets.newHashSet();
            ImmutableMap.Builder starMapBldr = ImmutableMap.builder();
            for (String key : keys) {
                int dot = key.indexOf(46);
                if (dot == -1) continue;
                starMapBldr.put((Object)("*" + key.substring(dot)), (Object)key);
            }
            starMap = starMapBldr.build();
            ImmutableMap.Builder profilesBuilder = ImmutableMap.builder();
            for (Profile p : Profile.values()) {
                ImmutableMap.Builder defaultsBuilder = ImmutableMap.builder();
                for (String key : keys) {
                    String section;
                    int dot = key.indexOf(46);
                    String string = section = dot != -1 ? key.substring(0, dot) : "";
                    if (!section.isEmpty()) {
                        sections.add(section);
                    }
                    boolean enabled = NEVER_DEFAULT.contains((Object)key) || NEVER_DEFAULT_EXCEPT_BURNT.contains((Object)key) && p != Profile.BURNT ? false : p.sections.contains((Object)"*") && !p.sections.contains((Object)("!" + section)) || p.sections.contains((Object)section) && (p != Profile.VIENNA || !VIENNA_EXCEPTIONS.contains((Object)key));
                    defaultsBuilder.put((Object)key, (Object)enabled);
                }
                profilesBuilder.put((Object)p, (Object)defaultsBuilder.build());
            }
            validKeys = ImmutableSet.copyOf(keys);
            validSections = ImmutableSet.copyOf((Collection)sections);
            defaultsByProfile = profilesBuilder.build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        failures = Sets.newHashSet();
        failuresReadOnly = Collections.unmodifiableSet(failures);
        configKeysForDiscoveredClasses = HashMultimap.create();
        analyticsSafe = false;
    }

    public static enum Profile {
        GREEN("general"),
        BLONDE("general", "fixes", "utility"),
        LIGHT("general", "fixes", "utility", "tweaks"),
        MEDIUM("general", "fixes", "utility", "tweaks", "minor_mechanics"),
        DARK("general", "fixes", "utility", "tweaks", "minor_mechanics", "mechanics"),
        VIENNA("general", "fixes", "utility", "tweaks", "minor_mechanics", "mechanics", "balance", "weird_tweaks", "woina"),
        BURNT("*", "!situational", "!experiments");

        public final ImmutableSet<String> sections;

        private Profile(String ... sections) {
            this.sections = ImmutableSet.copyOf((Object[])sections);
        }

        public static String[] stringValues() {
            Profile[] values = Profile.values();
            String[] out = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                out[i] = values[i].name().toLowerCase(Locale.ROOT);
            }
            return out;
        }
    }
}

