/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid;

import ichttt.mods.firstaid.FirstAid;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class FirstAidConfig {
    static final ForgeConfigSpec serverSpec;
    static final ForgeConfigSpec generalSpec;
    static final ForgeConfigSpec clientSpec;
    public static final Server SERVER;
    public static final General GENERAL;
    public static final Client CLIENT;
    public static final boolean watchSetHealth = true;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(General::new);
        generalSpec = (ForgeConfigSpec)specPair.getRight();
        GENERAL = (General)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue maxHealthHead;
        public final ForgeConfigSpec.BooleanValue causeDeathHead;
        public final ForgeConfigSpec.IntValue maxHealthLeftArm;
        public final ForgeConfigSpec.IntValue maxHealthLeftLeg;
        public final ForgeConfigSpec.IntValue maxHealthLeftFoot;
        public final ForgeConfigSpec.IntValue maxHealthBody;
        public final ForgeConfigSpec.BooleanValue causeDeathBody;
        public final ForgeConfigSpec.IntValue maxHealthRightArm;
        public final ForgeConfigSpec.IntValue maxHealthRightLeg;
        public final ForgeConfigSpec.IntValue maxHealthRightFoot;
        public final ForgeConfigSpec.DoubleValue headArmorMultiplier;
        public final ForgeConfigSpec.DoubleValue chestArmorMultiplier;
        public final ForgeConfigSpec.DoubleValue legsArmorMultiplier;
        public final ForgeConfigSpec.DoubleValue feetArmorMultiplier;
        public final ForgeConfigSpec.DoubleValue headArmorOffset;
        public final ForgeConfigSpec.DoubleValue chestArmorOffset;
        public final ForgeConfigSpec.DoubleValue legsArmorOffset;
        public final ForgeConfigSpec.DoubleValue feetArmorOffset;
        public final ForgeConfigSpec.DoubleValue headThoughnessMultiplier;
        public final ForgeConfigSpec.DoubleValue chestThoughnessMultiplier;
        public final ForgeConfigSpec.DoubleValue legsThoughnessMultiplier;
        public final ForgeConfigSpec.DoubleValue feetThoughnessMultiplier;
        public final ForgeConfigSpec.DoubleValue headThoughnessOffset;
        public final ForgeConfigSpec.DoubleValue chestThoughnessOffset;
        public final ForgeConfigSpec.DoubleValue legsThoughnessOffset;
        public final ForgeConfigSpec.DoubleValue feetThoughnessOffset;
        public final IEEntry bandage;
        public final IEEntry plaster;
        public final ForgeConfigSpec.BooleanValue allowNaturalRegeneration;
        public final ForgeConfigSpec.BooleanValue allowOtherHealingItems;
        public final ForgeConfigSpec.DoubleValue sleepHealPercentage;
        public final ForgeConfigSpec.DoubleValue otherRegenMultiplier;
        public final ForgeConfigSpec.DoubleValue naturalRegenMultiplier;
        public final ForgeConfigSpec.IntValue resistanceReductionPercentPerLevel;
        public final ForgeConfigSpec.BooleanValue scaleMaxHealth;
        public final ForgeConfigSpec.BooleanValue capMaxHealth;
        public final ForgeConfigSpec.EnumValue<VanillaHealthCalculationMode> vanillaHealthCalculation;
        public final ForgeConfigSpec.BooleanValue useFriendlyRandomDistribution;
        public final ForgeConfigSpec.EnumValue<ArmorEnchantmentMode> armorEnchantmentMode;
        public final ForgeConfigSpec.IntValue enchantmentMultiplier;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> enchMulOverrideResourceLocations;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> enchMulOverrideMultiplier;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server to Client synced configuration settings").push("Damage System");
            this.maxHealthHead = Server.healthEntry(builder, "Head", 4);
            this.maxHealthLeftArm = Server.healthEntry(builder, "Left Arm", 4);
            this.maxHealthLeftLeg = Server.healthEntry(builder, "Left Leg", 4);
            this.maxHealthLeftFoot = Server.healthEntry(builder, "Left Foot", 4);
            this.maxHealthBody = Server.healthEntry(builder, "Body", 6);
            this.maxHealthRightArm = Server.healthEntry(builder, "Right Arm", 4);
            this.maxHealthRightLeg = Server.healthEntry(builder, "Right Leg", 4);
            this.maxHealthRightFoot = Server.healthEntry(builder, "Right Foot", 4);
            this.causeDeathHead = builder.comment("True if the head can cause death if health drops to 0").translation("firstaid.config.causedeath.head").define("causeDeathHead", true);
            this.causeDeathBody = builder.comment("True if the body can cause death if health drops to 0").translation("firstaid.config.causedeath.body").define("causeDeathBody", true);
            builder.pop().push("Locational Armor").push("Armor");
            this.headArmorMultiplier = Server.multiplierEntry(builder, "Head", 6.0);
            this.chestArmorMultiplier = Server.multiplierEntry(builder, "Chest", 2.5);
            this.legsArmorMultiplier = Server.multiplierEntry(builder, "Legs", 3.0);
            this.feetArmorMultiplier = Server.multiplierEntry(builder, "Feet", 6.0);
            this.headArmorOffset = Server.offsetEntry(builder, "Head", 1.0);
            this.chestArmorOffset = Server.offsetEntry(builder, "Chest", 0.0);
            this.legsArmorOffset = Server.offsetEntry(builder, "Legs", 0.0);
            this.feetArmorOffset = Server.offsetEntry(builder, "Feet", 0.0);
            builder.pop().push("Toughness");
            this.headThoughnessMultiplier = Server.multiplierEntry(builder, "Head", 4.0);
            this.chestThoughnessMultiplier = Server.multiplierEntry(builder, "Chest", 3.0);
            this.legsThoughnessMultiplier = Server.multiplierEntry(builder, "Legs", 3.0);
            this.feetThoughnessMultiplier = Server.multiplierEntry(builder, "Feet", 3.5);
            this.headThoughnessOffset = Server.offsetEntry(builder, "Head", 0.0);
            this.chestThoughnessOffset = Server.offsetEntry(builder, "Chest", 0.0);
            this.legsThoughnessOffset = Server.offsetEntry(builder, "Legs", 0.0);
            this.feetThoughnessOffset = Server.offsetEntry(builder, "Feet", 0.0);
            builder.pop(2).push("Internal Healing");
            this.bandage = new IEEntry(builder, "bandage", 4, 18, 2500);
            this.plaster = new IEEntry(builder, "plaster", 2, 22, 3000);
            builder.pop().push("External Healing");
            this.allowNaturalRegeneration = builder.comment(new String[]{"Allow vanilla's natural regeneration. Requires \"allowOtherHealingItems\" to be true", "**WARNING** This sets the gamerule \"naturalRegeneration\" for all of your worlds internally, so it persists even if you remove the mod"}).translation("firstaid.config.allownaturalregeneration").worldRestart().define("allowNaturalRegeneration", false);
            this.allowOtherHealingItems = builder.comment("If false, healing potions and other healing items will have no effect").translation("firstaid.config.allowotherhealingitems").define("allowOtherHealingItems", true);
            this.sleepHealPercentage = builder.comment("Specifies how much percent of the max health should be restored when sleeping").translation("firstaid.config.sleephealpercentage").defineInRange("sleepHealPercentage", 0.07, 0.0, 1.0);
            this.otherRegenMultiplier = builder.comment("The value external regen will be multiplied with. Has no effect if \"allowOtherHealingItems\" is disabled").translation("firstaid.config.otherregenmultiplier").defineInRange("otherRegenMultiplier", 0.75, 0.0, 20.0);
            this.naturalRegenMultiplier = builder.comment("The value vanilla's natural regeneration will be multiplied with. Has no effect if \"allowNaturalRegeneration\" is disabled").translation("firstaid.config.naturalregenmultiplier").defineInRange("naturalRegenMultiplier", 0.5, 0.0, 20.0);
            this.resistanceReductionPercentPerLevel = builder.comment(new String[]{"Specifies how the vanilla resistance potion effect should reduce damage.", "By default, one level of resistance reduces 20% of damage. Changing this value to e.g. 10 will reduce the reduction to 10% damage reduction per level"}).translation("firstaid.config.resistancereductionpercentperlevel").defineInRange("resistanceReductionPercentPerLevel", 20, 1, 40);
            builder.pop();
            builder.push("misc");
            this.scaleMaxHealth = builder.comment("If true, max health is scaled to your hearts, and the config entries get multiplier to match the max health").translation("firstaid.config.scalemaxhealth").worldRestart().define("scaleMaxHealth", true);
            this.capMaxHealth = builder.comment("If true, max health will be capped at 6 hearts and absorption at 2 hearts per limb. If false, the health cap will be much higher (64 hearts normal and 16 absorption)").translation("firstaid.config.scalemaxhealth").define("capMaxHealth", true);
            this.vanillaHealthCalculation = builder.comment(new String[]{"Specifies how the vanilla health is calculated. Affects the vanilla visual health bar, as well as the value other mods get to see when they query the player health.", "AVERAGE_ALL simply takes all limbs and calculates the average of it.", "AVERAGE_CRITICAL takes all critical limbs and calculates the average of it.", "MIN_CRITICAl takes the smallest health value of all critical limb.", "Does not have any effect if all critical limbs have been disabled."}).defineEnum("vanillaHealthCalculation", (Enum)VanillaHealthCalculationMode.AVERAGE_ALL);
            this.useFriendlyRandomDistribution = builder.comment(new String[]{"If enabled, the default random damage distribution will be changed to leave critical limbs at 1hp if possible.", "When there is too much damage, the damage will still kill the player. Other distributions that defined are not affected by this."}).define("useFriendlyRandomDistribution", false);
            this.armorEnchantmentMode = builder.comment(new String[]{"If set to LOCAL_ENCHANTMENTS, only the enchantments for the armor for the body part that is currently being damaged is taken into account. The strength of the armor is multiplied by 4 (default value, can be changed by enchantmentMultiplier), so it matches the vanilla default", "If set to GLOBAL_ENCHANTMENTS, the enchantments of all armor pieces are taken into account for all body parts that have any kind of armor."}).defineEnum("armorEnchantmentMode", (Enum)ArmorEnchantmentMode.LOCAL_ENCHANTMENTS);
            builder.pop();
            builder.push("Enchantment Handling");
            this.enchantmentMultiplier = builder.comment("Specifies the default modifier. This is only used if armorEnchantmentMode is LOCAL_ENCHANTMENTS, as this is used scale up the values to somewhat match what vanilla balances around (as vanilla balances around global enchantments)").defineInRange("enchantmentMultiplier", 4, 1, 4);
            this.enchMulOverrideResourceLocations = builder.comment(new String[]{"Specifies the overrides for the the modifier. This is only used if armorEnchantmentMode is LOCAL_ENCHANTMENTS. This can be used to set another multiplier for special enchantments", "This list specifies the resource location of the enchantment. Must be fully specified and cannot use wildcard. Example: minecraft:feather_falling. First entry here will be matched to first multiplier, second entry to second multiplier and so on"}).defineList("resourceLocations", Collections.singletonList("minecraft:feather_falling"), o -> {
                if (o == null || o.toString().isEmpty()) {
                    FirstAid.LOGGER.warn("Ignored empty or invalid string for resourceLocations");
                    return false;
                }
                return true;
            });
            this.enchMulOverrideMultiplier = builder.comment(new String[]{"Specifies the overrides for the the modifier. This is only used if armorEnchantmentMode is LOCAL_ENCHANTMENTS. This can be used to set another multiplier for special enchantments", "This list specifies the multiplier of the corresponding resource location. See resourceLocations comment. Must be between 1 and 4"}).defineList("overrideMultiplier", Collections.singletonList(2), o -> {
                try {
                    int val = Integer.parseInt(o.toString());
                    return val >= 1 && val <= 4;
                }
                catch (NumberFormatException numberFormatException) {
                    FirstAid.LOGGER.warn("Invalid entry " + o.toString() + " for overrideMultiplier found!");
                    return false;
                }
            });
            builder.pop();
        }

        private static ForgeConfigSpec.IntValue healthEntry(ForgeConfigSpec.Builder builder, String name, int defaultVal) {
            String noSpaceName = name.replace(' ', '_');
            return builder.comment("Max health of the " + name).translation("firstaid.config.maxhealth." + noSpaceName.toLowerCase(Locale.ENGLISH)).defineInRange("maxHealth" + noSpaceName, defaultVal, 2, 12);
        }

        private static ForgeConfigSpec.DoubleValue multiplierEntry(ForgeConfigSpec.Builder builder, String name, double defaultVal) {
            return builder.comment("The multiplier for local armor for every armor of slot " + name).translation("firstaid.config.multiplier." + name.toLowerCase(Locale.ROOT)).defineInRange("multiplier" + name, defaultVal, 1.0, 16.0);
        }

        private static ForgeConfigSpec.DoubleValue offsetEntry(ForgeConfigSpec.Builder builder, String name, double defaultVal) {
            return builder.comment("The static offset applied to any armor piece with a value greater than zero of slot " + name).translation("firstaid.config.offset." + name.toLowerCase(Locale.ROOT)).defineInRange("offset" + name, defaultVal, 0.0, 4.0);
        }

        public static class IEEntry {
            public final ForgeConfigSpec.IntValue totalHeals;
            public final ForgeConfigSpec.IntValue secondsPerHeal;
            public final ForgeConfigSpec.IntValue applyTime;

            IEEntry(ForgeConfigSpec.Builder builder, String name, int initialTotalHeals, int initialSecondsPerHeal, int initialApplyTime) {
                builder.push(name);
                this.totalHeals = builder.comment("The total heals this item does when applied. 1 heal = half a heart").translation("firstaid.config.totalheals").defineInRange("totalsHeals", initialTotalHeals, 1, 127);
                this.secondsPerHeal = builder.comment("The time it takes for a single heal to trigger. Total time this item is active = this * totalHeals").translation("firstaid.config.secondsperheal").defineInRange("secondsPerHeal", initialSecondsPerHeal, 1, Short.MAX_VALUE);
                this.applyTime = builder.comment("The time it takes in the GUI to apply the item in milliseconds").translation("firstaid.config.applytime").defineInRange("applyTime", initialApplyTime, 0, 16000);
                builder.pop();
            }
        }

        public static enum VanillaHealthCalculationMode {
            AVERAGE_ALL,
            AVERAGE_CRITICAL,
            MIN_CRITICAL,
            CRITICAL_50_PERCENT_OTHER_50_PERCENT;

        }

        public static enum ArmorEnchantmentMode {
            GLOBAL_ENCHANTMENTS,
            LOCAL_ENCHANTMENTS;

        }
    }

    public static class General {
        public final Head head;
        public final Body body;
        public final Arms arms;
        public final LegsAndFeet legsAndFeet;
        public final ForgeConfigSpec.BooleanValue hardMode;
        public final ForgeConfigSpec.BooleanValue debug;

        public General(ForgeConfigSpec.Builder builder) {
            builder.comment("Server only configuration settings").push("Debuffs");
            this.head = new Head(builder);
            this.body = new Body(builder);
            this.arms = new Arms(builder);
            this.legsAndFeet = new LegsAndFeet(builder);
            builder.pop();
            builder.push("misc");
            this.hardMode = builder.comment("If true, many damage distributions will be more realistic, but this will also cause them to be harder\\nIf enabled, e.g. drowing will only damage your body instead of your body and head last").translation("firstaid.config.hardmode").worldRestart().define("hardMode", false);
            this.debug = builder.comment(new String[]{"Enabled additional debug logs - May slow down the game and will increase log file size", "Only enable for special purposes"}).translation("firstaid.config.debug").define("debug", false);
            builder.pop();
        }

        public static class Head {
            public final ConditionOnHit blindnessConditions;
            public final ConditionOnHit nauseaConditions;

            Head(ForgeConfigSpec.Builder builder) {
                builder.push("Head");
                this.blindnessConditions = new ConditionOnHit(builder, "blindness", Arrays.asList(Float.valueOf(2.0f), Float.valueOf(1.0f)), Arrays.asList(160, 80));
                this.nauseaConditions = new ConditionOnHit(builder, "nausea", Arrays.asList(Float.valueOf(3.0f), Float.valueOf(2.0f)), Arrays.asList(320, 240));
                builder.pop();
            }
        }

        public static class Body {
            public final ConditionOnHit nauseaConditions;
            public final ConditionConstant weaknessConditions;

            Body(ForgeConfigSpec.Builder builder) {
                builder.push("Body");
                this.nauseaConditions = new ConditionOnHit(builder, "nausea", Arrays.asList(Float.valueOf(4.0f), Float.valueOf(2.0f)), Arrays.asList(320, 160));
                this.weaknessConditions = new ConditionConstant(builder, "weakness", Arrays.asList(Float.valueOf(0.25f), Float.valueOf(0.5f)), Arrays.asList(2, 1));
                builder.pop();
            }
        }

        public static class Arms {
            public final ConditionConstant miningFatigueConditions;

            Arms(ForgeConfigSpec.Builder builder) {
                builder.push("Arms");
                this.miningFatigueConditions = new ConditionConstant(builder, "miningFatigue", Arrays.asList(Float.valueOf(0.25f), Float.valueOf(0.5f), Float.valueOf(0.75f)), Arrays.asList(3, 2, 1));
                builder.pop();
            }
        }

        public static class LegsAndFeet {
            public final ConditionConstant slownessConditions;

            LegsAndFeet(ForgeConfigSpec.Builder builder) {
                builder.push("Legs and Feet");
                this.slownessConditions = new ConditionConstant(builder, "slowness", Arrays.asList(Float.valueOf(0.35f), Float.valueOf(0.6f), Float.valueOf(0.8f)), Arrays.asList(3, 2, 1));
                builder.pop();
            }
        }

        public static class ConditionConstant {
            public final ForgeConfigSpec.BooleanValue enabled;
            public final ForgeConfigSpec.ConfigValue<List<? extends Float>> healthPercentageLeft;
            public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> debuffStrength;

            public ConditionConstant(ForgeConfigSpec.Builder builder, String name, List<Float> defaultPercentage, List<Integer> defaultStrength) {
                builder.push(name);
                this.enabled = builder.comment("Enables/Disables this debuff").translation("firstaid.config.debuff.enabled").define("enabled", true);
                this.healthPercentageLeft = builder.comment("How much health the user must have left for the debuff to apply at the mapped length. Must be sorted so the **lowest** value comes first").translation("firstaid.config.debuff.healthpercentageleft").defineList("healthPercentageLeft", defaultPercentage, o -> {
                    try {
                        float val = Float.parseFloat(o.toString());
                        return val >= 0.0f && val <= 1.0f;
                    }
                    catch (NumberFormatException numberFormatException) {
                        FirstAid.LOGGER.warn("Invalid entry " + o.toString() + " for healthPercentageLeft at " + name);
                        return false;
                    }
                });
                this.debuffStrength = builder.comment("How strong the potion effect should stay. If the first condition from the healthPercentageLeft config is met, the first value in this list will be taken").translation("firstaid.config.debuff.debuffstrength").defineList("debuffStrength", defaultStrength, o -> {
                    try {
                        float val = Float.parseFloat(o.toString());
                        return val >= 0.0f && val <= 32767.0f;
                    }
                    catch (NumberFormatException numberFormatException) {
                        FirstAid.LOGGER.warn("Invalid entry " + o.toString() + " for debuffStrength at " + name);
                        return false;
                    }
                });
                builder.pop();
            }
        }

        public static class ConditionOnHit {
            public final ForgeConfigSpec.BooleanValue enabled;
            public final ForgeConfigSpec.ConfigValue<List<? extends Float>> damageTaken;
            public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> debuffLength;

            public ConditionOnHit(ForgeConfigSpec.Builder builder, String name, List<Float> defaultTaken, List<Integer> defaultLength) {
                builder.push(name);
                this.enabled = builder.comment("Enables/Disables this debuff").translation("firstaid.config.debuff.enabled").define("enabled", true);
                this.damageTaken = builder.comment("How much damage the user must have taken for the debuff to apply at the mapped length. Must be sorted so the **highest** value comes first. 2 = 1 heart").translation("firstaid.config.debuff.damagetaken").defineList("damageTaken", defaultTaken, o -> {
                    try {
                        float val = Float.parseFloat(o.toString());
                        return val >= 0.0f && val <= 10.0f;
                    }
                    catch (NumberFormatException numberFormatException) {
                        FirstAid.LOGGER.warn("Invalid entry " + o.toString() + " for damageTaken at " + name);
                        return false;
                    }
                });
                this.debuffLength = builder.comment("How long the debuff should stay. If the first condition from the damageTaken config is met, the first value in this list will be taken").translation("firstaid.config.debuff.debufflength").defineList("debuffLength", defaultLength, o -> {
                    try {
                        float val = Float.parseFloat(o.toString());
                        return val >= 0.0f && val <= 32767.0f;
                    }
                    catch (NumberFormatException numberFormatException) {
                        FirstAid.LOGGER.warn("Invalid entry " + o.toString() + " for debuffLength at " + name);
                        return false;
                    }
                });
                builder.pop();
            }
        }
    }

    public static class Client {
        public final ForgeConfigSpec.EnumValue<VanillaHealthbarMode> vanillaHealthBarMode;
        public final ForgeConfigSpec.EnumValue<OverlayMode> overlayMode;
        public final ForgeConfigSpec.EnumValue<Position> pos;
        public final ForgeConfigSpec.EnumValue<TooltipMode> armorTooltipMode;
        public final ForgeConfigSpec.IntValue xOffset;
        public final ForgeConfigSpec.IntValue yOffset;
        public final ForgeConfigSpec.IntValue alpha;
        public final ForgeConfigSpec.BooleanValue enableSounds;
        public final ForgeConfigSpec.BooleanValue enableEasterEggs;
        public final ForgeConfigSpec.IntValue visibleDurationTicks;
        public final ForgeConfigSpec.BooleanValue flash;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client only configuration settings").push("Overlay");
            this.vanillaHealthBarMode = builder.comment(new String[]{"The mode how to show the mc vanilla health bar.", "NORMAL shows the vanilla health value that calculated the way vanillaHealthCalculation is specified (server config)", "HIGHLIGHT_CRITICAL_PATH show the vanilla health value and highlights the health value of the most damaged critical limb (by default head or body) using the hardcore-styled hearts for them and the normal hearts for the rest of the health. Only works if vanillaHealthCalculation is set to AVERAGE_ALL", "HIDE just doesn't display the vanilla health bar at all."}).translation("firstaid.config.vanillahealthbarmode").defineEnum("vanillaHealthBarMode", (Enum)VanillaHealthbarMode.HIDE);
            this.overlayMode = builder.comment("The design to use to visualize the health").defineEnum("overlayMode", (Enum)OverlayMode.PLAYER_MODEL);
            this.pos = builder.comment("The relative point of the overlay").translation("firstaid.config.position").defineEnum("overlayPosition", (Enum)Position.TOP_LEFT);
            this.armorTooltipMode = builder.comment(new String[]{"Determines how first aid should display armor on item tooltips.", "REPLACE replaces the vanilla description with the one fitting first aid\nAPPEND will add the first aid values at the bottom", "NONE will show the old vanilla values. Be advised this is purly visual, interally, the first aid value will always be used"}).defineEnum("armorTooltipMode", (Enum)TooltipMode.REPLACE);
            this.xOffset = builder.comment("The offset on the x axis").translation("firstaid.config.xoffset").defineInRange("xOffset", 0, Short.MIN_VALUE, Short.MAX_VALUE);
            this.yOffset = builder.comment("The offset on the y axis").translation("firstaid.config.yoffset").defineInRange("yOffset", 1, Short.MIN_VALUE, Short.MAX_VALUE);
            this.alpha = builder.comment("Determines the transparency of the overlay. 200 = Maximum transparency, 0 = Fully opaque").translation("firstaid.config.alpha").defineInRange("alpha", 50, 0, 200);
            this.visibleDurationTicks = builder.translation("firstaid.config.visibledurationticks").comment(new String[]{"Specifies how many ticks (20 ticks = 1 second) the overlay should be visible after health changed (healing/damaging)", "If set to -1, the HUD is always visible"}).defineInRange("visibleDurationTicks", -1, -1, 600);
            this.flash = builder.translation("firstaid.config.flash").comment("If set to true, the overlay will flash for a short moment if the health changed. Only affects PLAYER_MODEL overlay").define("flash", true);
            builder.pop();
            builder.push("Misc");
            this.enableSounds = builder.comment("Set to true to enable the debuff sounds. Only matters when debuffs are enabled").translation("firstaid.config.enablesoundsystem").define("enableSoundSystem", true);
            this.enableEasterEggs = builder.comment("Disables the funny easter eggs on certain events if false").define("enableEasterEggs", true);
            builder.pop();
        }

        public static enum VanillaHealthbarMode {
            NORMAL,
            HIGHLIGHT_CRITICAL_PATH,
            HIDE;

        }

        public static enum OverlayMode {
            OFF,
            NUMBERS,
            HEARTS,
            PLAYER_MODEL,
            PLAYER_MODEL_4_COLORS;


            public boolean isPlayerModel() {
                return this == PLAYER_MODEL || this == PLAYER_MODEL_4_COLORS;
            }
        }

        public static enum Position {
            TOP_LEFT,
            TOP_RIGHT,
            BOTTOM_RIGHT,
            BOTTOM_LEFT;

        }

        public static enum TooltipMode {
            REPLACE,
            APPEND,
            NONE;

        }
    }
}

