/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.client.ClientHooks;
import ichttt.mods.firstaid.client.HUDHandler;
import ichttt.mods.firstaid.client.gui.GuiHoldButton;
import ichttt.mods.firstaid.client.util.EventCalendar;
import ichttt.mods.firstaid.client.util.HealthRenderUtils;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.network.MessageApplyHealingItem;
import ichttt.mods.firstaid.common.network.MessageClientRequest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GuiHealthScreen
extends Screen {
    public static final int xSize = 256;
    public static final int ySize = 137;
    public static final ItemStack BED_ITEMSTACK = new ItemStack((ItemLike)Items.f_42570_);
    private static final DecimalFormat FORMAT = new DecimalFormat("##.#");
    public static GuiHealthScreen INSTANCE;
    public static boolean isOpen;
    private static int funTicks;
    private final AbstractPlayerDamageModel damageModel;
    private final List<GuiHoldButton> holdButtons = new ArrayList<GuiHoldButton>();
    private final boolean disableButtons;
    private final float bedScaleFactor = EventCalendar.isGuiFun() ? 1.5f : 1.25f;
    public int guiLeft;
    public int guiTop;
    public AbstractButton cancelButton;
    private AbstractButton head;
    private AbstractButton leftArm;
    private AbstractButton leftLeg;
    private AbstractButton leftFoot;
    private AbstractButton body;
    private AbstractButton rightArm;
    private AbstractButton rightLeg;
    private AbstractButton rightFoot;
    private InteractionHand activeHand;

    public GuiHealthScreen(AbstractPlayerDamageModel damageModel) {
        super((Component)new TranslatableComponent("firstaid.gui.healthscreen"));
        this.damageModel = damageModel;
        this.disableButtons = true;
    }

    public GuiHealthScreen(AbstractPlayerDamageModel damageModel, InteractionHand activeHand) {
        super((Component)new TranslatableComponent("firstaid.gui.healthscreen"));
        this.damageModel = damageModel;
        this.activeHand = activeHand;
        this.disableButtons = false;
    }

    public static void tickFun() {
        if (++funTicks > 500) {
            funTicks = (int)(Math.random() * 100.0);
        }
    }

    public void m_7856_() {
        isOpen = true;
        this.guiLeft = (this.f_96543_ - 256) / 2;
        this.guiTop = (this.f_96544_ - 137) / 2;
        this.head = new GuiHoldButton(1, this.guiLeft + 4, this.guiTop + 8, 52, 20, (Component)new TranslatableComponent("firstaid.gui.head"), false);
        this.m_142416_((GuiEventListener)this.head);
        this.leftArm = new GuiHoldButton(2, this.guiLeft + 4, this.guiTop + 33, 52, 20, (Component)new TranslatableComponent("firstaid.gui.left_arm"), false);
        this.m_142416_((GuiEventListener)this.leftArm);
        this.leftLeg = new GuiHoldButton(3, this.guiLeft + 4, this.guiTop + 58, 52, 20, (Component)new TranslatableComponent("firstaid.gui.left_leg"), false);
        this.m_142416_((GuiEventListener)this.leftLeg);
        this.leftFoot = new GuiHoldButton(4, this.guiLeft + 4, this.guiTop + 83, 52, 20, (Component)new TranslatableComponent("firstaid.gui.left_foot"), false);
        this.m_142416_((GuiEventListener)this.leftFoot);
        this.body = new GuiHoldButton(5, this.guiLeft + 199, this.guiTop + 8, 52, 20, (Component)new TranslatableComponent("firstaid.gui.body"), true);
        this.m_142416_((GuiEventListener)this.body);
        this.rightArm = new GuiHoldButton(6, this.guiLeft + 199, this.guiTop + 33, 52, 20, (Component)new TranslatableComponent("firstaid.gui.right_arm"), true);
        this.m_142416_((GuiEventListener)this.rightArm);
        this.rightLeg = new GuiHoldButton(7, this.guiLeft + 199, this.guiTop + 58, 52, 20, (Component)new TranslatableComponent("firstaid.gui.right_leg"), true);
        this.m_142416_((GuiEventListener)this.rightLeg);
        this.rightFoot = new GuiHoldButton(8, this.guiLeft + 199, this.guiTop + 83, 52, 20, (Component)new TranslatableComponent("firstaid.gui.right_foot"), true);
        this.m_142416_((GuiEventListener)this.rightFoot);
        if (this.disableButtons) {
            this.head.f_93623_ = false;
            this.leftArm.f_93623_ = false;
            this.leftLeg.f_93623_ = false;
            this.leftFoot.f_93623_ = false;
            this.body.f_93623_ = false;
            this.rightArm.f_93623_ = false;
            this.rightLeg.f_93623_ = false;
            this.rightFoot.f_93623_ = false;
        }
        this.cancelButton = new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 50, 200, 20, (Component)new TranslatableComponent(this.disableButtons ? "gui.done" : "gui.cancel"), button -> this.m_7379_());
        this.m_142416_((GuiEventListener)this.cancelButton);
        if (this.f_96541_.f_91066_.f_92063_) {
            Button refresh = new Button(this.guiLeft + 218, this.guiTop + 115, 36, 20, (Component)new TextComponent("resync"), button -> {
                FirstAid.NETWORKING.sendToServer((Object)new MessageClientRequest(MessageClientRequest.Type.REQUEST_REFRESH));
                FirstAid.LOGGER.info("Requesting refresh");
                this.f_96541_.f_91074_.m_5661_((Component)new TextComponent("Re-downloading health data from server..."), true);
                this.m_7379_();
            });
            this.m_142416_((GuiEventListener)refresh);
        }
        this.holdButtons.clear();
        for (AbstractWidget button2 : this.getButtons()) {
            Integer holdTime;
            if (!(button2 instanceof GuiHoldButton)) continue;
            Integer n = holdTime = this.activeHand == null ? null : FirstAidRegistryImpl.INSTANCE.getPartHealingTime(this.f_96541_.f_91074_.m_21120_(this.activeHand));
            if (holdTime == null) {
                holdTime = Integer.MAX_VALUE;
            }
            ((GuiHoldButton)button2).setup(holdTime, (float)button2.m_5711_() / (float)HUDHandler.INSTANCE.getMaxLength());
            this.holdButtons.add((GuiHoldButton)button2);
        }
        super.m_7856_();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        this.m_93179_(stack, this.guiLeft, this.guiTop, this.guiLeft + 256, this.guiTop + 137, -16777216, -16777216);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HealthRenderUtils.GUI_LOCATION);
        this.m_93228_(stack, this.guiLeft, this.guiTop, 0, 0, 256, 137);
        int entityLookX = this.guiLeft + 128 - mouseX;
        int entityLookY = this.guiTop + 20 - mouseY;
        if (EventCalendar.isGuiFun()) {
            if (EventCalendar.isHalloween()) {
                if (funTicks > 250 && funTicks < 270 || funTicks > 330 && funTicks < 340) {
                    entityLookX = 0;
                    entityLookY = 0;
                } else if (funTicks > 480 && funTicks < 500 || funTicks > 340 && funTicks < 350) {
                    entityLookX = -entityLookX;
                    entityLookY = -entityLookY;
                }
            } else {
                entityLookX = -entityLookX;
                entityLookY = -entityLookY;
            }
        }
        InventoryScreen.m_98850_((int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 30), (int)45, (float)entityLookX, (float)entityLookY, (LivingEntity)this.f_96541_.f_91074_);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        int morphineTicks = this.damageModel.getMorphineTicks();
        if (morphineTicks > 0) {
            GuiHealthScreen.m_93208_((PoseStack)stack, (Font)this.f_96541_.f_91062_, (String)I18n.m_118938_((String)"firstaid.gui.morphine_left", (Object[])new Object[]{StringUtil.m_14404_((int)morphineTicks)}), (int)(this.guiLeft + 128), (int)(this.guiTop + 137 - (this.activeHand == null ? 21 : 29)), (int)0xFFFFFF);
        }
        if (this.activeHand != null) {
            GuiHealthScreen.m_93208_((PoseStack)stack, (Font)this.f_96541_.f_91062_, (String)I18n.m_118938_((String)"firstaid.gui.apply_hint", (Object[])new Object[0]), (int)(this.guiLeft + 128), (int)(this.guiTop + 137 - (morphineTicks == 0 ? 21 : 11)), (int)0xFFFFFF);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawHealth(stack, this.damageModel.HEAD, false, 14);
        this.drawHealth(stack, this.damageModel.LEFT_ARM, false, 39);
        this.drawHealth(stack, this.damageModel.LEFT_LEG, false, 64);
        this.drawHealth(stack, this.damageModel.LEFT_FOOT, false, 89);
        this.drawHealth(stack, this.damageModel.BODY, true, 14);
        this.drawHealth(stack, this.damageModel.RIGHT_ARM, true, 39);
        this.drawHealth(stack, this.damageModel.RIGHT_LEG, true, 64);
        this.drawHealth(stack, this.damageModel.RIGHT_FOOT, true, 89);
        stack.m_85836_();
        this.tooltipButton(stack, this.head, this.damageModel.HEAD, mouseX, mouseY);
        this.tooltipButton(stack, this.leftArm, this.damageModel.LEFT_ARM, mouseX, mouseY);
        this.tooltipButton(stack, this.leftLeg, this.damageModel.LEFT_LEG, mouseX, mouseY);
        this.tooltipButton(stack, this.leftFoot, this.damageModel.LEFT_FOOT, mouseX, mouseY);
        this.tooltipButton(stack, this.body, this.damageModel.BODY, mouseX, mouseY);
        this.tooltipButton(stack, this.rightArm, this.damageModel.RIGHT_ARM, mouseX, mouseY);
        this.tooltipButton(stack, this.rightLeg, this.damageModel.RIGHT_LEG, mouseX, mouseY);
        this.tooltipButton(stack, this.rightFoot, this.damageModel.RIGHT_FOOT, mouseX, mouseY);
        stack.m_85849_();
        double sleepHealing = (Double)FirstAidConfig.SERVER.sleepHealPercentage.get();
        int renderBedX = Math.round((float)this.guiLeft / this.bedScaleFactor) + 2;
        int renderBedY = Math.round((float)(this.guiTop + 137) / this.bedScaleFactor) - 18;
        int bedX = (int)((float)renderBedX * this.bedScaleFactor);
        int bedY = (int)((float)renderBedY * this.bedScaleFactor);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85841_(this.bedScaleFactor, this.bedScaleFactor, this.bedScaleFactor);
        RenderSystem.m_157182_();
        this.f_96541_.m_91291_().m_115203_(BED_ITEMSTACK, renderBedX, renderBedY);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        if (mouseX >= bedX && mouseY >= bedY && (float)mouseX < (float)bedX + 16.0f * this.bedScaleFactor && (float)mouseY < (float)bedY + 16.0f * this.bedScaleFactor) {
            TranslatableComponent s = sleepHealing == 0.0 ? new TranslatableComponent("firstaid.gui.no_sleep_heal") : new TranslatableComponent("firstaid.gui.sleep_heal_amount", new Object[]{FORMAT.format(sleepHealing * 100.0)});
            this.m_96602_(stack, (Component)s, mouseX, mouseY);
        }
        this.holdButtonMouseCallback(stack);
    }

    private void tooltipButton(PoseStack stack, AbstractButton button, AbstractDamageablePart part, int mouseX, int mouseY) {
        boolean enabled;
        boolean bl = enabled = part.activeHealer == null;
        if (!enabled && button.m_5702_()) {
            this.m_96597_(stack, Arrays.asList(new TextComponent(I18n.m_118938_((String)"firstaid.gui.active_item", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)part.activeHealer.stack.m_41778_(), (Object[])new Object[0])), new TranslatableComponent("firstaid.gui.next_heal", new Object[]{Math.round((float)(part.activeHealer.ticksPerHeal.getAsInt() - part.activeHealer.getTicksPassed()) / 20.0f)})), mouseX, mouseY);
        }
        if (!this.disableButtons) {
            button.f_93623_ = enabled;
        }
    }

    public void drawHealth(PoseStack stack, AbstractDamageablePart damageablePart, boolean right, int yOffset) {
        stack.m_85836_();
        int xTranslation = this.guiLeft + (right ? GuiHealthScreen.getRightOffset(damageablePart) : 57);
        HealthRenderUtils.drawHealth(stack, damageablePart, xTranslation, this.guiTop + yOffset, (GuiComponent)this, true);
        stack.m_85849_();
    }

    private static int getRightOffset(AbstractDamageablePart damageablePart) {
        if (HealthRenderUtils.drawAsString(damageablePart, true)) {
            return 160;
        }
        return 200 - Math.min(40, HealthRenderUtils.getMaxHearts(damageablePart.getMaxHealth()) * 9 + HealthRenderUtils.getMaxHearts(damageablePart.getAbsorption()) * 9 + 2);
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (ClientHooks.SHOW_WOUNDS.isActiveAndMatches(InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.holdButtonMouseCallback(null);
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public void m_94757_(double xPos, double yPos) {
        for (GuiHoldButton holdButton : this.holdButtons) {
            holdButton.m_94757_(xPos, yPos);
        }
    }

    protected void holdButtonMouseCallback(PoseStack stack) {
        for (GuiHoldButton button : this.holdButtons) {
            int timeLeft = button.getTimeLeft();
            if (timeLeft == 0) {
                button.reset();
                EnumPlayerPart playerPart = EnumPlayerPart.VALUES[button.id - 1];
                FirstAid.NETWORKING.sendToServer((Object)new MessageApplyHealingItem(playerPart, this.activeHand));
                AbstractDamageablePart part = this.damageModel.getFromEnum(playerPart);
                part.activeHealer = FirstAidRegistryImpl.INSTANCE.getPartHealer(this.f_96541_.f_91074_.m_21120_(this.activeHand));
                this.m_7379_();
                continue;
            }
            if (stack == null) {
                button.reset();
                continue;
            }
            if (timeLeft == -1) continue;
            float timeInSecs = (float)timeLeft / 1000.0f;
            if (timeInSecs < 0.0f) {
                timeInSecs = 0.0f;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)HealthRenderUtils.GUI_LOCATION);
            this.m_93228_(stack, button.f_93620_ + (button.isRightSide ? 56 : -25), button.f_93621_ - 2, button.isRightSide ? 2 : 0, 169, 22, 24);
            this.f_96541_.f_91062_.m_92883_(stack, HealthRenderUtils.TEXT_FORMAT.format(timeInSecs), (float)(button.f_93620_ + (button.isRightSide ? 60 : -20)), (float)(button.f_93621_ + 6), 0xFFFFFF);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_7379_() {
        INSTANCE = null;
        isOpen = false;
        super.m_7379_();
    }

    public List<AbstractWidget> getButtons() {
        return this.f_169369_;
    }

    static {
        isOpen = false;
        funTicks = 0;
    }
}

