/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem.debuff;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.common.damagesystem.debuff.AbstractDebuff;
import ichttt.mods.firstaid.common.network.MessagePlayHurtSound;
import it.unimi.dsi.fastutil.floats.Float2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2IntMap;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class OnHitDebuff
extends AbstractDebuff {
    @Nullable
    private final Supplier<SoundEvent> sound;

    public OnHitDebuff(@Nonnull String potionName, @Nonnull Float2IntLinkedOpenHashMap map, @Nonnull BooleanSupplier isEnabled, @Nullable Supplier<SoundEvent> sound) {
        super(potionName, map, isEnabled);
        this.sound = sound;
    }

    @Override
    public void handleDamageTaken(float damage, float healthPerMax, ServerPlayer player) {
        if (!this.isEnabled.getAsBoolean()) {
            return;
        }
        int value = -1;
        for (Float2IntMap.Entry entry : this.map.float2IntEntrySet()) {
            if (!(damage >= entry.getFloatKey())) continue;
            value = Math.max(value, entry.getIntValue());
            player.m_7292_(new MobEffectInstance(this.effect, entry.getIntValue(), 0, false, false));
        }
        if (value != -1 && this.sound != null) {
            FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessagePlayHurtSound(this.sound.get(), value));
        }
    }

    @Override
    public void handleHealing(float healingDone, float healthPerMax, ServerPlayer player) {
    }
}

