/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem.distribution;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.api.event.FirstAidLivingDamageEvent;
import ichttt.mods.firstaid.common.EventHandler;
import ichttt.mods.firstaid.common.damagesystem.PlayerDamageModel;
import ichttt.mods.firstaid.common.damagesystem.distribution.RandomDamageDistribution;
import ichttt.mods.firstaid.common.network.MessageUpdatePart;
import ichttt.mods.firstaid.common.util.ArmorUtils;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public abstract class DamageDistribution
implements IDamageDistribution {
    public static float handleDamageTaken(IDamageDistribution damageDistribution, AbstractPlayerDamageModel damageModel, float damage, @Nonnull Player player, @Nonnull DamageSource source, boolean addStat, boolean redistributeIfLeft) {
        boolean hasTriedNoKill;
        float left;
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            FirstAid.LOGGER.info("--- Damaging {} using {} for dmg source {}, redistribute {}, addStat {} ---", (Object)Float.valueOf(damage), (Object)damageDistribution.toString(), (Object)source.f_19326_, (Object)redistributeIfLeft, (Object)addStat);
        }
        CompoundTag beforeCache = (CompoundTag)damageModel.serializeNBT();
        if (!damageDistribution.skipGlobalPotionModifiers()) {
            damage = ArmorUtils.applyGlobalPotionModifiers(player, source, damage);
        }
        if (damage != 0.0f) {
            player.m_36399_(source.m_19377_());
            float currentHealth = player.m_21223_();
            player.m_21231_().m_19289_(source, currentHealth, damage);
        }
        if ((left = damageDistribution.distributeDamage(damage, player, source, addStat)) > 0.0f && redistributeIfLeft && (left = (damageDistribution = (hasTriedNoKill = damageDistribution == RandomDamageDistribution.NEAREST_NOKILL || damageDistribution == RandomDamageDistribution.ANY_NOKILL) ? RandomDamageDistribution.NEAREST_KILL : RandomDamageDistribution.getDefault()).distributeDamage(left, player, source, addStat)) > 0.0f && !hasTriedNoKill) {
            damageDistribution = RandomDamageDistribution.NEAREST_KILL;
            left = damageDistribution.distributeDamage(left, player, source, addStat);
        }
        PlayerDamageModel before = PlayerDamageModel.create();
        before.deserializeNBT(beforeCache);
        if (MinecraftForge.EVENT_BUS.post((Event)new FirstAidLivingDamageEvent(player, damageModel, before, source, left))) {
            damageModel.deserializeNBT((Tag)beforeCache);
            if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                FirstAid.LOGGER.info("--- DONE! Event got canceled ---");
            }
            return 0.0f;
        }
        if (damageModel.isDead(player)) {
            CommonUtils.killPlayer(damageModel, player, source);
        }
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            FirstAid.LOGGER.info("--- DONE! {} still left ---", (Object)Float.valueOf(left));
        }
        return left;
    }

    protected float minHealth(@Nonnull Player player, @Nonnull AbstractDamageablePart part) {
        return 0.0f;
    }

    protected float distributeDamageOnParts(float damage, @Nonnull AbstractPlayerDamageModel damageModel, @Nonnull EnumPlayerPart[] enumParts, @Nonnull Player player, boolean addStat) {
        ArrayList<AbstractDamageablePart> damageableParts = new ArrayList<AbstractDamageablePart>(enumParts.length);
        for (EnumPlayerPart part : enumParts) {
            damageableParts.add(damageModel.getFromEnum(part));
        }
        Collections.shuffle(damageableParts);
        for (AbstractDamageablePart part : damageableParts) {
            float minHealth = this.minHealth(player, part);
            float dmgDone = damage - part.damage(damage, player, !player.m_21023_(EventHandler.MORPHINE), minHealth);
            FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageUpdatePart(part));
            if (addStat) {
                player.m_36222_(Stats.f_12931_, Math.round(dmgDone * 10.0f));
            }
            if ((damage -= dmgDone) == 0.0f) break;
            if (!(damage < 0.0f)) continue;
            FirstAid.LOGGER.error("Got negative damage {} left? Logic error? ", (Object)Float.valueOf(damage));
            break;
        }
        return damage;
    }

    @Nonnull
    protected abstract List<Pair<EquipmentSlot, EnumPlayerPart[]>> getPartList();

    @Override
    public float distributeDamage(float damage, @Nonnull Player player, @Nonnull DamageSource source, boolean addStat) {
        if (damage <= 0.0f) {
            return 0.0f;
        }
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(player);
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            FirstAid.LOGGER.info("Starting distribution of {} damage...", (Object)Float.valueOf(damage));
        }
        for (Pair<EquipmentSlot, EnumPlayerPart[]> pair : this.getPartList()) {
            EquipmentSlot slot = (EquipmentSlot)pair.getLeft();
            EnumPlayerPart[] parts = (EnumPlayerPart[])pair.getRight();
            if (Arrays.stream(parts).map(damageModel::getFromEnum).anyMatch(part -> part.currentHealth > this.minHealth(player, (AbstractDamageablePart)part))) {
                float originalDamage = damage;
                damage = ArmorUtils.applyArmor(player, player.m_6844_(slot), source, damage, slot);
                if (damage <= 0.0f) {
                    return 0.0f;
                }
                if ((damage = ArmorUtils.applyEnchantmentModifiers(player, slot, source, damage)) <= 0.0f) {
                    return 0.0f;
                }
                if ((damage = ForgeHooks.onLivingDamage((LivingEntity)player, (DamageSource)source, (float)damage)) <= 0.0f) {
                    return 0.0f;
                }
                float dmgAfterReduce = damage;
                if ((damage = this.distributeDamageOnParts(damage, damageModel, parts, player, addStat)) == 0.0f) break;
                float absorbFactor = originalDamage / dmgAfterReduce;
                float damageDistributed = dmgAfterReduce - damage;
                damage = originalDamage - damageDistributed * absorbFactor;
                if (!((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) continue;
                FirstAid.LOGGER.info("Distribution round: Not done yet, going to next round. Needed to distribute {} damage (reduced to {}) to {}, but only distributed {}. New damage to be distributed is {}, based on absorb factor {}", (Object)Float.valueOf(originalDamage), (Object)Float.valueOf(dmgAfterReduce), (Object)slot, (Object)Float.valueOf(damageDistributed), (Object)Float.valueOf(damage), (Object)Float.valueOf(absorbFactor));
                continue;
            }
            if (!((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) continue;
            FirstAid.LOGGER.info("Skipping {}, no health > min in parts!", (Object)slot);
        }
        return damage;
    }
}

