/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem.distribution;

import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;

public class RandomDamageDistribution
extends DamageDistribution {
    public static final RandomDamageDistribution NEAREST_NOKILL = new RandomDamageDistribution(true, true);
    public static final RandomDamageDistribution NEAREST_KILL = new RandomDamageDistribution(true, false);
    public static final RandomDamageDistribution ANY_NOKILL = new RandomDamageDistribution(false, true);
    public static final RandomDamageDistribution ANY_KILL = new RandomDamageDistribution(false, false);
    private static final Random RANDOM = new Random();
    private final boolean nearestFirst;
    private final boolean tryNoKill;

    public static RandomDamageDistribution getDefault() {
        return (Boolean)FirstAidConfig.SERVER.useFriendlyRandomDistribution.get() != false ? NEAREST_NOKILL : NEAREST_KILL;
    }

    protected RandomDamageDistribution(boolean nearestFirst, boolean tryNoKill) {
        this.nearestFirst = nearestFirst;
        this.tryNoKill = tryNoKill;
    }

    @Override
    protected float minHealth(@Nonnull Player player, @Nonnull AbstractDamageablePart playerPart) {
        if (this.tryNoKill && playerPart.canCauseDeath) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    @Nonnull
    protected List<Pair<EquipmentSlot, EnumPlayerPart[]>> getPartList() {
        if (this.nearestFirst) {
            int startValue = RANDOM.nextInt(4);
            return RandomDamageDistribution.addAllRandom(startValue, RANDOM.nextBoolean());
        }
        ArrayList<Pair<EquipmentSlot, EnumPlayerPart[]>> partList = new ArrayList<Pair<EquipmentSlot, EnumPlayerPart[]>>();
        List<EquipmentSlot> slots = Arrays.asList(EquipmentSlot.values());
        Collections.shuffle(slots, RANDOM);
        for (EquipmentSlot slot : slots) {
            if (!CommonUtils.isValidArmorSlot(slot)) continue;
            List<EnumPlayerPart> parts = CommonUtils.getPartListForSlot(slot);
            Collections.shuffle(parts);
            partList.add((Pair<EquipmentSlot, EnumPlayerPart[]>)Pair.of((Object)slot, (Object)parts.toArray(new EnumPlayerPart[0])));
        }
        return partList;
    }

    public static List<Pair<EquipmentSlot, EnumPlayerPart[]>> addAllRandom(int startValue, boolean up) {
        ArrayList<Pair<EquipmentSlot, EnumPlayerPart[]>> partList = new ArrayList<Pair<EquipmentSlot, EnumPlayerPart[]>>();
        for (int i = 0; i < CommonUtils.ARMOR_SLOTS.length; ++i) {
            int posInArray = Math.abs(i - (up ? 0 : 3)) + startValue;
            if (posInArray > 3) {
                posInArray -= 4;
            }
            EquipmentSlot slot = CommonUtils.ARMOR_SLOTS[posInArray];
            List<EnumPlayerPart> parts = CommonUtils.getPartListForSlot(slot);
            Collections.shuffle(parts);
            partList.add((Pair<EquipmentSlot, EnumPlayerPart[]>)Pair.of((Object)slot, (Object)parts.toArray(new EnumPlayerPart[0])));
        }
        return partList;
    }
}

