/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.client.ClientHooks;
import ichttt.mods.firstaid.client.HUDHandler;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MessageConfiguration {
    private final CompoundTag playerDamageModel;

    public MessageConfiguration(CompoundTag model) {
        this.playerDamageModel = model;
    }

    public MessageConfiguration(FriendlyByteBuf buffer) {
        this(buffer.m_130260_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.playerDamageModel);
    }

    public static class Handler {
        public static void onMessage(MessageConfiguration message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            CommonUtils.checkClient(ctx);
            FirstAid.LOGGER.info("Received remote damage model");
            ctx.enqueueWork(() -> {
                AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((Player)Minecraft.m_91087_().f_91074_);
                damageModel.deserializeNBT((Tag)message.playerDamageModel);
                if (damageModel.hasTutorial) {
                    CapProvider.tutorialDone.add(Minecraft.m_91087_().f_91074_.m_7755_().getString());
                } else {
                    Minecraft.m_91087_().f_91074_.m_6352_((Component)new TextComponent("[First Aid] " + I18n.m_118938_((String)"firstaid.tutorial.hint", (Object[])new Object[]{ClientHooks.SHOW_WOUNDS.m_90863_().getString()})), Util.f_137441_);
                }
                HUDHandler.INSTANCE.ticker = 200;
                FirstAid.isSynced = true;
            });
        }
    }
}

