/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.util;

import com.google.common.math.DoubleMath;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.commons.lang3.mutable.MutableInt;

public class ArmorUtils {
    public static double getArmor(ItemStack stack, EquipmentSlot slot) {
        return ArmorUtils.getValueFromAttributes(Attributes.f_22284_, slot, stack);
    }

    public static double getArmorToughness(ItemStack stack, EquipmentSlot slot) {
        return ArmorUtils.getValueFromAttributes(Attributes.f_22285_, slot, stack);
    }

    public static double applyArmorModifier(EquipmentSlot slot, double rawArmor) {
        if (rawArmor <= 0.0) {
            return 0.0;
        }
        rawArmor *= ArmorUtils.getArmorMultiplier(slot);
        return rawArmor += ArmorUtils.getArmorOffset(slot);
    }

    public static double applyToughnessModifier(EquipmentSlot slot, double rawToughness) {
        if (rawToughness <= 0.0) {
            return 0.0;
        }
        rawToughness *= ArmorUtils.getToughnessMultiplier(slot);
        return rawToughness += ArmorUtils.getToughnessOffset(slot);
    }

    private static double getArmorMultiplier(EquipmentSlot slot) {
        FirstAidConfig.Server config = FirstAidConfig.SERVER;
        switch (slot) {
            case HEAD: {
                return (Double)config.headArmorMultiplier.get();
            }
            case CHEST: {
                return (Double)config.chestArmorMultiplier.get();
            }
            case LEGS: {
                return (Double)config.legsArmorMultiplier.get();
            }
            case FEET: {
                return (Double)config.feetArmorMultiplier.get();
            }
        }
        throw new IllegalArgumentException("Invalid slot " + slot);
    }

    private static double getArmorOffset(EquipmentSlot slot) {
        FirstAidConfig.Server config = FirstAidConfig.SERVER;
        switch (slot) {
            case HEAD: {
                return (Double)config.headArmorOffset.get();
            }
            case CHEST: {
                return (Double)config.chestArmorOffset.get();
            }
            case LEGS: {
                return (Double)config.legsArmorOffset.get();
            }
            case FEET: {
                return (Double)config.feetArmorOffset.get();
            }
        }
        throw new IllegalArgumentException("Invalid slot " + slot);
    }

    private static double getToughnessMultiplier(EquipmentSlot slot) {
        FirstAidConfig.Server config = FirstAidConfig.SERVER;
        switch (slot) {
            case HEAD: {
                return (Double)config.headThoughnessMultiplier.get();
            }
            case CHEST: {
                return (Double)config.chestThoughnessMultiplier.get();
            }
            case LEGS: {
                return (Double)config.legsThoughnessMultiplier.get();
            }
            case FEET: {
                return (Double)config.feetThoughnessMultiplier.get();
            }
        }
        throw new IllegalArgumentException("Invalid slot " + slot);
    }

    private static double getToughnessOffset(EquipmentSlot slot) {
        FirstAidConfig.Server config = FirstAidConfig.SERVER;
        switch (slot) {
            case HEAD: {
                return (Double)config.headThoughnessOffset.get();
            }
            case CHEST: {
                return (Double)config.chestThoughnessOffset.get();
            }
            case LEGS: {
                return (Double)config.legsThoughnessOffset.get();
            }
            case FEET: {
                return (Double)config.feetThoughnessOffset.get();
            }
        }
        throw new IllegalArgumentException("Invalid slot " + slot);
    }

    private static double getValueFromAttributes(Attribute attribute, EquipmentSlot slot, ItemStack stack) {
        return stack.m_41638_(slot).get((Object)attribute).stream().mapToDouble(AttributeModifier::m_22218_).sum();
    }

    private static double getGlobalRestAttribute(Player player, Attribute attribute) {
        double sumOfAllAttributes = 0.0;
        for (EquipmentSlot slot : CommonUtils.ARMOR_SLOTS) {
            ItemStack otherStack = player.m_6844_(slot);
            sumOfAllAttributes += ArmorUtils.getValueFromAttributes(attribute, slot, otherStack);
        }
        double all = player.m_21133_(attribute);
        if (!DoubleMath.fuzzyEquals((double)sumOfAllAttributes, (double)all, (double)0.001)) {
            double diff = all - sumOfAllAttributes;
            if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                FirstAid.LOGGER.info("Attribute value for {} does not match sum! Diff is {}, distributing to all!", (Object)attribute.getRegistryName(), (Object)diff);
            }
            return diff;
        }
        return 0.0;
    }

    public static float applyArmor(@Nonnull Player entity, @Nonnull ItemStack itemStack, @Nonnull DamageSource source, float damage, @Nonnull EquipmentSlot slot) {
        if (source.m_19376_()) {
            return damage;
        }
        Item item = itemStack.m_41720_();
        float totalArmor = 0.0f;
        float totalToughness = 0.0f;
        if (item instanceof ArmorItem) {
            totalArmor = (float)ArmorUtils.getValueFromAttributes(Attributes.f_22284_, slot, itemStack);
            totalToughness = (float)ArmorUtils.getValueFromAttributes(Attributes.f_22285_, slot, itemStack);
            totalArmor = (float)ArmorUtils.applyArmorModifier(slot, totalArmor);
            totalToughness = (float)ArmorUtils.applyToughnessModifier(slot, totalToughness);
        }
        totalArmor = (float)((double)totalArmor + ArmorUtils.getGlobalRestAttribute(entity, Attributes.f_22284_));
        totalToughness = (float)((double)totalToughness + ArmorUtils.getGlobalRestAttribute(entity, Attributes.f_22285_));
        if (damage > 0.0f && (totalArmor > 0.0f || totalToughness > 0.0f)) {
            if (!(!(item instanceof ArmorItem) || source.m_19384_() && item.m_41475_())) {
                int itemDamage = Math.max((int)damage, 1);
                itemStack.m_41622_(itemDamage, (LivingEntity)entity, player -> player.m_21166_(slot));
            }
            damage = CombatRules.m_19272_((float)damage, (float)totalArmor, (float)totalToughness);
        }
        return damage;
    }

    public static float applyGlobalPotionModifiers(Player player, DamageSource source, float damage) {
        int i;
        int j;
        float f;
        float f1;
        float f2;
        if (source.m_19379_()) {
            return damage;
        }
        if (player.m_21023_(MobEffects.f_19606_) && source != DamageSource.f_19317_ && (f2 = (f1 = damage) - (damage = Math.max((f = damage * (float)(j = 100 - (i = (player.m_21124_(MobEffects.f_19606_).m_19564_() + 1) * (Integer)FirstAidConfig.SERVER.resistanceReductionPercentPerLevel.get()))) / 100.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
            if (player instanceof ServerPlayer) {
                player.m_36222_(Stats.f_12934_, Math.round(f2 * 10.0f));
            } else if (source.m_7639_() instanceof ServerPlayer) {
                ((ServerPlayer)source.m_7639_()).m_36222_(Stats.f_12930_, Math.round(f2 * 10.0f));
            }
        }
        return damage;
    }

    public static float applyEnchantmentModifiers(Player player, EquipmentSlot slot, DamageSource source, float damage) {
        int k;
        FirstAidConfig.Server.ArmorEnchantmentMode enchantmentMode = (FirstAidConfig.Server.ArmorEnchantmentMode)((Object)FirstAidConfig.SERVER.armorEnchantmentMode.get());
        if (enchantmentMode == FirstAidConfig.Server.ArmorEnchantmentMode.LOCAL_ENCHANTMENTS) {
            ItemStack itemStackFromSlot = player.m_6844_(slot);
            MutableInt mutableInt = new MutableInt();
            EnchantmentHelper.m_44850_((enchantment, level) -> {
                int val = enchantment.m_7205_(level, source);
                List resourceLocation = (List)FirstAidConfig.SERVER.enchMulOverrideResourceLocations.get();
                List multiplierOverride = (List)FirstAidConfig.SERVER.enchMulOverrideMultiplier.get();
                String enchantRlAsString = enchantment.getRegistryName().toString();
                int multiplier = (Integer)FirstAidConfig.SERVER.enchantmentMultiplier.get();
                boolean debug = (Boolean)FirstAidConfig.GENERAL.debug.get();
                if (debug) {
                    FirstAid.LOGGER.info("Searching for enchantment multiplier override for {}, base is {}", (Object)enchantRlAsString, (Object)multiplier);
                }
                for (int i = 0; i < Math.min(resourceLocation.size(), multiplierOverride.size()); ++i) {
                    String s = (String)resourceLocation.get(i);
                    if (!s.equals(enchantRlAsString)) continue;
                    multiplier = (Integer)multiplierOverride.get(i);
                    if (!debug) break;
                    FirstAid.LOGGER.info("Found enchantment multiplier override for {}, new value is {}", (Object)enchantRlAsString, (Object)multiplier);
                    break;
                }
                mutableInt.add(val * multiplier);
            }, (ItemStack)itemStackFromSlot);
            k = mutableInt.getValue();
        } else if (enchantmentMode == FirstAidConfig.Server.ArmorEnchantmentMode.GLOBAL_ENCHANTMENTS) {
            k = EnchantmentHelper.m_44856_((Iterable)player.m_6168_(), (DamageSource)source);
        } else {
            throw new RuntimeException("What dark magic is " + enchantmentMode);
        }
        if (k > 0) {
            damage = CombatRules.m_19269_((float)damage, (float)k);
        }
        return damage;
    }
}

