/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common;

import com.mojang.brigadier.CommandDispatcher;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.DebugDamageCommand;
import ichttt.mods.firstaid.common.SynchedEntityDataWrapper;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.damagesystem.PlayerDamageModel;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.HealthDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.RandomDamageDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.StandardDamageDistribution;
import ichttt.mods.firstaid.common.items.FirstAidItems;
import ichttt.mods.firstaid.common.network.MessageConfiguration;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.util.CommonUtils;
import ichttt.mods.firstaid.common.util.PlayerSizeHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Pair;

public class EventHandler {
    public static final Random rand = new Random();
    @ObjectHolder(value="firstaid:debuff.heartbeat")
    public static final SoundEvent HEARTBEAT = (SoundEvent)FirstAidItems.getNull();
    @ObjectHolder(value="firstaid:morphine")
    public static final MobEffect MORPHINE = (MobEffect)FirstAidItems.getNull();
    @ObjectHolder(value="minecraft:resistance")
    public static final MobEffect DAMAGE_RESISTANCE = (MobEffect)FirstAidItems.getNull();
    public static final Map<Player, Pair<Entity, HitResult>> hitList = new WeakHashMap<Player, Pair<Entity, HitResult>>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entityProjectile;
        EquipmentSlot slot;
        Pair<Entity, HitResult> rayTraceResult;
        LivingEntity entity = event.getEntityLiving();
        if (entity.f_19853_.f_46443_ || !CommonUtils.hasDamageModel((Entity)entity)) {
            return;
        }
        float amountToDamage = event.getAmount();
        Player player = (Player)entity;
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(player);
        DamageSource source = event.getSource();
        if (amountToDamage == Float.MAX_VALUE) {
            damageModel.forEach(damageablePart -> {
                damageablePart.currentHealth = 0.0f;
            });
            if (player instanceof ServerPlayer) {
                FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageSyncDamageModel(damageModel, false));
            }
            event.setCanceled(true);
            CommonUtils.killPlayer(damageModel, player, source);
            return;
        }
        boolean addStat = amountToDamage < 3.4028235E37f;
        IDamageDistribution damageDistribution = FirstAidRegistryImpl.INSTANCE.getDamageDistributionForSource(source);
        if (source.m_19360_() && (rayTraceResult = hitList.remove(player)) != null && (slot = PlayerSizeHelper.getSlotTypeForProjectileHit(entityProjectile = (Entity)rayTraceResult.getLeft(), player)) != null) {
            EnumPlayerPart[] possibleParts = CommonUtils.getPartArrayForSlot(slot);
            damageDistribution = new StandardDamageDistribution(Collections.singletonList(Pair.of((Object)slot, (Object)possibleParts)), false, true);
        }
        if (damageDistribution == null && (damageDistribution = PlayerSizeHelper.getMeleeDistribution(player, source)) == null) {
            damageDistribution = RandomDamageDistribution.getDefault();
        }
        DamageDistribution.handleDamageTaken(damageDistribution, damageModel, amountToDamage, player, source, addStat, true);
        event.setCanceled(true);
        hitList.remove(player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        HitResult result = event.getRayTraceResult();
        if (result.m_6662_() != HitResult.Type.ENTITY) {
            return;
        }
        Entity entity = ((EntityHitResult)result).m_82443_();
        if (!entity.f_19853_.f_46443_ && entity instanceof Player) {
            hitList.put((Player)entity, (Pair<Entity, HitResult>)Pair.of((Object)event.getEntity(), (Object)event.getRayTraceResult()));
        }
    }

    @SubscribeEvent
    public static void registerCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity obj = (Entity)event.getObject();
        if (CommonUtils.hasDamageModel(obj)) {
            Player player = (Player)obj;
            PlayerDamageModel damageModel = PlayerDamageModel.create();
            event.addCapability(CapProvider.IDENTIFIER, (ICapabilityProvider)new CapProvider(damageModel));
            player.f_19804_ = new SynchedEntityDataWrapper(player, player.f_19804_);
        }
    }

    @SubscribeEvent
    public static void tickPlayers(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_150110_().f_35934_) {
            if (!event.player.m_6084_()) {
                return;
            }
            CommonUtils.getDamageModel(event.player).tick(event.player.f_19853_, event.player);
            hitList.remove(event.player);
        }
    }

    @SubscribeEvent
    public static void onSleepFinished(SleepFinishedTimeEvent event) {
        if (ModList.get().isLoaded("morpheus")) {
            return;
        }
        for (Player player : event.getWorld().m_6907_()) {
            if (!player.m_36317_()) continue;
            CommonUtils.getDamageModel(player).sleepHeal(player);
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        int morphine;
        int plaster;
        int bandage;
        ResourceLocation tableName = event.getName();
        UniformGenerator bandageMax = UniformGenerator.m_165780_((float)1.0f, (float)3.0f);
        UniformGenerator plasterMax = UniformGenerator.m_165780_((float)1.0f, (float)5.0f);
        UniformGenerator morphineMax = UniformGenerator.m_165780_((float)1.0f, (float)2.0f);
        ConstantValue poolRolls = ConstantValue.m_165692_((float)1.0f);
        if (tableName.equals((Object)BuiltInLootTables.f_78740_)) {
            bandage = 8;
            plaster = 16;
            morphine = 4;
            morphineMax = ConstantValue.m_165692_((float)1.0f);
        } else if (tableName.equals((Object)BuiltInLootTables.f_78763_) || tableName.equals((Object)BuiltInLootTables.f_78762_) || tableName.equals((Object)BuiltInLootTables.f_78759_)) {
            bandage = 20;
            plaster = 24;
            morphine = 8;
            poolRolls = UniformGenerator.m_165780_((float)0.0f, (float)1.0f);
        } else if (tableName.equals((Object)BuiltInLootTables.f_78749_)) {
            bandage = 4;
            plaster = 20;
            morphine = 2;
            plasterMax = UniformGenerator.m_165780_((float)3.0f, (float)8.0f);
        } else if (tableName.equals((Object)BuiltInLootTables.f_78688_)) {
            bandage = 4;
            plaster = 8;
            morphine = 2;
            poolRolls = UniformGenerator.m_165780_((float)0.0f, (float)1.0f);
        } else if (tableName.equals((Object)BuiltInLootTables.f_78694_)) {
            bandage = 4;
            plaster = 8;
            morphine = 2;
            bandageMax = UniformGenerator.m_165780_((float)1.0f, (float)2.0f);
            plasterMax = UniformGenerator.m_165780_((float)1.0f, (float)3.0f);
            morphineMax = ConstantValue.m_165692_((float)1.0f);
            poolRolls = UniformGenerator.m_165780_((float)0.0f, (float)1.0f);
        } else {
            return;
        }
        LootPool.Builder builder = LootPool.m_79043_().name("firstaid_main").m_165133_((NumberProvider)poolRolls);
        builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(() -> FirstAidItems.BANDAGE).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)bandageMax)).m_79707_(bandage).m_79711_(0));
        builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(() -> FirstAidItems.PLASTER).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)plasterMax)).m_79707_(plaster).m_79711_(0));
        builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(() -> FirstAidItems.MORPHINE).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)morphineMax)).m_79707_(morphine).m_79711_(0));
        event.getTable().addPool(builder.m_79082_());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!CommonUtils.hasDamageModel((Entity)entity)) {
            return;
        }
        event.setCanceled(true);
        if (entity.f_19853_.f_46443_ || !((Boolean)FirstAidConfig.SERVER.allowOtherHealingItems.get()).booleanValue()) {
            return;
        }
        float amount = event.getAmount();
        if (Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(stackTraceElement -> stackTraceElement.getClassName().equals(FoodData.class.getName()))) {
            if (((Boolean)FirstAidConfig.SERVER.allowNaturalRegeneration.get()).booleanValue()) {
                amount *= (float)((Double)FirstAidConfig.SERVER.naturalRegenMultiplier.get()).doubleValue();
            }
        } else {
            amount *= (float)((Double)FirstAidConfig.SERVER.otherRegenMultiplier.get()).doubleValue();
        }
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            CommonUtils.debugLogStacktrace("External healing: : " + amount);
        }
        HealthDistribution.distributeHealth(amount, (Player)entity, true);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().f_19853_.f_46443_) {
            FirstAid.LOGGER.debug("Sending damage model to " + event.getPlayer().m_7755_());
            AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(event.getPlayer());
            if (damageModel.hasTutorial) {
                CapProvider.tutorialDone.add(event.getPlayer().m_7755_().getString());
            }
            ServerPlayer playerMP = (ServerPlayer)event.getPlayer();
            FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> playerMP), (Object)new MessageConfiguration((CompoundTag)damageModel.serializeNBT()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        hitList.remove(event.getPlayer());
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        LevelAccessor world = event.getWorld();
        if (!world.m_5776_() && world instanceof Level) {
            ((GameRules.BooleanValue)((Level)world).m_46469_().m_46170_(GameRules.f_46139_)).m_46246_(((Boolean)FirstAidConfig.SERVER.allowNaturalRegeneration.get()).booleanValue(), ((Level)world).m_142572_());
        }
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getPlayer();
        if (!player.f_19853_.f_46443_ && player instanceof ServerPlayer) {
            FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageSyncDamageModel(CommonUtils.getDamageModel(player), true));
        }
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppedEvent event) {
        FirstAid.LOGGER.debug("Cleaning up");
        CapProvider.tutorialDone.clear();
        hitList.clear();
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        DebugDamageCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!event.isEndConquered() && !player.f_19853_.f_46443_ && player instanceof ServerPlayer) {
            AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(player);
            damageModel.runScaleLogic(player);
            damageModel.forEach(damageablePart -> damageablePart.heal(damageablePart.getMaxHealth(), player, false));
            damageModel.scheduleResync();
        }
    }
}

