/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.apiimpl;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.FirstAidRegistry;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.damagesystem.AbstractPartHealer;
import ichttt.mods.firstaid.api.debuff.IDebuff;
import ichttt.mods.firstaid.api.debuff.builder.IDebuffBuilder;
import ichttt.mods.firstaid.api.enums.EnumDebuffSlot;
import ichttt.mods.firstaid.common.apiimpl.DebuffBuilder;
import ichttt.mods.firstaid.common.damagesystem.debuff.ConstantDebuff;
import ichttt.mods.firstaid.common.damagesystem.debuff.OnHitDebuff;
import ichttt.mods.firstaid.common.damagesystem.debuff.SharedDebuff;
import ichttt.mods.firstaid.common.damagesystem.distribution.RandomDamageDistribution;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class FirstAidRegistryImpl
extends FirstAidRegistry {
    public static final FirstAidRegistryImpl INSTANCE = new FirstAidRegistryImpl();
    private final ArrayList<Pair<Predicate<DamageSource>, IDamageDistribution>> distributionsDynamic = new ArrayList();
    private final Map<String, IDamageDistribution> distributionsStatic = new HashMap<String, IDamageDistribution>();
    private final Map<Item, Pair<Function<ItemStack, AbstractPartHealer>, Function<ItemStack, Integer>>> healerMap = new HashMap<Item, Pair<Function<ItemStack, AbstractPartHealer>, Function<ItemStack, Integer>>>();
    private final Multimap<EnumDebuffSlot, Supplier<IDebuff>> debuffs = HashMultimap.create();
    private boolean registrationAllowed = true;

    public static void finish() {
        FirstAidRegistry registryImpl = FirstAidRegistry.getImpl();
        if (registryImpl == null) {
            throw new IllegalStateException("The apiimpl has not been set! Something went seriously wrong!");
        }
        if (registryImpl != INSTANCE) {
            throw new IllegalStateException("A mod has registered a custom apiimpl for the registry. THIS IS NOT ALLOWED!It should be " + INSTANCE.getClass().getName() + " but it actually is " + registryImpl.getClass().getName());
        }
        FirstAidRegistryImpl.INSTANCE.registrationAllowed = false;
        FirstAidRegistryImpl.INSTANCE.distributionsDynamic.trimToSize();
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            FirstAid.LOGGER.info("REG READOUT:");
            for (Map.Entry<String, IDamageDistribution> entry : FirstAidRegistryImpl.INSTANCE.distributionsStatic.entrySet()) {
                FirstAid.LOGGER.info("{} bound to {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
            FirstAid.LOGGER.info("+{} additional dynamic distributions", (Object)FirstAidRegistryImpl.INSTANCE.distributionsDynamic.size());
        }
    }

    @Override
    public void registerHealingType(@Nonnull Item item, @Nonnull Function<ItemStack, AbstractPartHealer> factory, Function<ItemStack, Integer> applyTime) {
        if (this.healerMap.containsKey(item)) {
            FirstAid.LOGGER.warn("Healing type override detected for item " + item);
        }
        this.healerMap.put(item, (Pair<Function<ItemStack, AbstractPartHealer>, Function<ItemStack, Integer>>)Pair.of(factory, applyTime));
    }

    @Override
    @Nullable
    public AbstractPartHealer getPartHealer(@Nonnull ItemStack type) {
        Pair<Function<ItemStack, AbstractPartHealer>, Function<ItemStack, Integer>> pair = this.healerMap.get(type.m_41720_());
        if (pair != null) {
            return (AbstractPartHealer)((Function)pair.getLeft()).apply(type);
        }
        return null;
    }

    @Override
    public Integer getPartHealingTime(@Nonnull ItemStack stack) {
        Pair<Function<ItemStack, AbstractPartHealer>, Function<ItemStack, Integer>> pair = this.healerMap.get(stack.m_41720_());
        if (pair != null) {
            return (Integer)((Function)pair.getRight()).apply(stack);
        }
        return null;
    }

    @Override
    public void registerDebuff(@Nonnull EnumDebuffSlot slot, @Nonnull IDebuffBuilder abstractBuilder) {
        Supplier<IDebuff> debuff;
        DebuffBuilder builder;
        try {
            builder = (DebuffBuilder)abstractBuilder;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Builder must an instance of the default builder received via DebuffBuilderFactory!", e);
        }
        FirstAid.LOGGER.debug("Building debuff from mod {} for slot {} with potion effect {}, type = {}", (Object)CommonUtils.getActiveModidSafe(), (Object)slot, (Object)builder.potionName, (Object)(builder.isOnHit ? "OnHit" : "Constant"));
        BooleanSupplier isEnabled = builder.isEnabledSupplier == null ? () -> true : builder.isEnabledSupplier;
        Preconditions.checkArgument((!builder.map.isEmpty() ? 1 : 0) != 0, (Object)"Failed to register debuff with condition has set");
        if (builder.isOnHit) {
            debuff = () -> new OnHitDebuff(builder.potionName, builder.map, isEnabled, builder.sound);
        } else {
            Preconditions.checkArgument((builder.sound == null ? 1 : 0) != 0, (Object)"Tried to register constant debuff with sound effect.");
            debuff = () -> new ConstantDebuff(builder.potionName, builder.map, isEnabled);
        }
        this.registerDebuff(slot, debuff);
    }

    @Override
    public synchronized void registerDebuff(@Nonnull EnumDebuffSlot slot, @Nonnull Supplier<IDebuff> debuff) {
        if (!this.registrationAllowed) {
            throw new IllegalStateException("Registration must take place before FMLLoadCompleteEvent");
        }
        if (slot.playerParts.length > 1 && !(debuff instanceof SharedDebuff)) {
            this.debuffs.put((Object)slot, () -> new SharedDebuff((IDebuff)debuff.get(), slot));
            return;
        }
        this.debuffs.put((Object)slot, debuff);
    }

    @Override
    @Nonnull
    public IDamageDistribution getDamageDistribution(@Nonnull DamageSource source) {
        IDamageDistribution distribution = this.getDamageDistributionForSource(source);
        if (distribution == null) {
            distribution = RandomDamageDistribution.getDefault();
        }
        return distribution;
    }

    @Override
    @Nullable
    public IDamageDistribution getDamageDistributionForSource(@Nonnull DamageSource source) {
        IDamageDistribution distribution = this.distributionsStatic.get(source.f_19326_);
        if (distribution == null) {
            for (Pair<Predicate<DamageSource>, IDamageDistribution> pair : this.distributionsDynamic) {
                if (!((Predicate)pair.getLeft()).test(source)) continue;
                distribution = (IDamageDistribution)pair.getRight();
                break;
            }
        }
        return distribution;
    }

    @Override
    @Nonnull
    public IDebuff[] getDebuffs(@Nonnull EnumDebuffSlot slot) {
        return (IDebuff[])this.debuffs.get((Object)slot).stream().map(Supplier::get).toArray(IDebuff[]::new);
    }

    public void registerDistribution(Predicate<DamageSource> matcher, IDamageDistribution distribution) {
        if (!this.registrationAllowed) {
            throw new IllegalStateException("Too late to register!");
        }
        this.distributionsDynamic.add((Pair<Predicate<DamageSource>, IDamageDistribution>)Pair.of(matcher, (Object)distribution));
    }

    public void registerDistribution(DamageSource[] sources, IDamageDistribution distribution) {
        if (!this.registrationAllowed) {
            throw new IllegalStateException("Too late to register!");
        }
        for (DamageSource damageType : sources) {
            if (this.distributionsStatic.containsKey(damageType.f_19326_)) {
                FirstAid.LOGGER.info("Damage Distribution override detected for source " + damageType);
            }
            this.distributionsStatic.put(damageType.f_19326_, distribution);
        }
    }
}

