/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem.distribution;

import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;

public class StandardDamageDistribution
extends DamageDistribution {
    private final List<Pair<EquipmentSlot, EnumPlayerPart[]>> partList;
    private final boolean shuffle;
    private final boolean doNeighbours;
    private final EnumSet<EnumPlayerPart> blockedParts;

    public StandardDamageDistribution(List<Pair<EquipmentSlot, EnumPlayerPart[]>> partList, boolean shuffle, boolean doNeighbours) {
        this.partList = partList;
        for (Pair<EquipmentSlot, EnumPlayerPart[]> pair : partList) {
            for (EnumPlayerPart part : (EnumPlayerPart[])pair.getRight()) {
                if (part.slot == pair.getLeft()) continue;
                throw new RuntimeException(part + " is not a member of " + pair.getLeft());
            }
        }
        this.shuffle = shuffle;
        this.doNeighbours = doNeighbours;
        this.blockedParts = EnumSet.noneOf(EnumPlayerPart.class);
    }

    private StandardDamageDistribution(List<Pair<EquipmentSlot, EnumPlayerPart[]>> partList, boolean shuffle, boolean doNeighbours, EnumSet<EnumPlayerPart> blockedParts) {
        this.partList = partList;
        this.shuffle = shuffle;
        this.doNeighbours = doNeighbours;
        this.blockedParts = blockedParts;
    }

    @Override
    @Nonnull
    protected List<Pair<EquipmentSlot, EnumPlayerPart[]>> getPartList() {
        if (this.shuffle) {
            Collections.shuffle(this.partList);
        }
        return this.partList;
    }

    @Override
    public float distributeDamage(float damage, @Nonnull Player player, @Nonnull DamageSource source, boolean addStat) {
        float rest = super.distributeDamage(damage, player, source, addStat);
        if (rest > 0.0f && this.doNeighbours) {
            EnumSet<EnumPlayerPart> neighboursSet = EnumSet.noneOf(EnumPlayerPart.class);
            EnumSet<EnumPlayerPart> blockedParts = EnumSet.copyOf(this.blockedParts);
            for (Pair<EquipmentSlot, EnumPlayerPart[]> pair : this.partList) {
                blockedParts.addAll(Arrays.asList((EnumPlayerPart[])pair.getRight()));
            }
            for (int i = this.partList.size() - 1; i >= 0; --i) {
                EnumPlayerPart[] parts;
                for (EnumPlayerPart enumPlayerPart : parts = (EnumPlayerPart[])this.partList.get(i).getRight()) {
                    neighboursSet.addAll((Collection<EnumPlayerPart>)enumPlayerPart.getNeighbours());
                }
                neighboursSet.removeIf(blockedParts::contains);
                if (neighboursSet.isEmpty()) continue;
                ArrayList<EnumPlayerPart> neighbours = new ArrayList<EnumPlayerPart>(neighboursSet);
                Collections.shuffle(neighbours);
                LinkedHashMap<EquipmentSlot, List> neighbourMapping = new LinkedHashMap<EquipmentSlot, List>();
                for (EnumPlayerPart enumPlayerPart : neighbours) {
                    neighbourMapping.computeIfAbsent(enumPlayerPart.slot, type -> new ArrayList(3)).add(enumPlayerPart);
                }
                ArrayList<Pair<EquipmentSlot, EnumPlayerPart[]>> neighbourDistributions = new ArrayList<Pair<EquipmentSlot, EnumPlayerPart[]>>();
                for (Map.Entry entry : neighbourMapping.entrySet()) {
                    neighbourDistributions.add((Pair<EquipmentSlot, EnumPlayerPart[]>)Pair.of((Object)((EquipmentSlot)entry.getKey()), (Object)((List)entry.getValue()).toArray(new EnumPlayerPart[0])));
                }
                StandardDamageDistribution standardDamageDistribution = new StandardDamageDistribution(neighbourDistributions, false, true, blockedParts);
                if ((rest = standardDamageDistribution.distributeDamage(rest, player, source, addStat)) <= 0.0f) break;
                blockedParts = standardDamageDistribution.blockedParts;
                neighboursSet.clear();
            }
        }
        return rest;
    }
}

