/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.client.DebuffTimedSound;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MessagePlayHurtSound {
    private final SoundEvent sound;
    private final int duration;

    public MessagePlayHurtSound(FriendlyByteBuf buffer) {
        this((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buffer.m_130281_()), buffer.readInt());
    }

    public MessagePlayHurtSound(SoundEvent sound, int duration) {
        this.sound = sound;
        this.duration = duration;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(Objects.requireNonNull(this.sound.getRegistryName()));
        buf.writeInt(this.duration);
    }

    public static class Handler {
        public static void onMessage(MessagePlayHurtSound message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            CommonUtils.checkClient(ctx);
            ctx.enqueueWork(() -> DebuffTimedSound.playHurtSound(message.sound, message.duration));
        }
    }
}

