/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageSyncDamageModel {
    private final CompoundTag playerDamageModel;
    private final boolean scaleMaxHealth;

    public MessageSyncDamageModel(FriendlyByteBuf buffer) {
        this.playerDamageModel = buffer.m_130260_();
        this.scaleMaxHealth = buffer.readBoolean();
    }

    public MessageSyncDamageModel(AbstractPlayerDamageModel damageModel, boolean scaleMaxHealth) {
        this.playerDamageModel = (CompoundTag)damageModel.serializeNBT();
        this.scaleMaxHealth = scaleMaxHealth;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.playerDamageModel);
        buffer.writeBoolean(this.scaleMaxHealth);
    }

    public static final class Handler {
        public static void onMessage(MessageSyncDamageModel message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            CommonUtils.checkClient(ctx);
            ctx.enqueueWork(() -> {
                Minecraft mc = Minecraft.m_91087_();
                AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((Player)mc.f_91074_);
                if (message.scaleMaxHealth) {
                    damageModel.runScaleLogic((Player)mc.f_91074_);
                }
                damageModel.deserializeNBT((Tag)message.playerDamageModel);
            });
        }
    }
}

