/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.util;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.AABBAlignedBoundingBox;
import ichttt.mods.firstaid.common.damagesystem.distribution.StandardDamageDistribution;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class PlayerSizeHelper {
    private static final Map<EquipmentSlot, AABBAlignedBoundingBox> NORMAL_BOXES;
    private static final Map<EquipmentSlot, AABBAlignedBoundingBox> SNEAKING_BOXES;

    @Nonnull
    public static Map<EquipmentSlot, AABBAlignedBoundingBox> getBoxes(Entity entity) {
        switch (entity.m_20089_()) {
            case STANDING: {
                return NORMAL_BOXES;
            }
            case CROUCHING: {
                return SNEAKING_BOXES;
            }
            case SPIN_ATTACK: 
            case FALL_FLYING: {
                return Collections.emptyMap();
            }
        }
        return Collections.emptyMap();
    }

    public static EquipmentSlot getSlotTypeForProjectileHit(Entity hittingObject, Player toTest) {
        float[] inflationSteps;
        Map<EquipmentSlot, AABBAlignedBoundingBox> toUse = PlayerSizeHelper.getBoxes((Entity)toTest);
        Vec3 oldPosition = hittingObject.m_20182_();
        Vec3 newPosition = oldPosition.m_82549_(hittingObject.m_20184_());
        for (float inflation : inflationSteps = new float[]{0.01f, 0.1f, 0.2f, 0.3f}) {
            EquipmentSlot bestSlot = null;
            double bestValue = Double.MAX_VALUE;
            for (Map.Entry<EquipmentSlot, AABBAlignedBoundingBox> entry : toUse.entrySet()) {
                double d2;
                double d1;
                AABB axisalignedbb = entry.getValue().createAABB(toTest.m_142469_()).m_82400_((double)inflation);
                Optional optional = axisalignedbb.m_82371_(oldPosition, newPosition);
                if (!optional.isPresent() || !((d1 = oldPosition.m_82557_((Vec3)optional.get())) + (d2 = 0.0) < bestValue)) continue;
                bestSlot = entry.getKey();
                bestValue = d1 + d2;
            }
            if (bestSlot == null) continue;
            if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                FirstAid.LOGGER.info("getSlotTypeForProjectileHit: Inflation: " + inflation + " best slot: " + bestSlot);
            }
            return bestSlot;
        }
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            FirstAid.LOGGER.info("getSlotTypeForProjectileHit: Not found!");
        }
        return null;
    }

    public static IDamageDistribution getMeleeDistribution(Player player, DamageSource source) {
        Map<EquipmentSlot, AABBAlignedBoundingBox> boxes;
        Mob mobEntity;
        Entity causingEntity = source.m_7639_();
        if (causingEntity != null && causingEntity == source.m_7640_() && causingEntity instanceof Mob && (mobEntity = (Mob)causingEntity).m_5448_() == player && mobEntity.f_21345_.m_25386_().anyMatch(prioritizedGoal -> prioritizedGoal.m_26015_() instanceof MeleeAttackGoal) && !(boxes = PlayerSizeHelper.getBoxes((Entity)player)).isEmpty()) {
            ArrayList<EquipmentSlot> allowedParts = new ArrayList<EquipmentSlot>();
            AABB modAABB = mobEntity.m_142469_().m_82377_((double)(mobEntity.m_20205_() * 2.0f + player.m_20205_()), 0.0, (double)(mobEntity.m_20205_() * 2.0f + player.m_20205_()));
            for (Map.Entry<EquipmentSlot, AABBAlignedBoundingBox> entry : boxes.entrySet()) {
                AABB partAABB = entry.getValue().createAABB(player.m_142469_());
                if (!modAABB.m_82381_(partAABB)) continue;
                allowedParts.add(entry.getKey());
            }
            if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                FirstAid.LOGGER.info("getMeleeDistribution: Has distribution with {}", allowedParts);
            }
            if (allowedParts.isEmpty() && player.m_20186_() > mobEntity.m_20186_() && player.m_20186_() - mobEntity.m_20186_() < (double)(mobEntity.m_20206_() * 2.0f)) {
                if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                    FirstAid.LOGGER.info("Hack adding feet");
                }
                allowedParts.add(EquipmentSlot.FEET);
            }
            if (!allowedParts.isEmpty() && !allowedParts.containsAll(Arrays.asList(CommonUtils.ARMOR_SLOTS))) {
                ArrayList<Pair<EquipmentSlot, EnumPlayerPart[]>> list = new ArrayList<Pair<EquipmentSlot, EnumPlayerPart[]>>();
                for (EquipmentSlot allowedPart : allowedParts) {
                    list.add((Pair<EquipmentSlot, EnumPlayerPart[]>)Pair.of((Object)allowedPart, (Object)CommonUtils.getPartArrayForSlot(allowedPart)));
                }
                return new StandardDamageDistribution(list, true, true);
            }
        }
        return null;
    }

    static {
        LinkedHashMap<EquipmentSlot, AABBAlignedBoundingBox> builder = new LinkedHashMap<EquipmentSlot, AABBAlignedBoundingBox>();
        builder.put(EquipmentSlot.FEET, new AABBAlignedBoundingBox(0.0, 0.0, 0.0, 1.0, 0.15, 1.0));
        builder.put(EquipmentSlot.LEGS, new AABBAlignedBoundingBox(0.0, 0.15, 0.0, 1.0, 0.45, 1.0));
        builder.put(EquipmentSlot.CHEST, new AABBAlignedBoundingBox(0.0, 0.45, 0.0, 1.0, 0.8, 1.0));
        builder.put(EquipmentSlot.HEAD, new AABBAlignedBoundingBox(0.0, 0.8, 0.0, 1.0, 1.0, 1.0));
        NORMAL_BOXES = Collections.unmodifiableMap(builder);
        builder = new LinkedHashMap();
        builder.put(EquipmentSlot.FEET, new AABBAlignedBoundingBox(0.0, 0.0, 0.0, 1.0, 0.15, 1.0));
        builder.put(EquipmentSlot.LEGS, new AABBAlignedBoundingBox(0.0, 0.15, 0.0, 1.0, 0.4, 1.0));
        builder.put(EquipmentSlot.CHEST, new AABBAlignedBoundingBox(0.0, 0.4, 0.0, 1.0, 0.75, 1.0));
        builder.put(EquipmentSlot.HEAD, new AABBAlignedBoundingBox(0.0, 0.75, 0.0, 1.0, 1.0, 1.0));
        SNEAKING_BOXES = Collections.unmodifiableMap(builder);
    }
}

