/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractPartHealer;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.client.ClientHooks;
import ichttt.mods.firstaid.client.HUDHandler;
import ichttt.mods.firstaid.client.gui.FirstaidIngameGui;
import ichttt.mods.firstaid.client.gui.GuiHealthScreen;
import ichttt.mods.firstaid.client.tutorial.GuiTutorial;
import ichttt.mods.firstaid.client.util.EventCalendar;
import ichttt.mods.firstaid.client.util.PlayerModelRenderer;
import ichttt.mods.firstaid.common.AABBAlignedBoundingBox;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.RegistryObjects;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.apiimpl.RegistryManager;
import ichttt.mods.firstaid.common.util.ArmorUtils;
import ichttt.mods.firstaid.common.util.CommonUtils;
import ichttt.mods.firstaid.common.util.PlayerSizeHelper;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventHandler {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");
    private static int id;

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null || mc.f_91074_.f_108617_ == null || mc.m_91104_()) {
            return;
        }
        if (EventCalendar.isGuiFun()) {
            GuiHealthScreen.BED_ITEMSTACK.m_41721_(id);
            if (mc.f_91073_ != null && mc.f_91073_.m_46467_() % 3L == 0L) {
                ++id;
            }
            if (id > 15) {
                id = 0;
            }
            GuiHealthScreen.tickFun();
            PlayerModelRenderer.tickFun();
        }
        if (!RegistryManager.debuffConfigErrors.isEmpty() && mc.f_91073_ != null && mc.f_91073_.f_46443_) {
            mc.f_91074_.m_5661_((Component)Component.m_237113_((String)"[FirstAid] FirstAid has detected invalid debuff config entries."), false);
            for (String s : RegistryManager.debuffConfigErrors) {
                mc.f_91074_.m_5661_((Component)Component.m_237113_((String)("[FirstAid] " + s)), false);
            }
            RegistryManager.debuffConfigErrors.clear();
        }
        if (HUDHandler.INSTANCE.ticker >= 0) {
            --HUDHandler.INSTANCE.ticker;
        }
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent event) {
        if (ClientHooks.SHOW_WOUNDS.m_90859_()) {
            Minecraft mc = Minecraft.m_91087_();
            AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((Player)mc.f_91074_);
            if (!damageModel.hasTutorial) {
                damageModel.hasTutorial = true;
                CapProvider.tutorialDone.add(mc.f_91074_.m_7755_().getString());
                Minecraft.m_91087_().m_91152_((Screen)new GuiTutorial());
            } else {
                mc.m_91152_((Screen)new GuiHealthScreen(damageModel));
            }
        }
    }

    @SubscribeEvent
    public static void preRender(RenderGuiOverlayEvent.Pre event) {
        FirstAidConfig.Client.VanillaHealthbarMode vanillaHealthBarMode;
        NamedGuiOverlay overlay = event.getOverlay();
        if (overlay == VanillaGuiOverlay.PLAYER_HEALTH.type() && (vanillaHealthBarMode = (FirstAidConfig.Client.VanillaHealthbarMode)((Object)FirstAidConfig.CLIENT.vanillaHealthBarMode.get())) != FirstAidConfig.Client.VanillaHealthbarMode.NORMAL) {
            event.setCanceled(true);
            ForgeGui gui = (ForgeGui)Minecraft.m_91087_().f_91065_;
            if (gui.shouldDrawSurvivalElements() && vanillaHealthBarMode == FirstAidConfig.Client.VanillaHealthbarMode.HIGHLIGHT_CRITICAL_PATH && FirstAidConfig.SERVER.vanillaHealthCalculation.get() == FirstAidConfig.Server.VanillaHealthCalculationMode.AVERAGE_ALL) {
                FirstaidIngameGui.renderHealth((ForgeGui)Minecraft.m_91087_().f_91065_, event.getWindow().m_85445_(), event.getWindow().m_85446_(), event.getPoseStack());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingRender(RenderLivingEvent.Post<Player, PlayerModel<Player>> event) {
        EntityRenderDispatcher renderDispatcher;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && (renderDispatcher = Minecraft.m_91087_().m_91290_()).m_114377_()) {
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            if (entity.m_6047_()) {
                poseStack.m_85837_(0.0, 0.125, 0.0);
            }
            AABB aabb = entity.m_20191_();
            Collection<AABBAlignedBoundingBox> allBoxes = PlayerSizeHelper.getBoxes((Entity)entity).values();
            float r = 0.25f;
            float g = 1.0f;
            float b = 1.0f;
            for (AABBAlignedBoundingBox box : allBoxes) {
                AABB bbox = box.createAABB(aabb);
                LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)event.getMultiBufferSource().m_6299_(RenderType.m_110504_()), (AABB)bbox.m_82400_(0.02).m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_()), (float)r, (float)g, (float)b, (float)1.0f);
                r += 0.25f;
                g += 0.5f;
                b += 0.1f;
                r %= 1.0f;
                g %= 1.0f;
                b %= 1.0f;
            }
            poseStack.m_85849_();
        }
    }

    private static Component makeArmorMsg(double value) {
        return Component.m_237110_((String)"firstaid.specificarmor", (Object[])new Object[]{FORMAT.format(value)}).m_130940_(ChatFormatting.BLUE);
    }

    private static Component makeToughnessMsg(double value) {
        return Component.m_237110_((String)"firstaid.specifictoughness", (Object[])new Object[]{FORMAT.format(value)}).m_130940_(ChatFormatting.BLUE);
    }

    private static <T> void replaceOrAppend(List<T> list, T search, T replace) {
        int index = list.indexOf(search);
        if (FirstAidConfig.CLIENT.armorTooltipMode.get() == FirstAidConfig.Client.TooltipMode.REPLACE && index >= 0) {
            list.set(index, replace);
        } else {
            list.add(replace);
        }
    }

    @SubscribeEvent
    public static void tooltipItems(ItemTooltipEvent event) {
        AbstractPartHealer healer;
        List list;
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item == RegistryObjects.MORPHINE.get()) {
            event.getToolTip().add(Component.m_237110_((String)"firstaid.tooltip.morphine", (Object[])new Object[]{"3:30-4:30"}));
            return;
        }
        if (FirstAidConfig.CLIENT.armorTooltipMode.get() != FirstAidConfig.Client.TooltipMode.NONE && item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            List tooltip = event.getToolTip();
            double normalArmor = ArmorUtils.getArmor(stack, armor.m_40402_());
            double totalArmor = ArmorUtils.applyArmorModifier(armor.m_40402_(), normalArmor);
            if (totalArmor > 0.0) {
                MutableComponent original = Component.m_237110_((String)"attribute.modifier.plus.0", (Object[])new Object[]{FORMAT.format(normalArmor), Component.m_237115_((String)"attribute.name.generic.armor")}).m_130940_(ChatFormatting.BLUE);
                ClientEventHandler.replaceOrAppend(tooltip, original, ClientEventHandler.makeArmorMsg(totalArmor));
            }
            double normalToughness = ArmorUtils.getArmorToughness(stack, armor.m_40402_());
            double totalToughness = ArmorUtils.applyToughnessModifier(armor.m_40402_(), normalToughness);
            if (totalToughness > 0.0) {
                MutableComponent original = Component.m_237110_((String)"attribute.modifier.plus.0", (Object[])new Object[]{FORMAT.format(normalToughness), Component.m_237115_((String)"attribute.name.generic.armor_toughness")}).m_130940_(ChatFormatting.BLUE);
                ClientEventHandler.replaceOrAppend(tooltip, original, ClientEventHandler.makeToughnessMsg(totalToughness));
            }
        }
        if (item instanceof PotionItem && !(list = PotionUtils.m_43547_((ItemStack)stack)).isEmpty()) {
            for (MobEffectInstance potionEffect : list) {
                MobEffect potion;
                Map map;
                if (potionEffect.m_19544_() != MobEffects.f_19606_ || (map = (potion = potionEffect.m_19544_()).m_19485_()).isEmpty()) continue;
                for (Map.Entry entry : map.entrySet()) {
                    AttributeModifier falseModifier = (AttributeModifier)entry.getValue();
                    AttributeModifier realModifier = new AttributeModifier(falseModifier.m_22214_(), potion.m_7048_(potionEffect.m_19564_(), falseModifier), falseModifier.m_22217_());
                    double d1 = realModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && realModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? realModifier.m_22218_() : realModifier.m_22218_() * 100.0;
                    MutableComponent raw = Component.m_237110_((String)("attribute.modifier.plus." + realModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE);
                    List toolTip = event.getToolTip();
                    int index = toolTip.indexOf(raw);
                    if (index == -1) continue;
                    MutableComponent replacement = Component.m_237110_((String)("attribute.modifier.plus." + realModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 * (double)((float)((Integer)FirstAidConfig.SERVER.resistanceReductionPercentPerLevel.get()).intValue() / 20.0f)), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE);
                    toolTip.set(index, replacement);
                }
            }
        }
        if ((healer = FirstAidRegistryImpl.INSTANCE.getPartHealer(stack)) != null && event.getEntity() != null) {
            event.getToolTip().add(Component.m_237110_((String)"firstaid.tooltip.healer", (Object[])new Object[]{healer.maxHeal.getAsInt() / 2, StringUtil.m_14404_((int)healer.ticksPerHeal.getAsInt())}));
        }
    }

    @SubscribeEvent
    public static void onDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        FirstAid.isSynced = false;
        HUDHandler.INSTANCE.ticker = -1;
    }
}

